/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.worker.actors;

import akka.actor.AbstractActor;
import akka.actor.ActorContext;
import akka.actor.ActorRef;
import akka.actor.Props;
import akka.japi.Creator;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.powerjob.common.request.ServerDeployContainerRequest;
import tech.powerjob.common.request.ServerDestroyContainerRequest;
import tech.powerjob.common.request.ServerQueryInstanceStatusReq;
import tech.powerjob.common.request.ServerScheduleJobReq;
import tech.powerjob.common.request.ServerStopInstanceReq;
import tech.powerjob.worker.container.OmsContainerFactory;

public class WorkerActor
extends AbstractActor {
    private static final Logger log = LoggerFactory.getLogger(WorkerActor.class);
    private final ActorRef taskTrackerActorRef;

    public static Props props(ActorRef taskTrackerActorRef) {
        return Props.create(WorkerActor.class, (Creator & Serializable)() -> new WorkerActor(taskTrackerActorRef));
    }

    public AbstractActor.Receive createReceive() {
        return this.receiveBuilder().match(ServerDeployContainerRequest.class, this::onReceiveServerDeployContainerRequest).match(ServerDestroyContainerRequest.class, this::onReceiveServerDestroyContainerRequest).match(ServerScheduleJobReq.class, this::forward2TaskTracker).match(ServerStopInstanceReq.class, this::forward2TaskTracker).match(ServerQueryInstanceStatusReq.class, this::forward2TaskTracker).matchAny(obj -> log.warn("[WorkerActor] receive unknown request: {}.", obj)).build();
    }

    private void onReceiveServerDeployContainerRequest(ServerDeployContainerRequest request) {
        OmsContainerFactory.deployContainer(request);
    }

    private void onReceiveServerDestroyContainerRequest(ServerDestroyContainerRequest request) {
        OmsContainerFactory.destroyContainer(request.getContainerId());
    }

    private void forward2TaskTracker(Object obj) {
        this.taskTrackerActorRef.forward(obj, (ActorContext)this.getContext());
    }

    public WorkerActor(ActorRef taskTrackerActorRef) {
        this.taskTrackerActorRef = taskTrackerActorRef;
    }
}

