/*
 * Decompiled with CFR 0.152.
 */
package manifold.graphql.type;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import manifold.api.fs.IFile;
import manifold.api.util.cache.FqnCache;
import manifold.graphql.type.GqlIssue;
import manifold.graphql.type.GqlManifold;
import manifold.graphql.type.GqlScope;
import manifold.internal.javac.IIssue;
import manifold.json.rt.Json;
import manifold.rt.api.Bindings;
import manifold.rt.api.util.ManClassUtil;
import manifold.rt.api.util.StreamUtil;
import manifold.util.concurrent.LocklessLazyVar;

public class GqlScopeFinder {
    public static final String GRAPHQLCONFIG_EXT = "graphqlconfig";
    private final GqlManifold _gqlManifold;
    private final LocklessLazyVar<Set<GqlScope>> _scopes;

    GqlScopeFinder(GqlManifold gqlManifold) {
        this._gqlManifold = gqlManifold;
        this._scopes = LocklessLazyVar.make(() -> this.findScopes());
    }

    Set<GqlScope> getScopes() {
        return (Set)this._scopes.get();
    }

    GqlScope findScope(IFile file) {
        return ((Set)this._scopes.get()).stream().filter(scope -> scope.contains(file)).findFirst().orElse(null);
    }

    private Set<GqlScope> findScopes() {
        FqnCache extensionCache = this._gqlManifold.getModule().getPathCache().getExtensionCache(GRAPHQLCONFIG_EXT);
        HashSet<GqlScope> scopes = new HashSet<GqlScope>();
        extensionCache.visitDepthFirst(file -> {
            if (file != null) {
                scopes.addAll(this.makeScope((IFile)file));
            }
            return true;
        });
        if (scopes.isEmpty()) {
            scopes.add(GqlScope.getDefaultScope(this._gqlManifold));
        }
        return scopes;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Set<GqlScope> makeScope(IFile configFile) {
        try (InputStreamReader reader = new InputStreamReader(configFile.openInputStream());){
            Bindings bindings = (Bindings)Json.fromJson((String)StreamUtil.getContent((Reader)reader));
            Set<GqlScope> set = this.makeScopes(bindings, configFile);
            return set;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Set<GqlScope> makeScopes(Bindings bindings, IFile configFile) {
        HashSet<GqlScope> scopes = new HashSet<GqlScope>();
        HashSet<String> schemaFiles = new HashSet<String>();
        ArrayList<String> includes = new ArrayList<String>();
        ArrayList<String> excludes = new ArrayList<String>();
        ArrayList<IIssue> issues = new ArrayList<IIssue>();
        if (bindings.containsKey((Object)"schemaPath")) {
            schemaFiles.add((String)bindings.get((Object)"schemaPath"));
            String name = (String)bindings.get((Object)"name");
            this.validateConfigName(name, issues);
            schemaFiles.forEach(s -> this.validateSchemaName(configFile, (String)s, (List<IIssue>)issues));
            scopes.add(new GqlScope(this._gqlManifold, configFile, name, schemaFiles, includes, excludes, issues));
        } else if (bindings.containsKey((Object)"schema")) {
            Object schema = bindings.get((Object)"schema");
            if (schema instanceof String) {
                schemaFiles.add((String)schema);
            } else if (schema instanceof List) {
                schemaFiles.addAll((List)schema);
            } else {
                issues.add(new GqlIssue(IIssue.Kind.Error, 0, 0, 0, "Illegal .graphqlconfig format. Expecting string or array for schema[s], found " + schema.getClass().getSimpleName()));
            }
            schemaFiles.forEach(s -> this.validateSchemaName(configFile, (String)s, (List<IIssue>)issues));
            String name = (String)bindings.get((Object)"name");
            this.validateConfigName(name, issues);
            scopes.add(new GqlScope(this._gqlManifold, configFile, name, schemaFiles, includes, excludes, issues));
        } else if (bindings.containsKey((Object)"projects")) {
            for (Bindings project : (List)bindings.get((Object)"projects")) {
                for (Map.Entry entry : project.entrySet()) {
                    Set<GqlScope> gqlScopes = this.makeScopes(project, configFile);
                    if (gqlScopes.isEmpty()) continue;
                    String name = (String)entry.getKey();
                    this.validateConfigName(name, issues);
                    gqlScopes.iterator().next().setName(name);
                }
            }
        }
        return scopes;
    }

    private void validateSchemaName(IFile configFile, String schemaFile, List<IIssue> issues) {
        if (!configFile.getParent().file(schemaFile).exists()) {
            issues.add(new GqlIssue(IIssue.Kind.Error, 0, 0, 0, "Schema path '" + schemaFile + "' does not exist."));
        }
    }

    private void validateConfigName(String name, List<IIssue> issues) {
        if (name != null && !ManClassUtil.isJavaIdentifier((String)name)) {
            issues.add(new GqlIssue(IIssue.Kind.Warning, 0, 0, 0, "\"name\" must be a valid Java identifier, otherwise Manifold fragments cannot be used with the config."));
        }
    }
}

