/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.states;

import java.util.Optional;

public class SessionStateField<T> {
    private Optional<T> value = Optional.empty();
    private Optional<T> pristineValue = Optional.empty();

    public SessionStateField<T> copy() {
        SessionStateField<T> newField = new SessionStateField<T>();
        if (this.value.isPresent()) {
            newField.setValue(this.value.get());
        }
        if (this.pristineValue.isPresent()) {
            newField.setPristineValue(this.pristineValue.get());
        }
        return newField;
    }

    public Optional<T> getValue() {
        return this.value;
    }

    public Optional<T> getPristineValue() {
        return this.pristineValue;
    }

    public void setValue(T value) {
        this.value = Optional.ofNullable(value);
    }

    public void setPristineValue(T value) {
        this.pristineValue = Optional.ofNullable(value);
    }

    public void resetValue() {
        this.value = Optional.empty();
    }

    public void resetPristineValue() {
        this.pristineValue = Optional.empty();
    }

    public void reset() {
        this.resetValue();
        this.resetPristineValue();
    }

    public boolean isPristine() {
        if (!this.value.isPresent()) {
            return true;
        }
        if (!this.pristineValue.isPresent()) {
            return false;
        }
        return this.value.get().equals(this.pristineValue.get());
    }

    public boolean canRestorePristine() {
        if (!this.pristineValue.isPresent()) {
            return false;
        }
        if (this.value.isPresent()) {
            return !this.value.get().equals(this.pristineValue.get());
        }
        return true;
    }

    public String toString() {
        return String.format("%s -> %s", this.pristineValue.isPresent() ? this.pristineValue.get() : "(blank)", this.value.isPresent() ? this.value.get() : "(blank)");
    }
}

