/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.strategy.fastestresponse;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.PropertyUtils;
import software.amazon.jdbc.util.StringUtils;
import software.amazon.jdbc.util.events.Event;
import software.amazon.jdbc.util.events.EventSubscriber;
import software.amazon.jdbc.util.events.MonitorResetEvent;
import software.amazon.jdbc.util.monitoring.AbstractMonitor;
import software.amazon.jdbc.util.telemetry.TelemetryContext;
import software.amazon.jdbc.util.telemetry.TelemetryFactory;
import software.amazon.jdbc.util.telemetry.TelemetryGauge;
import software.amazon.jdbc.util.telemetry.TelemetryTraceLevel;

public class NodeResponseTimeMonitor
extends AbstractMonitor
implements EventSubscriber {
    private static final Logger LOGGER = Logger.getLogger(NodeResponseTimeMonitor.class.getName());
    private static final String MONITORING_PROPERTY_PREFIX = "frt-";
    private static final int TERMINATION_TIMEOUT_SEC = 5;
    private static final int NUM_OF_MEASURES = 5;
    private final int intervalMs;
    private final @NonNull HostSpec hostSpec;
    private final AtomicBoolean stopped = new AtomicBoolean(false);
    private final AtomicInteger responseTime = new AtomicInteger(Integer.MAX_VALUE);
    private final AtomicLong checkTimestamp = new AtomicLong(this.getCurrentTime());
    private final @NonNull Properties props;
    private final @NonNull PluginService pluginService;
    private final TelemetryFactory telemetryFactory;
    private final TelemetryGauge responseTimeMsGauge;
    private final AtomicReference<Connection> monitoringConn = new AtomicReference<Object>(null);

    public NodeResponseTimeMonitor(@NonNull PluginService pluginService, @NonNull HostSpec hostSpec, @NonNull Properties props, int intervalMs) {
        super(5L);
        this.pluginService = pluginService;
        this.hostSpec = hostSpec;
        this.props = props;
        this.intervalMs = intervalMs;
        this.telemetryFactory = this.pluginService.getTelemetryFactory();
        String nodeId = StringUtils.isNullOrEmpty(this.hostSpec.getHostId()) ? this.hostSpec.getHost() : this.hostSpec.getHostId();
        this.responseTimeMsGauge = this.telemetryFactory.createGauge(String.format("frt.response.time.%s", nodeId), () -> this.responseTime.get() == Integer.MAX_VALUE ? -1L : (long)this.responseTime.get());
    }

    public int getResponseTime() {
        return this.responseTime.get();
    }

    public @NonNull HostSpec getHostSpec() {
        return this.hostSpec;
    }

    protected long getCurrentTime() {
        return System.nanoTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void monitor() {
        TelemetryContext telemetryContext = this.telemetryFactory.openTelemetryContext("node response time thread", TelemetryTraceLevel.TOP_LEVEL);
        if (telemetryContext != null) {
            telemetryContext.setAttribute("url", this.hostSpec.getUrl());
        }
        try {
            while (!this.stopped.get()) {
                this.lastActivityTimestampNanos.set(System.nanoTime());
                this.openConnection();
                Connection copyConnection = this.monitoringConn.get();
                if (copyConnection != null) {
                    long responseTimeSum = 0L;
                    int count = 0;
                    for (int i = 0; i < 5 && !this.stopped.get(); ++i) {
                        long startTime = this.getCurrentTime();
                        if (!this.pluginService.getTargetDriverDialect().ping(copyConnection)) continue;
                        long responseTime = this.getCurrentTime() - startTime;
                        responseTimeSum += responseTime;
                        ++count;
                    }
                    if (count > 0) {
                        this.responseTime.set((int)TimeUnit.NANOSECONDS.toMillis(responseTimeSum / (long)count));
                    } else {
                        this.responseTime.set(Integer.MAX_VALUE);
                    }
                    this.checkTimestamp.set(this.getCurrentTime());
                    LOGGER.finest(() -> Messages.get("NodeResponseTimeMonitor.responseTime", new Object[]{this.hostSpec.getHost(), this.responseTime.get()}));
                }
                TimeUnit.MILLISECONDS.sleep(this.intervalMs);
            }
        }
        catch (InterruptedException intEx) {
            LOGGER.finest(() -> Messages.get("NodeResponseTimeMonitor.interruptedExceptionDuringMonitoring", new Object[]{this.hostSpec.getHost()}));
        }
        catch (Exception ex) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, Messages.get("NodeResponseTimeMonitor.exceptionDuringMonitoringStop", new Object[]{this.hostSpec.getHost()}), ex);
            }
        }
        finally {
            this.stopped.set(true);
            this.closeConnection();
            if (telemetryContext != null) {
                telemetryContext.closeContext();
            }
        }
    }

    private void openConnection() {
        try {
            Connection copyConnection = this.monitoringConn.get();
            if (copyConnection == null || copyConnection.isClosed()) {
                Properties monitoringConnProperties = PropertyUtils.copyProperties(this.props);
                this.props.stringPropertyNames().stream().filter(p -> p.startsWith(MONITORING_PROPERTY_PREFIX)).forEach(p -> {
                    monitoringConnProperties.put(p.substring(MONITORING_PROPERTY_PREFIX.length()), this.props.getProperty((String)p));
                    monitoringConnProperties.remove(p);
                });
                LOGGER.finest(() -> Messages.get("NodeResponseTimeMonitor.openingConnection", new Object[]{this.hostSpec.getUrl()}));
                this.monitoringConn.set(this.pluginService.forceConnect(this.hostSpec, monitoringConnProperties));
                LOGGER.finest(() -> Messages.get("NodeResponseTimeMonitor.openedConnection", new Object[]{this.monitoringConn.get()}));
            }
        }
        catch (SQLException ex) {
            this.closeConnection();
        }
    }

    @Override
    public void close() {
        this.closeConnection();
    }

    protected void closeConnection() {
        Connection conn = this.monitoringConn.getAndSet(null);
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    protected void reset() {
        LOGGER.finest("Reset: " + this.hostSpec.getHost());
        this.closeConnection();
        this.responseTime.set(Integer.MAX_VALUE);
        this.checkTimestamp.set(this.getCurrentTime());
    }

    @Override
    public void processEvent(Event event) {
        if (event instanceof MonitorResetEvent) {
            LOGGER.finest("MonitorResetEvent received");
            MonitorResetEvent resetEvent = (MonitorResetEvent)event;
            if (resetEvent.getEndpoints().contains(this.hostSpec.getHost())) {
                this.reset();
            }
        }
    }
}

