/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.strategy.fastestresponse;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.plugin.strategy.fastestresponse.HostResponseTimeService;
import software.amazon.jdbc.plugin.strategy.fastestresponse.NodeResponseTimeMonitor;
import software.amazon.jdbc.util.FullServicesContainer;
import software.amazon.jdbc.util.Messages;

public class HostResponseTimeServiceImpl
implements HostResponseTimeService {
    private static final Logger LOGGER = Logger.getLogger(HostResponseTimeServiceImpl.class.getName());
    protected int intervalMs;
    protected List<HostSpec> hosts = new ArrayList<HostSpec>();
    protected final @NonNull FullServicesContainer servicesContainer;
    protected final @NonNull PluginService pluginService;
    protected final @NonNull Properties props;

    public HostResponseTimeServiceImpl(@NonNull FullServicesContainer servicesContainer, @NonNull Properties props, int intervalMs) {
        this.servicesContainer = servicesContainer;
        this.pluginService = servicesContainer.getPluginService();
        this.props = props;
        this.intervalMs = intervalMs;
    }

    @Override
    public int getResponseTime(HostSpec hostSpec) {
        NodeResponseTimeMonitor monitor = this.servicesContainer.getMonitorService().get(NodeResponseTimeMonitor.class, hostSpec.getUrl());
        if (monitor == null) {
            return Integer.MAX_VALUE;
        }
        return monitor.getResponseTime();
    }

    @Override
    public void setHosts(@NonNull List<HostSpec> hosts) {
        Set oldHosts = this.hosts.stream().map(HostSpec::getUrl).collect(Collectors.toSet());
        this.hosts = hosts;
        this.hosts.stream().filter(hostSpec -> !oldHosts.contains(hostSpec.getUrl())).forEach(hostSpec -> {
            try {
                this.servicesContainer.getMonitorService().runIfAbsent(NodeResponseTimeMonitor.class, hostSpec.getUrl(), this.servicesContainer, this.props, servicesContainer -> new NodeResponseTimeMonitor(this.pluginService, (HostSpec)hostSpec, this.props, this.intervalMs));
            }
            catch (SQLException e) {
                LOGGER.warning(Messages.get("HostResponseTimeServiceImpl.errorStartingMonitor", new Object[]{hostSpec.getUrl(), e}));
            }
        });
    }
}

