/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.hostlistprovider.monitoring;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import software.amazon.jdbc.AwsWrapperProperty;
import software.amazon.jdbc.BlockingHostListProvider;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.PropertyDefinition;
import software.amazon.jdbc.cleanup.CanReleaseResources;
import software.amazon.jdbc.hostlistprovider.RdsHostListProvider;
import software.amazon.jdbc.hostlistprovider.Topology;
import software.amazon.jdbc.hostlistprovider.monitoring.ClusterTopologyMonitor;
import software.amazon.jdbc.hostlistprovider.monitoring.ClusterTopologyMonitorImpl;
import software.amazon.jdbc.util.FullServicesContainer;
import software.amazon.jdbc.util.monitoring.MonitorService;
import software.amazon.jdbc.util.storage.StorageService;

public class MonitoringRdsHostListProvider
extends RdsHostListProvider
implements BlockingHostListProvider,
CanReleaseResources {
    private static final Logger LOGGER = Logger.getLogger(MonitoringRdsHostListProvider.class.getName());
    public static final AwsWrapperProperty CLUSTER_TOPOLOGY_HIGH_REFRESH_RATE_MS = new AwsWrapperProperty("clusterTopologyHighRefreshRateMs", "100", "Cluster topology high refresh rate in millis.");
    protected final FullServicesContainer servicesContainer;
    protected final PluginService pluginService;
    protected final long highRefreshRateNano;
    protected final String writerTopologyQuery;

    public MonitoringRdsHostListProvider(Properties properties, String originalUrl, FullServicesContainer servicesContainer, String topologyQuery, String nodeIdQuery, String isReaderQuery, String writerTopologyQuery) {
        super(properties, originalUrl, servicesContainer, topologyQuery, nodeIdQuery, isReaderQuery);
        this.servicesContainer = servicesContainer;
        this.pluginService = servicesContainer.getPluginService();
        this.writerTopologyQuery = writerTopologyQuery;
        this.highRefreshRateNano = TimeUnit.MILLISECONDS.toNanos(CLUSTER_TOPOLOGY_HIGH_REFRESH_RATE_MS.getLong(this.properties));
    }

    public static void clearCache() {
        MonitoringRdsHostListProvider.clearAll();
    }

    @Override
    protected void init() throws SQLException {
        super.init();
    }

    protected ClusterTopologyMonitor initMonitor() throws SQLException {
        return this.servicesContainer.getMonitorService().runIfAbsent(ClusterTopologyMonitorImpl.class, this.clusterId, this.servicesContainer, this.properties, servicesContainer -> new ClusterTopologyMonitorImpl(this.servicesContainer, this.clusterId, this.initialHostSpec, this.properties, this.clusterInstanceTemplate, this.refreshRateNano, this.highRefreshRateNano, this.topologyQuery, this.writerTopologyQuery, this.nodeIdQuery));
    }

    @Override
    protected List<HostSpec> queryForTopology(Connection conn) throws SQLException {
        ClusterTopologyMonitor monitor = this.initMonitor();
        try {
            return monitor.forceRefresh(conn, 5000L);
        }
        catch (TimeoutException ex) {
            return null;
        }
    }

    @Override
    protected void clusterIdChanged(String oldClusterId) throws SQLException {
        StorageService storageService;
        Topology existingTopology;
        List<HostSpec> existingHosts;
        MonitorService monitorService = this.servicesContainer.getMonitorService();
        ClusterTopologyMonitorImpl existingMonitor = monitorService.get(ClusterTopologyMonitorImpl.class, oldClusterId);
        if (existingMonitor != null) {
            this.servicesContainer.getMonitorService().runIfAbsent(ClusterTopologyMonitorImpl.class, this.clusterId, this.servicesContainer, this.properties, servicesContainer -> existingMonitor);
            assert (monitorService.get(ClusterTopologyMonitorImpl.class, this.clusterId) == existingMonitor);
            existingMonitor.setClusterId(this.clusterId);
            monitorService.remove(ClusterTopologyMonitorImpl.class, oldClusterId);
        }
        List<HostSpec> list = existingHosts = (existingTopology = (storageService = this.servicesContainer.getStorageService()).get(Topology.class, oldClusterId)) == null ? null : existingTopology.getHosts();
        if (existingHosts != null) {
            storageService.set(this.clusterId, new Topology(existingHosts));
        }
    }

    @Override
    public List<HostSpec> forceRefresh(boolean shouldVerifyWriter, long timeoutMs) throws SQLException, TimeoutException {
        ClusterTopologyMonitor monitor = this.servicesContainer.getMonitorService().get(ClusterTopologyMonitorImpl.class, this.clusterId);
        if (monitor == null) {
            monitor = this.initMonitor();
        }
        assert (monitor != null);
        return monitor.forceRefresh(shouldVerifyWriter, timeoutMs);
    }

    @Override
    public void releaseResources() {
    }

    static {
        PropertyDefinition.registerPluginProperties(MonitoringRdsHostListProvider.class);
    }
}

