/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.exceptions;

import java.sql.SQLException;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.amazon.jdbc.exceptions.ExceptionHandler;
import software.amazon.jdbc.exceptions.SQLLoginException;
import software.amazon.jdbc.targetdriverdialect.TargetDriverDialect;
import software.amazon.jdbc.util.StringUtils;

public abstract class AbstractPgExceptionHandler
implements ExceptionHandler {
    public abstract List<String> getNetworkErrors();

    public abstract List<String> getAccessErrors();

    @Override
    @Deprecated
    public boolean isNetworkException(Throwable throwable) {
        return this.isNetworkException(throwable, null);
    }

    @Override
    public boolean isNetworkException(Throwable throwable, @Nullable TargetDriverDialect targetDriverDialect) {
        for (Throwable exception = throwable; exception != null; exception = exception.getCause()) {
            String sqlState;
            if (exception instanceof SQLException) {
                return this.isNetworkException(((SQLException)exception).getSQLState());
            }
            if (targetDriverDialect == null || StringUtils.isNullOrEmpty(sqlState = targetDriverDialect.getSQLState(exception))) continue;
            return this.isNetworkException(sqlState);
        }
        return false;
    }

    @Override
    public boolean isNetworkException(String sqlState) {
        if (sqlState == null) {
            return false;
        }
        for (String pgSqlState : this.getNetworkErrors()) {
            if (!sqlState.startsWith(pgSqlState)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public boolean isLoginException(Throwable throwable) {
        return this.isLoginException(throwable, null);
    }

    @Override
    public boolean isLoginException(Throwable throwable, @Nullable TargetDriverDialect targetDriverDialect) {
        for (Throwable exception = throwable; exception != null; exception = exception.getCause()) {
            if (exception instanceof SQLLoginException) {
                return true;
            }
            String sqlState = null;
            if (exception instanceof SQLException) {
                sqlState = ((SQLException)exception).getSQLState();
            } else if (targetDriverDialect != null) {
                sqlState = targetDriverDialect.getSQLState(exception);
            }
            if (!this.isLoginException(sqlState)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isLoginException(String sqlState) {
        if (sqlState == null) {
            return false;
        }
        return this.getAccessErrors().contains(sqlState);
    }
}

