/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.dialect;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Logger;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.dialect.AuroraLimitlessDialect;
import software.amazon.jdbc.dialect.BlueGreenDialect;
import software.amazon.jdbc.dialect.HostListProviderSupplier;
import software.amazon.jdbc.dialect.PgDialect;
import software.amazon.jdbc.hostlistprovider.AuroraHostListProvider;
import software.amazon.jdbc.hostlistprovider.monitoring.MonitoringRdsHostListProvider;
import software.amazon.jdbc.plugin.failover2.FailoverConnectionPlugin;

public class AuroraPgDialect
extends PgDialect
implements AuroraLimitlessDialect,
BlueGreenDialect {
    private static final Logger LOGGER = Logger.getLogger(AuroraPgDialect.class.getName());
    private static final String extensionsSql = "SELECT (setting LIKE '%aurora_stat_utils%') AS aurora_stat_utils FROM pg_catalog.pg_settings WHERE name OPERATOR(pg_catalog.=) 'rds.extensions'";
    private static final String topologySql = "SELECT 1 FROM pg_catalog.aurora_replica_status() LIMIT 1";
    private static final String TOPOLOGY_QUERY = "SELECT SERVER_ID, CASE WHEN SESSION_ID OPERATOR(pg_catalog.=) 'MASTER_SESSION_ID' THEN TRUE ELSE FALSE END, CPU, COALESCE(REPLICA_LAG_IN_MSEC, 0), LAST_UPDATE_TIMESTAMP FROM pg_catalog.aurora_replica_status() WHERE EXTRACT(EPOCH FROM(pg_catalog.NOW() OPERATOR(pg_catalog.-) LAST_UPDATE_TIMESTAMP)) OPERATOR(pg_catalog.<=) 300 OR SESSION_ID OPERATOR(pg_catalog.=) 'MASTER_SESSION_ID' OR LAST_UPDATE_TIMESTAMP IS NULL";
    private static final String IS_WRITER_QUERY = "SELECT SERVER_ID FROM pg_catalog.aurora_replica_status() WHERE SESSION_ID OPERATOR(pg_catalog.=) 'MASTER_SESSION_ID' AND SERVER_ID OPERATOR(pg_catalog.=) pg_catalog.aurora_db_instance_identifier()";
    private static final String NODE_ID_QUERY = "SELECT pg_catalog.aurora_db_instance_identifier()";
    private static final String IS_READER_QUERY = "SELECT pg_catalog.pg_is_in_recovery()";
    protected static final String LIMITLESS_ROUTER_ENDPOINT_QUERY = "select router_endpoint, load from pg_catalog.aurora_limitless_router_endpoints()";
    private static final String BG_STATUS_QUERY = "SELECT * FROM pg_catalog.get_blue_green_fast_switchover_metadata('aws_jdbc_driver-2.6.7')";
    private static final String TOPOLOGY_TABLE_EXIST_QUERY = "SELECT 'pg_catalog.get_blue_green_fast_switchover_metadata'::regproc";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDialect(Connection connection) {
        if (!super.isDialect(connection)) {
            return false;
        }
        Statement stmt = null;
        ResultSet rs = null;
        boolean hasExtensions = false;
        boolean hasTopology = false;
        try {
            stmt = connection.createStatement();
            rs = stmt.executeQuery(extensionsSql);
            if (rs.next()) {
                boolean auroraUtils = rs.getBoolean("aurora_stat_utils");
                LOGGER.finest(() -> String.format("auroraUtils: %b", auroraUtils));
                if (auroraUtils) {
                    hasExtensions = true;
                }
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        if (!hasExtensions) {
            return false;
        }
        try {
            stmt = connection.createStatement();
            rs = stmt.executeQuery(topologySql);
            if (rs.next()) {
                LOGGER.finest(() -> "hasTopology: true");
                hasTopology = true;
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return hasExtensions && hasTopology;
    }

    @Override
    public HostListProviderSupplier getHostListProvider() {
        return (properties, initialUrl, servicesContainer) -> {
            PluginService pluginService = servicesContainer.getPluginService();
            if (pluginService.isPluginInUse(FailoverConnectionPlugin.class)) {
                return new MonitoringRdsHostListProvider(properties, initialUrl, servicesContainer, TOPOLOGY_QUERY, NODE_ID_QUERY, IS_READER_QUERY, IS_WRITER_QUERY);
            }
            return new AuroraHostListProvider(properties, initialUrl, servicesContainer, TOPOLOGY_QUERY, NODE_ID_QUERY, IS_READER_QUERY);
        };
    }

    @Override
    public String getLimitlessRouterEndpointQuery() {
        return LIMITLESS_ROUTER_ENDPOINT_QUERY;
    }

    @Override
    public String getBlueGreenStatusQuery() {
        return BG_STATUS_QUERY;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean isBlueGreenStatusAvailable(Connection connection) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

