/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.federatedauth;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.plugin.federatedauth.FederatedAuthPlugin;
import software.amazon.jdbc.plugin.federatedauth.SamlCredentialsProviderFactory;
import software.amazon.jdbc.plugin.federatedauth.SamlUtils;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.telemetry.TelemetryContext;
import software.amazon.jdbc.util.telemetry.TelemetryFactory;

public class AdfsCredentialsProviderFactory
extends SamlCredentialsProviderFactory {
    public static final String IDP_NAME = "adfs";
    private static final String TELEMETRY_FETCH_SAML = "Fetch ADFS SAML Assertion";
    private static final Pattern INPUT_TAG_PATTERN = Pattern.compile("<input(.+?)/>", 32);
    private static final Pattern FORM_ACTION_PATTERN = Pattern.compile("<form.*?action=\"([^\"]+)\"");
    private static final Logger LOGGER = Logger.getLogger(AdfsCredentialsProviderFactory.class.getName());
    private final PluginService pluginService;
    private final TelemetryFactory telemetryFactory;
    private final Supplier<CloseableHttpClient> httpClientSupplier;
    private TelemetryContext telemetryContext;

    public AdfsCredentialsProviderFactory(PluginService pluginService, Supplier<CloseableHttpClient> httpClientSupplier) {
        this.pluginService = pluginService;
        this.telemetryFactory = this.pluginService.getTelemetryFactory();
        this.httpClientSupplier = httpClientSupplier;
    }

    /*
     * Exception decompiling
     */
    @Override
    String getSamlAssertion(@NonNull Properties props) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getSignInPageBody(CloseableHttpClient httpClient, String uri) throws IOException {
        LOGGER.finest(Messages.get("AdfsCredentialsProviderFactory.signOnPageUrl", new Object[]{uri}));
        SamlUtils.validateUrl(uri);
        try (CloseableHttpResponse resp = httpClient.execute((HttpUriRequest)new HttpGet(uri));){
            StatusLine statusLine = resp.getStatusLine();
            if (statusLine.getStatusCode() / 100 != 2) {
                throw new IOException(Messages.get("AdfsCredentialsProviderFactory.signOnPageRequestFailed", new Object[]{statusLine.getStatusCode(), statusLine.getReasonPhrase(), EntityUtils.toString((HttpEntity)resp.getEntity())}));
            }
            String string = EntityUtils.toString((HttpEntity)resp.getEntity());
            return string;
        }
    }

    private String getFormActionBody(CloseableHttpClient httpClient, String uri, List<NameValuePair> params) throws IOException {
        LOGGER.finest(Messages.get("AdfsCredentialsProviderFactory.signOnPagePostActionUrl", new Object[]{uri}));
        SamlUtils.validateUrl(uri);
        HttpUriRequest request = RequestBuilder.post().setUri(uri).setEntity((HttpEntity)new UrlEncodedFormEntity(params)).build();
        try (CloseableHttpResponse resp = httpClient.execute(request);){
            StatusLine statusLine = resp.getStatusLine();
            if (statusLine.getStatusCode() / 100 != 2) {
                throw new IOException(Messages.get("AdfsCredentialsProviderFactory.signOnPagePostActionRequestFailed", new Object[]{statusLine.getStatusCode(), statusLine.getReasonPhrase(), EntityUtils.toString((HttpEntity)resp.getEntity())}));
            }
            String string = EntityUtils.toString((HttpEntity)resp.getEntity());
            return string;
        }
    }

    private String getSignInPageUrl(Properties props) {
        return "https://" + FederatedAuthPlugin.IDP_ENDPOINT.getString(props) + ':' + FederatedAuthPlugin.IDP_PORT.getString(props) + "/adfs/ls/IdpInitiatedSignOn.aspx?loginToRp=" + FederatedAuthPlugin.RELAYING_PARTY_ID.getString(props);
    }

    private String getFormActionUrl(Properties props, String action) {
        return "https://" + FederatedAuthPlugin.IDP_ENDPOINT.getString(props) + ':' + FederatedAuthPlugin.IDP_PORT.getString(props) + action;
    }

    private List<String> getInputTagsFromHTML(String body) {
        HashSet<String> distinctInputTags = new HashSet<String>();
        ArrayList<String> inputTags = new ArrayList<String>();
        Matcher inputTagMatcher = INPUT_TAG_PATTERN.matcher(body);
        while (inputTagMatcher.find()) {
            String tag = inputTagMatcher.group(0);
            String tagNameLower = this.getValueByKey(tag, "name").toLowerCase();
            if (tagNameLower.isEmpty() || !distinctInputTags.add(tagNameLower)) continue;
            inputTags.add(tag);
        }
        return inputTags;
    }

    private String getValueByKey(String input, String key) {
        Pattern keyValuePattern = Pattern.compile("(" + Pattern.quote(key) + ")\\s*=\\s*\"(.*?)\"");
        Matcher keyValueMatcher = keyValuePattern.matcher(input);
        if (keyValueMatcher.find()) {
            return this.escapeHtmlEntity(keyValueMatcher.group(2));
        }
        return "";
    }

    private String escapeHtmlEntity(String html) {
        StringBuilder sb = new StringBuilder(html.length());
        int i = 0;
        int length = html.length();
        while (i < length) {
            char c = html.charAt(i);
            if (c != '&') {
                sb.append(c);
                ++i;
                continue;
            }
            if (html.startsWith("&amp;", i)) {
                sb.append('&');
                i += 5;
                continue;
            }
            if (html.startsWith("&apos;", i)) {
                sb.append('\'');
                i += 6;
                continue;
            }
            if (html.startsWith("&quot;", i)) {
                sb.append('\"');
                i += 6;
                continue;
            }
            if (html.startsWith("&lt;", i)) {
                sb.append('<');
                i += 4;
                continue;
            }
            if (html.startsWith("&gt;", i)) {
                sb.append('>');
                i += 4;
                continue;
            }
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }

    private List<NameValuePair> getParametersFromHtmlBody(String body, @NonNull Properties props) {
        ArrayList<NameValuePair> parameters = new ArrayList<NameValuePair>();
        for (String inputTag : this.getInputTagsFromHTML(body)) {
            String name = this.getValueByKey(inputTag, "name");
            String value = this.getValueByKey(inputTag, "value");
            String nameLower = name.toLowerCase();
            if (nameLower.contains("username")) {
                parameters.add((NameValuePair)new BasicNameValuePair(name, FederatedAuthPlugin.IDP_USERNAME.getString(props)));
                continue;
            }
            if (nameLower.contains("authmethod")) {
                if (value.isEmpty()) continue;
                parameters.add((NameValuePair)new BasicNameValuePair(name, value));
                continue;
            }
            if (nameLower.contains("password")) {
                parameters.add((NameValuePair)new BasicNameValuePair(name, FederatedAuthPlugin.IDP_PASSWORD.getString(props)));
                continue;
            }
            if (name.isEmpty()) continue;
            parameters.add((NameValuePair)new BasicNameValuePair(name, value));
        }
        return parameters;
    }

    private String getFormActionFromHtmlBody(String body) {
        Matcher m = FORM_ACTION_PATTERN.matcher(body);
        if (m.find()) {
            return this.escapeHtmlEntity(m.group(1));
        }
        return null;
    }
}

