/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.customendpoint;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import software.amazon.awssdk.services.rds.model.DBClusterEndpoint;
import software.amazon.jdbc.plugin.customendpoint.CustomEndpointRoleType;
import software.amazon.jdbc.plugin.customendpoint.MemberListType;

public class CustomEndpointInfo {
    private final String endpointIdentifier;
    private final String clusterIdentifier;
    private final String url;
    private final CustomEndpointRoleType roleType;
    private final MemberListType memberListType;
    private final Set<String> members;

    public CustomEndpointInfo(String endpointIdentifier, String clusterIdentifier, String url, CustomEndpointRoleType roleType, Set<String> members, MemberListType memberListType) {
        this.endpointIdentifier = endpointIdentifier;
        this.clusterIdentifier = clusterIdentifier;
        this.url = url;
        this.roleType = roleType;
        this.members = members;
        this.memberListType = memberListType;
    }

    public static CustomEndpointInfo fromDBClusterEndpoint(DBClusterEndpoint responseEndpointInfo) {
        MemberListType memberListType;
        List members;
        if (responseEndpointInfo.hasStaticMembers()) {
            members = responseEndpointInfo.staticMembers();
            memberListType = MemberListType.STATIC_LIST;
        } else {
            members = responseEndpointInfo.excludedMembers();
            memberListType = MemberListType.EXCLUSION_LIST;
        }
        return new CustomEndpointInfo(responseEndpointInfo.dbClusterEndpointIdentifier(), responseEndpointInfo.dbClusterIdentifier(), responseEndpointInfo.endpoint(), CustomEndpointRoleType.valueOf(responseEndpointInfo.customEndpointType()), new HashSet<String>(members), memberListType);
    }

    public String getEndpointIdentifier() {
        return this.endpointIdentifier;
    }

    public String getClusterIdentifier() {
        return this.clusterIdentifier;
    }

    public String getUrl() {
        return this.url;
    }

    public CustomEndpointRoleType getCustomEndpointType() {
        return this.roleType;
    }

    public MemberListType getMemberListType() {
        return this.memberListType;
    }

    public Set<String> getStaticMembers() {
        return MemberListType.STATIC_LIST.equals((Object)this.memberListType) ? this.members : null;
    }

    public Set<String> getExcludedMembers() {
        return MemberListType.EXCLUSION_LIST.equals((Object)this.memberListType) ? this.members : null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CustomEndpointInfo info = (CustomEndpointInfo)obj;
        return Objects.equals(this.endpointIdentifier, info.endpointIdentifier) && Objects.equals(this.clusterIdentifier, info.clusterIdentifier) && Objects.equals(this.url, info.url) && Objects.equals((Object)this.roleType, (Object)info.roleType) && Objects.equals(this.members, info.members) && Objects.equals((Object)this.memberListType, (Object)info.memberListType);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.endpointIdentifier == null ? 0 : this.endpointIdentifier.hashCode());
        result = 31 * result + (this.clusterIdentifier == null ? 0 : this.clusterIdentifier.hashCode());
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        result = 31 * result + (this.roleType == null ? 0 : this.roleType.hashCode());
        result = 31 * result + (this.memberListType == null ? 0 : this.memberListType.hashCode());
        return result;
    }

    public String toString() {
        return String.format("CustomEndpointInfo[url=%s, clusterIdentifier=%s, customEndpointType=%s, memberListType=%s, members=%s]", new Object[]{this.url, this.clusterIdentifier, this.roleType, this.memberListType, this.members});
    }
}

