/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.amazon.jdbc.ConnectionPlugin;
import software.amazon.jdbc.ConnectionPluginFactory;
import software.amazon.jdbc.ConnectionProvider;
import software.amazon.jdbc.PluginManagerService;
import software.amazon.jdbc.PropertyDefinition;
import software.amazon.jdbc.ServicesContainerPluginFactory;
import software.amazon.jdbc.plugin.AuroraConnectionTrackerPluginFactory;
import software.amazon.jdbc.plugin.AuroraInitialConnectionStrategyPluginFactory;
import software.amazon.jdbc.plugin.AwsSecretsManagerConnectionPluginFactory;
import software.amazon.jdbc.plugin.ConnectTimeConnectionPluginFactory;
import software.amazon.jdbc.plugin.DataCacheConnectionPluginFactory;
import software.amazon.jdbc.plugin.DefaultConnectionPlugin;
import software.amazon.jdbc.plugin.DriverMetaDataConnectionPluginFactory;
import software.amazon.jdbc.plugin.ExecutionTimeConnectionPluginFactory;
import software.amazon.jdbc.plugin.LogQueryConnectionPluginFactory;
import software.amazon.jdbc.plugin.bluegreen.BlueGreenConnectionPluginFactory;
import software.amazon.jdbc.plugin.customendpoint.CustomEndpointPluginFactory;
import software.amazon.jdbc.plugin.dev.DeveloperConnectionPluginFactory;
import software.amazon.jdbc.plugin.efm2.HostMonitoringConnectionPluginFactory;
import software.amazon.jdbc.plugin.failover2.FailoverConnectionPluginFactory;
import software.amazon.jdbc.plugin.federatedauth.FederatedAuthPluginFactory;
import software.amazon.jdbc.plugin.federatedauth.OktaAuthPluginFactory;
import software.amazon.jdbc.plugin.iam.IamAuthConnectionPluginFactory;
import software.amazon.jdbc.plugin.limitless.LimitlessConnectionPluginFactory;
import software.amazon.jdbc.plugin.readwritesplitting.ReadWriteSplittingPluginFactory;
import software.amazon.jdbc.plugin.staledns.AuroraStaleDnsPluginFactory;
import software.amazon.jdbc.plugin.strategy.fastestresponse.FastestResponseStrategyPluginFactory;
import software.amazon.jdbc.profile.ConfigurationProfile;
import software.amazon.jdbc.util.FullServicesContainer;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.SqlState;
import software.amazon.jdbc.util.StringUtils;
import software.amazon.jdbc.util.WrapperUtils;

public class ConnectionPluginChainBuilder {
    private static final Logger LOGGER = Logger.getLogger(ConnectionPluginChainBuilder.class.getName());
    private static final int WEIGHT_RELATIVE_TO_PRIOR_PLUGIN = -1;
    protected static final Map<String, ConnectionPluginFactory> pluginFactoriesByCode = new HashMap<String, ConnectionPluginFactory>(){
        {
            this.put("executionTime", new ExecutionTimeConnectionPluginFactory());
            this.put("logQuery", new LogQueryConnectionPluginFactory());
            this.put("dataCache", new DataCacheConnectionPluginFactory());
            this.put("customEndpoint", new CustomEndpointPluginFactory());
            this.put("efm", new software.amazon.jdbc.plugin.efm.HostMonitoringConnectionPluginFactory());
            this.put("efm2", new HostMonitoringConnectionPluginFactory());
            this.put("failover", new software.amazon.jdbc.plugin.failover.FailoverConnectionPluginFactory());
            this.put("failover2", new FailoverConnectionPluginFactory());
            this.put("iam", new IamAuthConnectionPluginFactory());
            this.put("awsSecretsManager", new AwsSecretsManagerConnectionPluginFactory());
            this.put("federatedAuth", new FederatedAuthPluginFactory());
            this.put("okta", new OktaAuthPluginFactory());
            this.put("auroraStaleDns", new AuroraStaleDnsPluginFactory());
            this.put("readWriteSplitting", new ReadWriteSplittingPluginFactory());
            this.put("auroraConnectionTracker", new AuroraConnectionTrackerPluginFactory());
            this.put("driverMetaData", new DriverMetaDataConnectionPluginFactory());
            this.put("connectTime", new ConnectTimeConnectionPluginFactory());
            this.put("dev", new DeveloperConnectionPluginFactory());
            this.put("fastestResponseStrategy", new FastestResponseStrategyPluginFactory());
            this.put("initialConnection", new AuroraInitialConnectionStrategyPluginFactory());
            this.put("limitless", new LimitlessConnectionPluginFactory());
            this.put("bg", new BlueGreenConnectionPluginFactory());
        }
    };
    protected static final Map<Class<? extends ConnectionPluginFactory>, Integer> pluginWeightByPluginFactory = new HashMap<Class<? extends ConnectionPluginFactory>, Integer>(){
        {
            this.put(DriverMetaDataConnectionPluginFactory.class, 100);
            this.put(DataCacheConnectionPluginFactory.class, 200);
            this.put(CustomEndpointPluginFactory.class, 380);
            this.put(AuroraInitialConnectionStrategyPluginFactory.class, 390);
            this.put(AuroraConnectionTrackerPluginFactory.class, 400);
            this.put(AuroraStaleDnsPluginFactory.class, 500);
            this.put(BlueGreenConnectionPluginFactory.class, 550);
            this.put(ReadWriteSplittingPluginFactory.class, 600);
            this.put(software.amazon.jdbc.plugin.failover.FailoverConnectionPluginFactory.class, 700);
            this.put(FailoverConnectionPluginFactory.class, 710);
            this.put(software.amazon.jdbc.plugin.efm.HostMonitoringConnectionPluginFactory.class, 800);
            this.put(HostMonitoringConnectionPluginFactory.class, 810);
            this.put(FastestResponseStrategyPluginFactory.class, 900);
            this.put(LimitlessConnectionPluginFactory.class, 950);
            this.put(IamAuthConnectionPluginFactory.class, 1000);
            this.put(AwsSecretsManagerConnectionPluginFactory.class, 1100);
            this.put(FederatedAuthPluginFactory.class, 1200);
            this.put(LogQueryConnectionPluginFactory.class, 1300);
            this.put(ConnectTimeConnectionPluginFactory.class, -1);
            this.put(ExecutionTimeConnectionPluginFactory.class, -1);
            this.put(DeveloperConnectionPluginFactory.class, -1);
        }
    };
    protected static final ConcurrentMap<Class<? extends ConnectionPluginFactory>, ConnectionPluginFactory> pluginFactoriesByClass = new ConcurrentHashMap<Class<? extends ConnectionPluginFactory>, ConnectionPluginFactory>();
    protected static final String DEFAULT_PLUGINS = "auroraConnectionTracker,failover2,efm2";

    public List<ConnectionPlugin> getPlugins(FullServicesContainer servicesContainer, ConnectionProvider defaultConnProvider, ConnectionProvider effectiveConnProvider, PluginManagerService pluginManagerService, Properties props, @Nullable ConfigurationProfile configurationProfile) throws SQLException {
        ArrayList<ConnectionPlugin> plugins;
        List<ConnectionPluginFactory> pluginFactories;
        if (configurationProfile != null && configurationProfile.getPluginFactories() != null) {
            List<Class<? extends ConnectionPluginFactory>> pluginFactoryClasses = configurationProfile.getPluginFactories();
            pluginFactories = new ArrayList(pluginFactoryClasses.size());
            for (Class clazz : pluginFactoryClasses) {
                AtomicReference<Object> lastException = new AtomicReference<Object>(null);
                ConnectionPluginFactory factory = pluginFactoriesByClass.computeIfAbsent(clazz, key -> {
                    try {
                        return WrapperUtils.createInstance(factoryClazz, ConnectionPluginFactory.class, null, new Object[]{null});
                    }
                    catch (InstantiationException ex) {
                        lastException.set(ex);
                        return null;
                    }
                });
                if (lastException.get() != null) {
                    throw new SQLException(Messages.get("ConnectionPluginManager.unableToLoadPlugin", new Object[]{clazz.getName()}), SqlState.UNKNOWN_STATE.getState(), lastException.get());
                }
                if (factory == null) continue;
                pluginFactories.add(factory);
            }
        } else {
            List<String> pluginCodeList = ConnectionPluginChainBuilder.getPluginCodes(props);
            pluginFactories = new ArrayList<ConnectionPluginFactory>(pluginCodeList.size());
            for (String string : pluginCodeList) {
                if (!pluginFactoriesByCode.containsKey(string)) {
                    throw new SQLException(Messages.get("ConnectionPluginManager.unknownPluginCode", new Object[]{string}));
                }
                pluginFactories.add(pluginFactoriesByCode.get(string));
            }
        }
        if (!pluginFactories.isEmpty()) {
            if (PropertyDefinition.AUTO_SORT_PLUGIN_ORDER.getBoolean(props)) {
                pluginFactories = this.sortPluginFactories(pluginFactories);
                List<ConnectionPluginFactory> tempPluginFactories = pluginFactories;
                LOGGER.finest(() -> "Plugins order has been rearranged. The following order is in effect: " + tempPluginFactories.stream().map(x -> x.getClass().getSimpleName()).collect(Collectors.joining(", ")));
            }
            plugins = new ArrayList(pluginFactories.size() + 1);
            for (ConnectionPluginFactory factory : pluginFactories) {
                if (factory instanceof ServicesContainerPluginFactory) {
                    ServicesContainerPluginFactory servicesContainerPluginFactory = (ServicesContainerPluginFactory)factory;
                    plugins.add(servicesContainerPluginFactory.getInstance(servicesContainer, props));
                    continue;
                }
                plugins.add(factory.getInstance(servicesContainer.getPluginService(), props));
            }
        } else {
            plugins = new ArrayList<ConnectionPlugin>(1);
        }
        DefaultConnectionPlugin defaultPlugin = new DefaultConnectionPlugin(servicesContainer.getPluginService(), defaultConnProvider, effectiveConnProvider, pluginManagerService);
        plugins.add(defaultPlugin);
        return plugins;
    }

    public static List<String> getPluginCodes(Properties props) {
        String pluginCodes = PropertyDefinition.PLUGINS.getString(props);
        if (pluginCodes == null) {
            pluginCodes = DEFAULT_PLUGINS;
        }
        return StringUtils.split(pluginCodes, ",", true);
    }

    protected List<ConnectionPluginFactory> sortPluginFactories(List<ConnectionPluginFactory> unsortedPluginFactories) {
        ArrayList<PluginFactoryInfo> weights = new ArrayList<PluginFactoryInfo>();
        int lastWeight = 0;
        for (ConnectionPluginFactory pluginFactory : unsortedPluginFactories) {
            Integer pluginFactoryWeight = pluginWeightByPluginFactory.get(pluginFactory.getClass());
            if (pluginFactoryWeight == null || pluginFactoryWeight == -1) {
                weights.add(new PluginFactoryInfo(pluginFactory, ++lastWeight));
                continue;
            }
            weights.add(new PluginFactoryInfo(pluginFactory, pluginFactoryWeight));
            lastWeight = pluginFactoryWeight;
        }
        return weights.stream().sorted(Comparator.comparingInt(o -> o.weight)).map(info -> info.factory).collect(Collectors.toList());
    }

    private static class PluginFactoryInfo {
        public ConnectionPluginFactory factory;
        public int weight;

        public PluginFactoryInfo(ConnectionPluginFactory factory, int weight) {
            this.factory = factory;
            this.weight = weight;
        }
    }
}

