/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import software.amazon.jdbc.ConnectionPlugin;
import software.amazon.jdbc.ConnectionProvider;
import software.amazon.jdbc.HostAvailability;
import software.amazon.jdbc.HostListProviderService;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.JdbcCallable;
import software.amazon.jdbc.NodeChangeOptions;
import software.amazon.jdbc.OldConnectionSuggestedAction;
import software.amazon.jdbc.PluginManagerService;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.SqlMethodAnalyzer;
import software.amazon.jdbc.util.WrapperUtils;

public final class DefaultConnectionPlugin
implements ConnectionPlugin {
    private static final Logger LOGGER = Logger.getLogger(DefaultConnectionPlugin.class.getName());
    private static final Set<String> subscribedMethods = Collections.unmodifiableSet(new HashSet<String>(Collections.singletonList("*")));
    private static final SqlMethodAnalyzer sqlMethodAnalyzer = new SqlMethodAnalyzer();
    private final ConnectionProvider connectionProvider;
    private final PluginService pluginService;
    private final PluginManagerService pluginManagerService;

    public DefaultConnectionPlugin(PluginService pluginService, ConnectionProvider connectionProvider, PluginManagerService pluginManagerService) {
        if (pluginService == null) {
            throw new IllegalArgumentException("pluginService");
        }
        if (pluginManagerService == null) {
            throw new IllegalArgumentException("pluginManagerService");
        }
        if (connectionProvider == null) {
            throw new IllegalArgumentException("connectionProvider");
        }
        this.pluginService = pluginService;
        this.pluginManagerService = pluginManagerService;
        this.connectionProvider = connectionProvider;
    }

    @Override
    public Set<String> getSubscribedMethods() {
        return subscribedMethods;
    }

    @Override
    public <T, E extends Exception> T execute(Class<T> resultClass, Class<E> exceptionClass, Object methodInvokeOn, String methodName, JdbcCallable<T, E> jdbcMethodFunc, Object[] jdbcMethodArgs) throws E {
        Boolean autocommit;
        LOGGER.finest(() -> Messages.get("DefaultConnectionPlugin.executingMethod", new Object[]{methodName}));
        T result = jdbcMethodFunc.call();
        Connection currentConn = this.pluginService.getCurrentConnection();
        Connection boundConnection = WrapperUtils.getConnectionFromSqlObject(methodInvokeOn);
        if (boundConnection != null && boundConnection != currentConn) {
            return result;
        }
        if (sqlMethodAnalyzer.doesOpenTransaction(currentConn, methodName, jdbcMethodArgs)) {
            this.pluginManagerService.setInTransaction(true);
        } else if (sqlMethodAnalyzer.doesCloseTransaction(currentConn, methodName, jdbcMethodArgs) || sqlMethodAnalyzer.doesSwitchAutoCommitFalseTrue(currentConn, methodName, jdbcMethodArgs)) {
            this.pluginManagerService.setInTransaction(false);
        }
        if (sqlMethodAnalyzer.isStatementSettingAutoCommit(methodName, jdbcMethodArgs) && (autocommit = sqlMethodAnalyzer.getAutoCommitValueFromSqlStatement(jdbcMethodArgs)) != null) {
            try {
                currentConn.setAutoCommit(autocommit);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public Connection connect(String driverProtocol, HostSpec hostSpec, Properties props, boolean isInitialConnection, JdbcCallable<Connection, SQLException> connectFunc) throws SQLException {
        Connection conn = this.connectionProvider.connect(driverProtocol, hostSpec, props);
        this.pluginService.setAvailability(hostSpec.asAliases(), HostAvailability.AVAILABLE);
        return conn;
    }

    @Override
    public void initHostProvider(String driverProtocol, String initialUrl, Properties props, HostListProviderService hostListProviderService, JdbcCallable<Void, SQLException> initHostProviderFunc) throws SQLException {
    }

    @Override
    public OldConnectionSuggestedAction notifyConnectionChanged(EnumSet<NodeChangeOptions> changes) {
        return OldConnectionSuggestedAction.NO_OPINION;
    }

    @Override
    public void notifyNodeListChanged(Map<String, EnumSet<NodeChangeOptions>> changes) {
    }

    List<String> parseMultiStatementQueries(String query) {
        if (query == null || query.isEmpty()) {
            return new ArrayList<String>();
        }
        if ((query = query.replaceAll("\\s+", " ")).trim().isEmpty()) {
            return new ArrayList<String>();
        }
        return Arrays.stream(query.split(";")).collect(Collectors.toList());
    }
}

