/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.schemaregistry.common;

import com.google.common.collect.ImmutableSet;
import java.time.Duration;
import java.util.Set;
import software.amazon.awssdk.core.retry.RetryPolicy;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.EqualJitterBackoffStrategy;
import software.amazon.awssdk.core.retry.conditions.OrRetryCondition;
import software.amazon.awssdk.core.retry.conditions.RetryCondition;
import software.amazon.awssdk.core.retry.conditions.RetryOnExceptionsCondition;
import software.amazon.awssdk.services.glue.model.ConcurrentModificationException;

public class AWSSchemaRegistryGlueClientRetryPolicyHelper {
    private static final Duration BASE_DELAY = Duration.ofMillis(200L);
    private static final Duration MAX_BACKOFF = Duration.ofMillis(20000L);
    private static final int MAX_RETRIES = 3;

    public static RetryPolicy getRetryPolicy() {
        return RetryPolicy.defaultRetryPolicy().toBuilder().backoffStrategy((BackoffStrategy)EqualJitterBackoffStrategy.builder().baseDelay(BASE_DELAY).maxBackoffTime(MAX_BACKOFF).build()).numRetries(Integer.valueOf(3)).retryCondition(AWSSchemaRegistryGlueClientRetryPolicyHelper.getRetryCondition()).build();
    }

    private static RetryCondition getRetryCondition() {
        return OrRetryCondition.create((RetryCondition[])new RetryCondition[]{RetryCondition.defaultRetryCondition(), RetryOnExceptionsCondition.create((Set)ImmutableSet.of(ConcurrentModificationException.class))});
    }
}

