/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.xray.model.Alias;
import software.amazon.awssdk.services.xray.model.AliasListCopier;
import software.amazon.awssdk.services.xray.model.EdgeStatistics;
import software.amazon.awssdk.services.xray.model.HistogramCopier;
import software.amazon.awssdk.services.xray.model.HistogramEntry;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Edge
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Edge> {
    private static final SdkField<Integer> REFERENCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ReferenceId").getter(Edge.getter(Edge::referenceId)).setter(Edge.setter(Builder::referenceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferenceId").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(Edge.getter(Edge::startTime)).setter(Edge.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(Edge.getter(Edge::endTime)).setter(Edge.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<EdgeStatistics> SUMMARY_STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SummaryStatistics").getter(Edge.getter(Edge::summaryStatistics)).setter(Edge.setter(Builder::summaryStatistics)).constructor(EdgeStatistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SummaryStatistics").build()}).build();
    private static final SdkField<List<HistogramEntry>> RESPONSE_TIME_HISTOGRAM_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResponseTimeHistogram").getter(Edge.getter(Edge::responseTimeHistogram)).setter(Edge.setter(Builder::responseTimeHistogram)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResponseTimeHistogram").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HistogramEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Alias>> ALIASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Aliases").getter(Edge.getter(Edge::aliases)).setter(Edge.setter(Builder::aliases)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Aliases").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Alias::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REFERENCE_ID_FIELD, START_TIME_FIELD, END_TIME_FIELD, SUMMARY_STATISTICS_FIELD, RESPONSE_TIME_HISTOGRAM_FIELD, ALIASES_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer referenceId;
    private final Instant startTime;
    private final Instant endTime;
    private final EdgeStatistics summaryStatistics;
    private final List<HistogramEntry> responseTimeHistogram;
    private final List<Alias> aliases;

    private Edge(BuilderImpl builder) {
        this.referenceId = builder.referenceId;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.summaryStatistics = builder.summaryStatistics;
        this.responseTimeHistogram = builder.responseTimeHistogram;
        this.aliases = builder.aliases;
    }

    public final Integer referenceId() {
        return this.referenceId;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final EdgeStatistics summaryStatistics() {
        return this.summaryStatistics;
    }

    public final boolean hasResponseTimeHistogram() {
        return this.responseTimeHistogram != null && !(this.responseTimeHistogram instanceof SdkAutoConstructList);
    }

    public final List<HistogramEntry> responseTimeHistogram() {
        return this.responseTimeHistogram;
    }

    public final boolean hasAliases() {
        return this.aliases != null && !(this.aliases instanceof SdkAutoConstructList);
    }

    public final List<Alias> aliases() {
        return this.aliases;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.referenceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.summaryStatistics());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResponseTimeHistogram() ? this.responseTimeHistogram() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAliases() ? this.aliases() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Edge)) {
            return false;
        }
        Edge other = (Edge)obj;
        return Objects.equals(this.referenceId(), other.referenceId()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.summaryStatistics(), other.summaryStatistics()) && this.hasResponseTimeHistogram() == other.hasResponseTimeHistogram() && Objects.equals(this.responseTimeHistogram(), other.responseTimeHistogram()) && this.hasAliases() == other.hasAliases() && Objects.equals(this.aliases(), other.aliases());
    }

    public final String toString() {
        return ToString.builder((String)"Edge").add("ReferenceId", (Object)this.referenceId()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("SummaryStatistics", (Object)this.summaryStatistics()).add("ResponseTimeHistogram", this.hasResponseTimeHistogram() ? this.responseTimeHistogram() : null).add("Aliases", this.hasAliases() ? this.aliases() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReferenceId": {
                return Optional.ofNullable(clazz.cast(this.referenceId()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "SummaryStatistics": {
                return Optional.ofNullable(clazz.cast(this.summaryStatistics()));
            }
            case "ResponseTimeHistogram": {
                return Optional.ofNullable(clazz.cast(this.responseTimeHistogram()));
            }
            case "Aliases": {
                return Optional.ofNullable(clazz.cast(this.aliases()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Edge, T> g) {
        return obj -> g.apply((Edge)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer referenceId;
        private Instant startTime;
        private Instant endTime;
        private EdgeStatistics summaryStatistics;
        private List<HistogramEntry> responseTimeHistogram = DefaultSdkAutoConstructList.getInstance();
        private List<Alias> aliases = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Edge model) {
            this.referenceId(model.referenceId);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.summaryStatistics(model.summaryStatistics);
            this.responseTimeHistogram(model.responseTimeHistogram);
            this.aliases(model.aliases);
        }

        public final Integer getReferenceId() {
            return this.referenceId;
        }

        @Override
        public final Builder referenceId(Integer referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public final void setReferenceId(Integer referenceId) {
            this.referenceId = referenceId;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final EdgeStatistics.Builder getSummaryStatistics() {
            return this.summaryStatistics != null ? this.summaryStatistics.toBuilder() : null;
        }

        @Override
        public final Builder summaryStatistics(EdgeStatistics summaryStatistics) {
            this.summaryStatistics = summaryStatistics;
            return this;
        }

        public final void setSummaryStatistics(EdgeStatistics.BuilderImpl summaryStatistics) {
            this.summaryStatistics = summaryStatistics != null ? summaryStatistics.build() : null;
        }

        public final Collection<HistogramEntry.Builder> getResponseTimeHistogram() {
            if (this.responseTimeHistogram instanceof SdkAutoConstructList) {
                return null;
            }
            return this.responseTimeHistogram != null ? (Collection)this.responseTimeHistogram.stream().map(HistogramEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder responseTimeHistogram(Collection<HistogramEntry> responseTimeHistogram) {
            this.responseTimeHistogram = HistogramCopier.copy(responseTimeHistogram);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder responseTimeHistogram(HistogramEntry ... responseTimeHistogram) {
            this.responseTimeHistogram(Arrays.asList(responseTimeHistogram));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder responseTimeHistogram(Consumer<HistogramEntry.Builder> ... responseTimeHistogram) {
            this.responseTimeHistogram(Stream.of(responseTimeHistogram).map(c -> (HistogramEntry)((HistogramEntry.Builder)HistogramEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResponseTimeHistogram(Collection<HistogramEntry.BuilderImpl> responseTimeHistogram) {
            this.responseTimeHistogram = HistogramCopier.copyFromBuilder(responseTimeHistogram);
        }

        public final Collection<Alias.Builder> getAliases() {
            if (this.aliases instanceof SdkAutoConstructList) {
                return null;
            }
            return this.aliases != null ? (Collection)this.aliases.stream().map(Alias::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder aliases(Collection<Alias> aliases) {
            this.aliases = AliasListCopier.copy(aliases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aliases(Alias ... aliases) {
            this.aliases(Arrays.asList(aliases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aliases(Consumer<Alias.Builder> ... aliases) {
            this.aliases(Stream.of(aliases).map(c -> (Alias)((Alias.Builder)Alias.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAliases(Collection<Alias.BuilderImpl> aliases) {
            this.aliases = AliasListCopier.copyFromBuilder(aliases);
        }

        public Edge build() {
            return new Edge(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Edge> {
        public Builder referenceId(Integer var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder summaryStatistics(EdgeStatistics var1);

        default public Builder summaryStatistics(Consumer<EdgeStatistics.Builder> summaryStatistics) {
            return this.summaryStatistics((EdgeStatistics)((EdgeStatistics.Builder)EdgeStatistics.builder().applyMutation(summaryStatistics)).build());
        }

        public Builder responseTimeHistogram(Collection<HistogramEntry> var1);

        public Builder responseTimeHistogram(HistogramEntry ... var1);

        public Builder responseTimeHistogram(Consumer<HistogramEntry.Builder> ... var1);

        public Builder aliases(Collection<Alias> var1);

        public Builder aliases(Alias ... var1);

        public Builder aliases(Consumer<Alias.Builder> ... var1);
    }
}

