/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workspacesweb.WorkSpacesWebAsyncClient;
import software.amazon.awssdk.services.workspacesweb.internal.UserAgentUtils;
import software.amazon.awssdk.services.workspacesweb.model.ListNetworkSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListNetworkSettingsResponse;

public class ListNetworkSettingsPublisher
implements SdkPublisher<ListNetworkSettingsResponse> {
    private final WorkSpacesWebAsyncClient client;
    private final ListNetworkSettingsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListNetworkSettingsPublisher(WorkSpacesWebAsyncClient client, ListNetworkSettingsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListNetworkSettingsPublisher(WorkSpacesWebAsyncClient client, ListNetworkSettingsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListNetworkSettingsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListNetworkSettingsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListNetworkSettingsResponseFetcher
    implements AsyncPageFetcher<ListNetworkSettingsResponse> {
        private ListNetworkSettingsResponseFetcher() {
        }

        public boolean hasNextPage(ListNetworkSettingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListNetworkSettingsResponse> nextPage(ListNetworkSettingsResponse previousPage) {
            if (previousPage == null) {
                return ListNetworkSettingsPublisher.this.client.listNetworkSettings(ListNetworkSettingsPublisher.this.firstRequest);
            }
            return ListNetworkSettingsPublisher.this.client.listNetworkSettings((ListNetworkSettingsRequest)((Object)ListNetworkSettingsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

