/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.workspacesweb.DefaultWorkSpacesWebBaseClientBuilder;
import software.amazon.awssdk.services.workspacesweb.DefaultWorkSpacesWebClient;
import software.amazon.awssdk.services.workspacesweb.WorkSpacesWebClient;
import software.amazon.awssdk.services.workspacesweb.WorkSpacesWebClientBuilder;
import software.amazon.awssdk.services.workspacesweb.WorkSpacesWebServiceClientConfiguration;
import software.amazon.awssdk.services.workspacesweb.endpoints.WorkSpacesWebEndpointProvider;

@SdkInternalApi
final class DefaultWorkSpacesWebClientBuilder
extends DefaultWorkSpacesWebBaseClientBuilder<WorkSpacesWebClientBuilder, WorkSpacesWebClient>
implements WorkSpacesWebClientBuilder {
    DefaultWorkSpacesWebClientBuilder() {
    }

    @Override
    public DefaultWorkSpacesWebClientBuilder endpointProvider(WorkSpacesWebEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final WorkSpacesWebClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultWorkSpacesWebClientBuilder.validateClientOptions(clientConfiguration);
        WorkSpacesWebServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultWorkSpacesWebClient client = new DefaultWorkSpacesWebClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private WorkSpacesWebServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return WorkSpacesWebServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

