/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.util.VersionInfo;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.workspaces.model.AccessDeniedException;
import software.amazon.awssdk.services.workspaces.model.AssociateConnectionAliasRequest;
import software.amazon.awssdk.services.workspaces.model.AssociateConnectionAliasResponse;
import software.amazon.awssdk.services.workspaces.model.AssociateIpGroupsRequest;
import software.amazon.awssdk.services.workspaces.model.AssociateIpGroupsResponse;
import software.amazon.awssdk.services.workspaces.model.AuthorizeIpRulesRequest;
import software.amazon.awssdk.services.workspaces.model.AuthorizeIpRulesResponse;
import software.amazon.awssdk.services.workspaces.model.CopyWorkspaceImageRequest;
import software.amazon.awssdk.services.workspaces.model.CopyWorkspaceImageResponse;
import software.amazon.awssdk.services.workspaces.model.CreateConnectClientAddInRequest;
import software.amazon.awssdk.services.workspaces.model.CreateConnectClientAddInResponse;
import software.amazon.awssdk.services.workspaces.model.CreateConnectionAliasRequest;
import software.amazon.awssdk.services.workspaces.model.CreateConnectionAliasResponse;
import software.amazon.awssdk.services.workspaces.model.CreateIpGroupRequest;
import software.amazon.awssdk.services.workspaces.model.CreateIpGroupResponse;
import software.amazon.awssdk.services.workspaces.model.CreateStandbyWorkspacesRequest;
import software.amazon.awssdk.services.workspaces.model.CreateStandbyWorkspacesResponse;
import software.amazon.awssdk.services.workspaces.model.CreateTagsRequest;
import software.amazon.awssdk.services.workspaces.model.CreateTagsResponse;
import software.amazon.awssdk.services.workspaces.model.CreateUpdatedWorkspaceImageRequest;
import software.amazon.awssdk.services.workspaces.model.CreateUpdatedWorkspaceImageResponse;
import software.amazon.awssdk.services.workspaces.model.CreateWorkspaceBundleRequest;
import software.amazon.awssdk.services.workspaces.model.CreateWorkspaceBundleResponse;
import software.amazon.awssdk.services.workspaces.model.CreateWorkspaceImageRequest;
import software.amazon.awssdk.services.workspaces.model.CreateWorkspaceImageResponse;
import software.amazon.awssdk.services.workspaces.model.CreateWorkspacesRequest;
import software.amazon.awssdk.services.workspaces.model.CreateWorkspacesResponse;
import software.amazon.awssdk.services.workspaces.model.DeleteClientBrandingRequest;
import software.amazon.awssdk.services.workspaces.model.DeleteClientBrandingResponse;
import software.amazon.awssdk.services.workspaces.model.DeleteConnectClientAddInRequest;
import software.amazon.awssdk.services.workspaces.model.DeleteConnectClientAddInResponse;
import software.amazon.awssdk.services.workspaces.model.DeleteConnectionAliasRequest;
import software.amazon.awssdk.services.workspaces.model.DeleteConnectionAliasResponse;
import software.amazon.awssdk.services.workspaces.model.DeleteIpGroupRequest;
import software.amazon.awssdk.services.workspaces.model.DeleteIpGroupResponse;
import software.amazon.awssdk.services.workspaces.model.DeleteTagsRequest;
import software.amazon.awssdk.services.workspaces.model.DeleteTagsResponse;
import software.amazon.awssdk.services.workspaces.model.DeleteWorkspaceBundleRequest;
import software.amazon.awssdk.services.workspaces.model.DeleteWorkspaceBundleResponse;
import software.amazon.awssdk.services.workspaces.model.DeleteWorkspaceImageRequest;
import software.amazon.awssdk.services.workspaces.model.DeleteWorkspaceImageResponse;
import software.amazon.awssdk.services.workspaces.model.DeregisterWorkspaceDirectoryRequest;
import software.amazon.awssdk.services.workspaces.model.DeregisterWorkspaceDirectoryResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeAccountModificationsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeAccountModificationsResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeAccountRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeAccountResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeClientBrandingRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeClientBrandingResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeClientPropertiesRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeClientPropertiesResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeConnectClientAddInsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeConnectClientAddInsResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeConnectionAliasPermissionsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeConnectionAliasPermissionsResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeConnectionAliasesRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeConnectionAliasesResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeIpGroupsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeIpGroupsResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeTagsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeTagsResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagePermissionsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagePermissionsResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagesRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagesResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceSnapshotsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceSnapshotsResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesConnectionStatusRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesConnectionStatusResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesResponse;
import software.amazon.awssdk.services.workspaces.model.DisassociateConnectionAliasRequest;
import software.amazon.awssdk.services.workspaces.model.DisassociateConnectionAliasResponse;
import software.amazon.awssdk.services.workspaces.model.DisassociateIpGroupsRequest;
import software.amazon.awssdk.services.workspaces.model.DisassociateIpGroupsResponse;
import software.amazon.awssdk.services.workspaces.model.ImportClientBrandingRequest;
import software.amazon.awssdk.services.workspaces.model.ImportClientBrandingResponse;
import software.amazon.awssdk.services.workspaces.model.ImportWorkspaceImageRequest;
import software.amazon.awssdk.services.workspaces.model.ImportWorkspaceImageResponse;
import software.amazon.awssdk.services.workspaces.model.InvalidParameterValuesException;
import software.amazon.awssdk.services.workspaces.model.InvalidResourceStateException;
import software.amazon.awssdk.services.workspaces.model.ListAvailableManagementCidrRangesRequest;
import software.amazon.awssdk.services.workspaces.model.ListAvailableManagementCidrRangesResponse;
import software.amazon.awssdk.services.workspaces.model.MigrateWorkspaceRequest;
import software.amazon.awssdk.services.workspaces.model.MigrateWorkspaceResponse;
import software.amazon.awssdk.services.workspaces.model.ModifyAccountRequest;
import software.amazon.awssdk.services.workspaces.model.ModifyAccountResponse;
import software.amazon.awssdk.services.workspaces.model.ModifyCertificateBasedAuthPropertiesRequest;
import software.amazon.awssdk.services.workspaces.model.ModifyCertificateBasedAuthPropertiesResponse;
import software.amazon.awssdk.services.workspaces.model.ModifyClientPropertiesRequest;
import software.amazon.awssdk.services.workspaces.model.ModifyClientPropertiesResponse;
import software.amazon.awssdk.services.workspaces.model.ModifySamlPropertiesRequest;
import software.amazon.awssdk.services.workspaces.model.ModifySamlPropertiesResponse;
import software.amazon.awssdk.services.workspaces.model.ModifySelfservicePermissionsRequest;
import software.amazon.awssdk.services.workspaces.model.ModifySelfservicePermissionsResponse;
import software.amazon.awssdk.services.workspaces.model.ModifyWorkspaceAccessPropertiesRequest;
import software.amazon.awssdk.services.workspaces.model.ModifyWorkspaceAccessPropertiesResponse;
import software.amazon.awssdk.services.workspaces.model.ModifyWorkspaceCreationPropertiesRequest;
import software.amazon.awssdk.services.workspaces.model.ModifyWorkspaceCreationPropertiesResponse;
import software.amazon.awssdk.services.workspaces.model.ModifyWorkspacePropertiesRequest;
import software.amazon.awssdk.services.workspaces.model.ModifyWorkspacePropertiesResponse;
import software.amazon.awssdk.services.workspaces.model.ModifyWorkspaceStateRequest;
import software.amazon.awssdk.services.workspaces.model.ModifyWorkspaceStateResponse;
import software.amazon.awssdk.services.workspaces.model.OperationInProgressException;
import software.amazon.awssdk.services.workspaces.model.OperationNotSupportedException;
import software.amazon.awssdk.services.workspaces.model.RebootWorkspacesRequest;
import software.amazon.awssdk.services.workspaces.model.RebootWorkspacesResponse;
import software.amazon.awssdk.services.workspaces.model.RebuildWorkspacesRequest;
import software.amazon.awssdk.services.workspaces.model.RebuildWorkspacesResponse;
import software.amazon.awssdk.services.workspaces.model.RegisterWorkspaceDirectoryRequest;
import software.amazon.awssdk.services.workspaces.model.RegisterWorkspaceDirectoryResponse;
import software.amazon.awssdk.services.workspaces.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.workspaces.model.ResourceAssociatedException;
import software.amazon.awssdk.services.workspaces.model.ResourceCreationFailedException;
import software.amazon.awssdk.services.workspaces.model.ResourceLimitExceededException;
import software.amazon.awssdk.services.workspaces.model.ResourceNotFoundException;
import software.amazon.awssdk.services.workspaces.model.ResourceUnavailableException;
import software.amazon.awssdk.services.workspaces.model.RestoreWorkspaceRequest;
import software.amazon.awssdk.services.workspaces.model.RestoreWorkspaceResponse;
import software.amazon.awssdk.services.workspaces.model.RevokeIpRulesRequest;
import software.amazon.awssdk.services.workspaces.model.RevokeIpRulesResponse;
import software.amazon.awssdk.services.workspaces.model.StartWorkspacesRequest;
import software.amazon.awssdk.services.workspaces.model.StartWorkspacesResponse;
import software.amazon.awssdk.services.workspaces.model.StopWorkspacesRequest;
import software.amazon.awssdk.services.workspaces.model.StopWorkspacesResponse;
import software.amazon.awssdk.services.workspaces.model.TerminateWorkspacesRequest;
import software.amazon.awssdk.services.workspaces.model.TerminateWorkspacesResponse;
import software.amazon.awssdk.services.workspaces.model.UnsupportedNetworkConfigurationException;
import software.amazon.awssdk.services.workspaces.model.UnsupportedWorkspaceConfigurationException;
import software.amazon.awssdk.services.workspaces.model.UpdateConnectClientAddInRequest;
import software.amazon.awssdk.services.workspaces.model.UpdateConnectClientAddInResponse;
import software.amazon.awssdk.services.workspaces.model.UpdateConnectionAliasPermissionRequest;
import software.amazon.awssdk.services.workspaces.model.UpdateConnectionAliasPermissionResponse;
import software.amazon.awssdk.services.workspaces.model.UpdateRulesOfIpGroupRequest;
import software.amazon.awssdk.services.workspaces.model.UpdateRulesOfIpGroupResponse;
import software.amazon.awssdk.services.workspaces.model.UpdateWorkspaceBundleRequest;
import software.amazon.awssdk.services.workspaces.model.UpdateWorkspaceBundleResponse;
import software.amazon.awssdk.services.workspaces.model.UpdateWorkspaceImagePermissionRequest;
import software.amazon.awssdk.services.workspaces.model.UpdateWorkspaceImagePermissionResponse;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesException;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesRequest;
import software.amazon.awssdk.services.workspaces.model.WorkspacesDefaultRoleNotFoundException;
import software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspaceBundlesIterable;
import software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspaceDirectoriesIterable;
import software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspacesIterable;
import software.amazon.awssdk.services.workspaces.transform.AssociateConnectionAliasRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.AssociateIpGroupsRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.AuthorizeIpRulesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.CopyWorkspaceImageRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.CreateConnectClientAddInRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.CreateConnectionAliasRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.CreateIpGroupRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.CreateStandbyWorkspacesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.CreateTagsRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.CreateUpdatedWorkspaceImageRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.CreateWorkspaceBundleRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.CreateWorkspaceImageRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.CreateWorkspacesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DeleteClientBrandingRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DeleteConnectClientAddInRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DeleteConnectionAliasRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DeleteIpGroupRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DeleteTagsRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DeleteWorkspaceBundleRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DeleteWorkspaceImageRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DeregisterWorkspaceDirectoryRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeAccountModificationsRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeAccountRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeClientBrandingRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeClientPropertiesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeConnectClientAddInsRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeConnectionAliasPermissionsRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeConnectionAliasesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeIpGroupsRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeTagsRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeWorkspaceBundlesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeWorkspaceDirectoriesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeWorkspaceImagePermissionsRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeWorkspaceImagesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeWorkspaceSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeWorkspacesConnectionStatusRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeWorkspacesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DisassociateConnectionAliasRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DisassociateIpGroupsRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.ImportClientBrandingRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.ImportWorkspaceImageRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.ListAvailableManagementCidrRangesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.MigrateWorkspaceRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.ModifyAccountRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.ModifyCertificateBasedAuthPropertiesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.ModifyClientPropertiesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.ModifySamlPropertiesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.ModifySelfservicePermissionsRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.ModifyWorkspaceAccessPropertiesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.ModifyWorkspaceCreationPropertiesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.ModifyWorkspacePropertiesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.ModifyWorkspaceStateRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.RebootWorkspacesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.RebuildWorkspacesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.RegisterWorkspaceDirectoryRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.RestoreWorkspaceRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.RevokeIpRulesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.StartWorkspacesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.StopWorkspacesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.TerminateWorkspacesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.UpdateConnectClientAddInRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.UpdateConnectionAliasPermissionRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.UpdateRulesOfIpGroupRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.UpdateWorkspaceBundleRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.UpdateWorkspaceImagePermissionRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link WorkSpacesClient}.
 *
 * @see WorkSpacesClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultWorkSpacesClient implements WorkSpacesClient {
    private static final Logger log = Logger.loggerFor(DefaultWorkSpacesClient.class);

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    private final WorkSpacesServiceClientConfiguration serviceClientConfiguration;

    protected DefaultWorkSpacesClient(WorkSpacesServiceClientConfiguration serviceClientConfiguration,
            SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Associates the specified connection alias with the specified directory to enable cross-Region redirection. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html"> Cross-Region
     * Redirection for Amazon WorkSpaces</a>.
     * </p>
     * <note>
     * <p>
     * Before performing this operation, call <a
     * href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeConnectionAliases.html">
     * DescribeConnectionAliases</a> to make sure that the current state of the connection alias is <code>CREATED</code>
     * .
     * </p>
     * </note>
     *
     * @param associateConnectionAliasRequest
     * @return Result of the AssociateConnectionAlias operation returned by the service.
     * @throws ResourceAssociatedException
     *         The resource is associated with a directory.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.AssociateConnectionAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/AssociateConnectionAlias"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateConnectionAliasResponse associateConnectionAlias(
            AssociateConnectionAliasRequest associateConnectionAliasRequest) throws ResourceAssociatedException,
            AccessDeniedException, ResourceNotFoundException, InvalidParameterValuesException, InvalidResourceStateException,
            OperationNotSupportedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateConnectionAliasResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateConnectionAliasResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateConnectionAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateConnectionAlias");

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateConnectionAliasRequest, AssociateConnectionAliasResponse>()
                            .withOperationName("AssociateConnectionAlias").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(associateConnectionAliasRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociateConnectionAliasRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates the specified IP access control group with the specified directory.
     * </p>
     *
     * @param associateIpGroupsRequest
     * @return Result of the AssociateIpGroups operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.AssociateIpGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/AssociateIpGroups" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public AssociateIpGroupsResponse associateIpGroups(AssociateIpGroupsRequest associateIpGroupsRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, ResourceLimitExceededException,
            InvalidResourceStateException, AccessDeniedException, OperationNotSupportedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateIpGroupsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                AssociateIpGroupsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateIpGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateIpGroups");

            return clientHandler.execute(new ClientExecutionParams<AssociateIpGroupsRequest, AssociateIpGroupsResponse>()
                    .withOperationName("AssociateIpGroups").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(associateIpGroupsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AssociateIpGroupsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds one or more rules to the specified IP access control group.
     * </p>
     * <p>
     * This action gives users permission to access their WorkSpaces from the CIDR address ranges specified in the
     * rules.
     * </p>
     *
     * @param authorizeIpRulesRequest
     * @return Result of the AuthorizeIpRules operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.AuthorizeIpRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/AuthorizeIpRules" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public AuthorizeIpRulesResponse authorizeIpRules(AuthorizeIpRulesRequest authorizeIpRulesRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, ResourceLimitExceededException,
            InvalidResourceStateException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AuthorizeIpRulesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                AuthorizeIpRulesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, authorizeIpRulesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AuthorizeIpRules");

            return clientHandler.execute(new ClientExecutionParams<AuthorizeIpRulesRequest, AuthorizeIpRulesResponse>()
                    .withOperationName("AuthorizeIpRules").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(authorizeIpRulesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AuthorizeIpRulesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Copies the specified image from the specified Region to the current Region. For more information about copying
     * images, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/copy-custom-image.html"> Copy a
     * Custom WorkSpaces Image</a>.
     * </p>
     * <p>
     * In the China (Ningxia) Region, you can copy images only within the same Region.
     * </p>
     * <p>
     * In Amazon Web Services GovCloud (US), to copy images to and from other Regions, contact Amazon Web Services
     * Support.
     * </p>
     * <important>
     * <p>
     * Before copying a shared image, be sure to verify that it has been shared from the correct Amazon Web Services
     * account. To determine if an image has been shared and to see the ID of the Amazon Web Services account that owns
     * an image, use the <a href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceImages.html">
     * DescribeWorkSpaceImages</a> and <a
     * href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceImagePermissions.html"
     * >DescribeWorkspaceImagePermissions</a> API operations.
     * </p>
     * </important>
     *
     * @param copyWorkspaceImageRequest
     * @return Result of the CopyWorkspaceImage operation returned by the service.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceUnavailableException
     *         The specified resource is not available.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.CopyWorkspaceImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CopyWorkspaceImage" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CopyWorkspaceImageResponse copyWorkspaceImage(CopyWorkspaceImageRequest copyWorkspaceImageRequest)
            throws ResourceLimitExceededException, ResourceAlreadyExistsException, ResourceNotFoundException,
            ResourceUnavailableException, OperationNotSupportedException, AccessDeniedException, InvalidParameterValuesException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CopyWorkspaceImageResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CopyWorkspaceImageResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, copyWorkspaceImageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CopyWorkspaceImage");

            return clientHandler.execute(new ClientExecutionParams<CopyWorkspaceImageRequest, CopyWorkspaceImageResponse>()
                    .withOperationName("CopyWorkspaceImage").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(copyWorkspaceImageRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CopyWorkspaceImageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a client-add-in for Amazon Connect within a directory. You can create only one Amazon Connect client
     * add-in within a directory.
     * </p>
     * <p>
     * This client add-in allows WorkSpaces users to seamlessly connect to Amazon Connect.
     * </p>
     *
     * @param createConnectClientAddInRequest
     * @return Result of the CreateConnectClientAddIn operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceCreationFailedException
     *         The resource could not be created.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.CreateConnectClientAddIn
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateConnectClientAddIn"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateConnectClientAddInResponse createConnectClientAddIn(
            CreateConnectClientAddInRequest createConnectClientAddInRequest) throws InvalidParameterValuesException,
            ResourceNotFoundException, ResourceCreationFailedException, ResourceAlreadyExistsException, AccessDeniedException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateConnectClientAddInResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateConnectClientAddInResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createConnectClientAddInRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateConnectClientAddIn");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateConnectClientAddInRequest, CreateConnectClientAddInResponse>()
                            .withOperationName("CreateConnectClientAddIn").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createConnectClientAddInRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateConnectClientAddInRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates the specified connection alias for use with cross-Region redirection. For more information, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html"> Cross-Region
     * Redirection for Amazon WorkSpaces</a>.
     * </p>
     *
     * @param createConnectionAliasRequest
     * @return Result of the CreateConnectionAlias operation returned by the service.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.CreateConnectionAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateConnectionAlias"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateConnectionAliasResponse createConnectionAlias(CreateConnectionAliasRequest createConnectionAliasRequest)
            throws ResourceAlreadyExistsException, AccessDeniedException, InvalidParameterValuesException,
            ResourceLimitExceededException, InvalidResourceStateException, OperationNotSupportedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateConnectionAliasResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateConnectionAliasResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createConnectionAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateConnectionAlias");

            return clientHandler.execute(new ClientExecutionParams<CreateConnectionAliasRequest, CreateConnectionAliasResponse>()
                    .withOperationName("CreateConnectionAlias").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createConnectionAliasRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateConnectionAliasRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an IP access control group.
     * </p>
     * <p>
     * An IP access control group provides you with the ability to control the IP addresses from which users are allowed
     * to access their WorkSpaces. To specify the CIDR address ranges, add rules to your IP access control group and
     * then associate the group with your directory. You can add rules when you create the group or at any time using
     * <a>AuthorizeIpRules</a>.
     * </p>
     * <p>
     * There is a default IP access control group associated with your directory. If you don't associate an IP access
     * control group with your directory, the default group is used. The default group includes a default rule that
     * allows users to access their WorkSpaces from anywhere. You cannot modify the default IP access control group for
     * your directory.
     * </p>
     *
     * @param createIpGroupRequest
     * @return Result of the CreateIpGroup operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws ResourceCreationFailedException
     *         The resource could not be created.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.CreateIpGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateIpGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateIpGroupResponse createIpGroup(CreateIpGroupRequest createIpGroupRequest) throws InvalidParameterValuesException,
            ResourceLimitExceededException, ResourceAlreadyExistsException, ResourceCreationFailedException,
            AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateIpGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateIpGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createIpGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateIpGroup");

            return clientHandler.execute(new ClientExecutionParams<CreateIpGroupRequest, CreateIpGroupResponse>()
                    .withOperationName("CreateIpGroup").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createIpGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateIpGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a standby WorkSpace in a secondary Region.
     * </p>
     *
     * @param createStandbyWorkspacesRequest
     * @return Result of the CreateStandbyWorkspaces operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.CreateStandbyWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateStandbyWorkspaces"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateStandbyWorkspacesResponse createStandbyWorkspaces(CreateStandbyWorkspacesRequest createStandbyWorkspacesRequest)
            throws AccessDeniedException, InvalidParameterValuesException, OperationNotSupportedException,
            ResourceNotFoundException, ResourceLimitExceededException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateStandbyWorkspacesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateStandbyWorkspacesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createStandbyWorkspacesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateStandbyWorkspaces");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateStandbyWorkspacesRequest, CreateStandbyWorkspacesResponse>()
                            .withOperationName("CreateStandbyWorkspaces").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createStandbyWorkspacesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateStandbyWorkspacesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates the specified tags for the specified WorkSpaces resource.
     * </p>
     *
     * @param createTagsRequest
     * @return Result of the CreateTags operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.CreateTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateTags" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateTagsResponse createTags(CreateTagsRequest createTagsRequest) throws ResourceNotFoundException,
            InvalidParameterValuesException, ResourceLimitExceededException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateTagsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateTagsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTagsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTags");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateTagsRequest, CreateTagsResponse>().withOperationName("CreateTags")
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createTagsRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateTagsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new updated WorkSpace image based on the specified source image. The new updated WorkSpace image has
     * the latest drivers and other updates required by the Amazon WorkSpaces components.
     * </p>
     * <p>
     * To determine which WorkSpace images need to be updated with the latest Amazon WorkSpaces requirements, use <a
     * href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceImages.html">
     * DescribeWorkspaceImages</a>.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * Only Windows 10, Windows Server 2016, and Windows Server 2019 WorkSpace images can be programmatically updated at
     * this time.
     * </p>
     * </li>
     * <li>
     * <p>
     * Microsoft Windows updates and other application updates are not included in the update process.
     * </p>
     * </li>
     * <li>
     * <p>
     * The source WorkSpace image is not deleted. You can delete the source image after you've verified your new updated
     * image and created a new bundle.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param createUpdatedWorkspaceImageRequest
     * @return Result of the CreateUpdatedWorkspaceImage operation returned by the service.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.CreateUpdatedWorkspaceImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateUpdatedWorkspaceImage"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateUpdatedWorkspaceImageResponse createUpdatedWorkspaceImage(
            CreateUpdatedWorkspaceImageRequest createUpdatedWorkspaceImageRequest) throws ResourceLimitExceededException,
            ResourceAlreadyExistsException, ResourceNotFoundException, OperationNotSupportedException,
            InvalidResourceStateException, AccessDeniedException, InvalidParameterValuesException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateUpdatedWorkspaceImageResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateUpdatedWorkspaceImageResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createUpdatedWorkspaceImageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateUpdatedWorkspaceImage");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateUpdatedWorkspaceImageRequest, CreateUpdatedWorkspaceImageResponse>()
                            .withOperationName("CreateUpdatedWorkspaceImage").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createUpdatedWorkspaceImageRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateUpdatedWorkspaceImageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates the specified WorkSpace bundle. For more information about creating WorkSpace bundles, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/create-custom-bundle.html"> Create a Custom
     * WorkSpaces Image and Bundle</a>.
     * </p>
     *
     * @param createWorkspaceBundleRequest
     * @return Result of the CreateWorkspaceBundle operation returned by the service.
     * @throws ResourceUnavailableException
     *         The specified resource is not available.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.CreateWorkspaceBundle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateWorkspaceBundle"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateWorkspaceBundleResponse createWorkspaceBundle(CreateWorkspaceBundleRequest createWorkspaceBundleRequest)
            throws ResourceUnavailableException, ResourceAlreadyExistsException, ResourceLimitExceededException,
            InvalidParameterValuesException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateWorkspaceBundleResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateWorkspaceBundleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createWorkspaceBundleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateWorkspaceBundle");

            return clientHandler.execute(new ClientExecutionParams<CreateWorkspaceBundleRequest, CreateWorkspaceBundleResponse>()
                    .withOperationName("CreateWorkspaceBundle").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createWorkspaceBundleRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateWorkspaceBundleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new WorkSpace image from an existing WorkSpace.
     * </p>
     *
     * @param createWorkspaceImageRequest
     * @return Result of the CreateWorkspaceImage operation returned by the service.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.CreateWorkspaceImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateWorkspaceImage"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateWorkspaceImageResponse createWorkspaceImage(CreateWorkspaceImageRequest createWorkspaceImageRequest)
            throws ResourceLimitExceededException, ResourceAlreadyExistsException, ResourceNotFoundException,
            OperationNotSupportedException, InvalidResourceStateException, AccessDeniedException,
            InvalidParameterValuesException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateWorkspaceImageResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateWorkspaceImageResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createWorkspaceImageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateWorkspaceImage");

            return clientHandler.execute(new ClientExecutionParams<CreateWorkspaceImageRequest, CreateWorkspaceImageResponse>()
                    .withOperationName("CreateWorkspaceImage").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createWorkspaceImageRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateWorkspaceImageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates one or more WorkSpaces.
     * </p>
     * <p>
     * This operation is asynchronous and returns before the WorkSpaces are created.
     * </p>
     * <note>
     * <p>
     * The <code>MANUAL</code> running mode value is only supported by Amazon WorkSpaces Core. Contact your account team
     * to be allow-listed to use this value. For more information, see <a
     * href="http://aws.amazon.com/workspaces/core/">Amazon WorkSpaces Core</a>.
     * </p>
     * </note>
     *
     * @param createWorkspacesRequest
     * @return Result of the CreateWorkspaces operation returned by the service.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.CreateWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateWorkspaces" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateWorkspacesResponse createWorkspaces(CreateWorkspacesRequest createWorkspacesRequest)
            throws ResourceLimitExceededException, InvalidParameterValuesException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateWorkspacesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateWorkspacesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createWorkspacesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateWorkspaces");

            return clientHandler.execute(new ClientExecutionParams<CreateWorkspacesRequest, CreateWorkspacesResponse>()
                    .withOperationName("CreateWorkspaces").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createWorkspacesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateWorkspacesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes customized client branding. Client branding allows you to customize your WorkSpace's client login portal.
     * You can tailor your login portal company logo, the support email address, support link, link to reset password,
     * and a custom message for users trying to sign in.
     * </p>
     * <p>
     * After you delete your customized client branding, your login portal reverts to the default client branding.
     * </p>
     *
     * @param deleteClientBrandingRequest
     * @return Result of the DeleteClientBranding operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DeleteClientBranding
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteClientBranding"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteClientBrandingResponse deleteClientBranding(DeleteClientBrandingRequest deleteClientBrandingRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteClientBrandingResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteClientBrandingResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteClientBrandingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteClientBranding");

            return clientHandler.execute(new ClientExecutionParams<DeleteClientBrandingRequest, DeleteClientBrandingResponse>()
                    .withOperationName("DeleteClientBranding").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteClientBrandingRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteClientBrandingRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a client-add-in for Amazon Connect that is configured within a directory.
     * </p>
     *
     * @param deleteConnectClientAddInRequest
     * @return Result of the DeleteConnectClientAddIn operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DeleteConnectClientAddIn
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteConnectClientAddIn"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteConnectClientAddInResponse deleteConnectClientAddIn(
            DeleteConnectClientAddInRequest deleteConnectClientAddInRequest) throws InvalidParameterValuesException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteConnectClientAddInResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteConnectClientAddInResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteConnectClientAddInRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteConnectClientAddIn");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteConnectClientAddInRequest, DeleteConnectClientAddInResponse>()
                            .withOperationName("DeleteConnectClientAddIn").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteConnectClientAddInRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteConnectClientAddInRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified connection alias. For more information, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html"> Cross-Region
     * Redirection for Amazon WorkSpaces</a>.
     * </p>
     * <important>
     * <p>
     * <b>If you will no longer be using a fully qualified domain name (FQDN) as the registration code for your
     * WorkSpaces users, you must take certain precautions to prevent potential security issues.</b> For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html#cross-region-redirection-security-considerations"
     * > Security Considerations if You Stop Using Cross-Region Redirection</a>.
     * </p>
     * </important> <note>
     * <p>
     * To delete a connection alias that has been shared, the shared account must first disassociate the connection
     * alias from any directories it has been associated with. Then you must unshare the connection alias from the
     * account it has been shared with. You can delete a connection alias only after it is no longer shared with any
     * accounts or associated with any directories.
     * </p>
     * </note>
     *
     * @param deleteConnectionAliasRequest
     * @return Result of the DeleteConnectionAlias operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceAssociatedException
     *         The resource is associated with a directory.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DeleteConnectionAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteConnectionAlias"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteConnectionAliasResponse deleteConnectionAlias(DeleteConnectionAliasRequest deleteConnectionAliasRequest)
            throws ResourceNotFoundException, ResourceAssociatedException, AccessDeniedException,
            InvalidParameterValuesException, InvalidResourceStateException, OperationNotSupportedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteConnectionAliasResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteConnectionAliasResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteConnectionAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteConnectionAlias");

            return clientHandler.execute(new ClientExecutionParams<DeleteConnectionAliasRequest, DeleteConnectionAliasResponse>()
                    .withOperationName("DeleteConnectionAlias").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteConnectionAliasRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteConnectionAliasRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified IP access control group.
     * </p>
     * <p>
     * You cannot delete an IP access control group that is associated with a directory.
     * </p>
     *
     * @param deleteIpGroupRequest
     * @return Result of the DeleteIpGroup operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceAssociatedException
     *         The resource is associated with a directory.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DeleteIpGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteIpGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteIpGroupResponse deleteIpGroup(DeleteIpGroupRequest deleteIpGroupRequest) throws InvalidParameterValuesException,
            ResourceNotFoundException, ResourceAssociatedException, AccessDeniedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteIpGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteIpGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteIpGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteIpGroup");

            return clientHandler.execute(new ClientExecutionParams<DeleteIpGroupRequest, DeleteIpGroupResponse>()
                    .withOperationName("DeleteIpGroup").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteIpGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteIpGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified tags from the specified WorkSpaces resource.
     * </p>
     *
     * @param deleteTagsRequest
     * @return Result of the DeleteTags operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DeleteTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteTags" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteTagsResponse deleteTags(DeleteTagsRequest deleteTagsRequest) throws ResourceNotFoundException,
            InvalidParameterValuesException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteTagsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteTagsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTagsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTags");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteTagsRequest, DeleteTagsResponse>().withOperationName("DeleteTags")
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteTagsRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteTagsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified WorkSpace bundle. For more information about deleting WorkSpace bundles, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/delete_bundle.html"> Delete a Custom WorkSpaces
     * Bundle or Image</a>.
     * </p>
     *
     * @param deleteWorkspaceBundleRequest
     * @return Result of the DeleteWorkspaceBundle operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceAssociatedException
     *         The resource is associated with a directory.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DeleteWorkspaceBundle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteWorkspaceBundle"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteWorkspaceBundleResponse deleteWorkspaceBundle(DeleteWorkspaceBundleRequest deleteWorkspaceBundleRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, ResourceAssociatedException,
            AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteWorkspaceBundleResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteWorkspaceBundleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteWorkspaceBundleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteWorkspaceBundle");

            return clientHandler.execute(new ClientExecutionParams<DeleteWorkspaceBundleRequest, DeleteWorkspaceBundleResponse>()
                    .withOperationName("DeleteWorkspaceBundle").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteWorkspaceBundleRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteWorkspaceBundleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified image from your account. To delete an image, you must first delete any bundles that are
     * associated with the image and unshare the image if it is shared with other accounts.
     * </p>
     *
     * @param deleteWorkspaceImageRequest
     * @return Result of the DeleteWorkspaceImage operation returned by the service.
     * @throws ResourceAssociatedException
     *         The resource is associated with a directory.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DeleteWorkspaceImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteWorkspaceImage"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteWorkspaceImageResponse deleteWorkspaceImage(DeleteWorkspaceImageRequest deleteWorkspaceImageRequest)
            throws ResourceAssociatedException, InvalidResourceStateException, AccessDeniedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteWorkspaceImageResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteWorkspaceImageResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteWorkspaceImageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteWorkspaceImage");

            return clientHandler.execute(new ClientExecutionParams<DeleteWorkspaceImageRequest, DeleteWorkspaceImageResponse>()
                    .withOperationName("DeleteWorkspaceImage").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteWorkspaceImageRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteWorkspaceImageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deregisters the specified directory. This operation is asynchronous and returns before the WorkSpace directory is
     * deregistered. If any WorkSpaces are registered to this directory, you must remove them before you can deregister
     * the directory.
     * </p>
     * <note>
     * <p>
     * Simple AD and AD Connector are made available to you free of charge to use with WorkSpaces. If there are no
     * WorkSpaces being used with your Simple AD or AD Connector directory for 30 consecutive days, this directory will
     * be automatically deregistered for use with Amazon WorkSpaces, and you will be charged for this directory as per
     * the <a href="http://aws.amazon.com/directoryservice/pricing/">Directory Service pricing terms</a>.
     * </p>
     * <p>
     * To delete empty directories, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/delete-workspaces-directory.html"> Delete the
     * Directory for Your WorkSpaces</a>. If you delete your Simple AD or AD Connector directory, you can always create
     * a new one when you want to start using WorkSpaces again.
     * </p>
     * </note>
     *
     * @param deregisterWorkspaceDirectoryRequest
     * @return Result of the DeregisterWorkspaceDirectory operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DeregisterWorkspaceDirectory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeregisterWorkspaceDirectory"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeregisterWorkspaceDirectoryResponse deregisterWorkspaceDirectory(
            DeregisterWorkspaceDirectoryRequest deregisterWorkspaceDirectoryRequest) throws AccessDeniedException,
            InvalidParameterValuesException, OperationNotSupportedException, ResourceNotFoundException,
            InvalidResourceStateException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeregisterWorkspaceDirectoryResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeregisterWorkspaceDirectoryResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deregisterWorkspaceDirectoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeregisterWorkspaceDirectory");

            return clientHandler
                    .execute(new ClientExecutionParams<DeregisterWorkspaceDirectoryRequest, DeregisterWorkspaceDirectoryResponse>()
                            .withOperationName("DeregisterWorkspaceDirectory").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deregisterWorkspaceDirectoryRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeregisterWorkspaceDirectoryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list that describes the configuration of Bring Your Own License (BYOL) for the specified account.
     * </p>
     *
     * @param describeAccountRequest
     * @return Result of the DescribeAccount operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeAccount" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeAccountResponse describeAccount(DescribeAccountRequest describeAccountRequest) throws AccessDeniedException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAccountResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeAccountResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAccountRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAccount");

            return clientHandler.execute(new ClientExecutionParams<DescribeAccountRequest, DescribeAccountResponse>()
                    .withOperationName("DescribeAccount").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeAccountRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeAccountRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list that describes modifications to the configuration of Bring Your Own License (BYOL) for the
     * specified account.
     * </p>
     *
     * @param describeAccountModificationsRequest
     * @return Result of the DescribeAccountModifications operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeAccountModifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeAccountModifications"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeAccountModificationsResponse describeAccountModifications(
            DescribeAccountModificationsRequest describeAccountModificationsRequest) throws AccessDeniedException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAccountModificationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeAccountModificationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAccountModificationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAccountModifications");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeAccountModificationsRequest, DescribeAccountModificationsResponse>()
                            .withOperationName("DescribeAccountModifications").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeAccountModificationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeAccountModificationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the specified client branding. Client branding allows you to customize the log in page of various
     * device types for your users. You can add your company logo, the support email address, support link, link to
     * reset password, and a custom message for users trying to sign in.
     * </p>
     * <note>
     * <p>
     * Only device types that have branding information configured will be shown in the response.
     * </p>
     * </note>
     *
     * @param describeClientBrandingRequest
     * @return Result of the DescribeClientBranding operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeClientBranding
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeClientBranding"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeClientBrandingResponse describeClientBranding(DescribeClientBrandingRequest describeClientBrandingRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeClientBrandingResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeClientBrandingResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeClientBrandingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeClientBranding");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeClientBrandingRequest, DescribeClientBrandingResponse>()
                            .withOperationName("DescribeClientBranding").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeClientBrandingRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeClientBrandingRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list that describes one or more specified Amazon WorkSpaces clients.
     * </p>
     *
     * @param describeClientPropertiesRequest
     * @return Result of the DescribeClientProperties operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeClientProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeClientProperties"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeClientPropertiesResponse describeClientProperties(
            DescribeClientPropertiesRequest describeClientPropertiesRequest) throws InvalidParameterValuesException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeClientPropertiesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeClientPropertiesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeClientPropertiesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeClientProperties");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeClientPropertiesRequest, DescribeClientPropertiesResponse>()
                            .withOperationName("DescribeClientProperties").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeClientPropertiesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeClientPropertiesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of Amazon Connect client add-ins that have been created.
     * </p>
     *
     * @param describeConnectClientAddInsRequest
     * @return Result of the DescribeConnectClientAddIns operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeConnectClientAddIns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeConnectClientAddIns"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeConnectClientAddInsResponse describeConnectClientAddIns(
            DescribeConnectClientAddInsRequest describeConnectClientAddInsRequest) throws InvalidParameterValuesException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeConnectClientAddInsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeConnectClientAddInsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeConnectClientAddInsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeConnectClientAddIns");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeConnectClientAddInsRequest, DescribeConnectClientAddInsResponse>()
                            .withOperationName("DescribeConnectClientAddIns").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeConnectClientAddInsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeConnectClientAddInsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the permissions that the owner of a connection alias has granted to another Amazon Web Services account
     * for the specified connection alias. For more information, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html"> Cross-Region
     * Redirection for Amazon WorkSpaces</a>.
     * </p>
     *
     * @param describeConnectionAliasPermissionsRequest
     * @return Result of the DescribeConnectionAliasPermissions operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeConnectionAliasPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeConnectionAliasPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeConnectionAliasPermissionsResponse describeConnectionAliasPermissions(
            DescribeConnectionAliasPermissionsRequest describeConnectionAliasPermissionsRequest) throws AccessDeniedException,
            InvalidParameterValuesException, ResourceNotFoundException, OperationNotSupportedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeConnectionAliasPermissionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeConnectionAliasPermissionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeConnectionAliasPermissionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeConnectionAliasPermissions");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeConnectionAliasPermissionsRequest, DescribeConnectionAliasPermissionsResponse>()
                            .withOperationName("DescribeConnectionAliasPermissions").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeConnectionAliasPermissionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeConnectionAliasPermissionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list that describes the connection aliases used for cross-Region redirection. For more information,
     * see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html">
     * Cross-Region Redirection for Amazon WorkSpaces</a>.
     * </p>
     *
     * @param describeConnectionAliasesRequest
     * @return Result of the DescribeConnectionAliases operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeConnectionAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeConnectionAliases"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeConnectionAliasesResponse describeConnectionAliases(
            DescribeConnectionAliasesRequest describeConnectionAliasesRequest) throws AccessDeniedException,
            InvalidParameterValuesException, OperationNotSupportedException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeConnectionAliasesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeConnectionAliasesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeConnectionAliasesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeConnectionAliases");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeConnectionAliasesRequest, DescribeConnectionAliasesResponse>()
                            .withOperationName("DescribeConnectionAliases").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeConnectionAliasesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeConnectionAliasesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes one or more of your IP access control groups.
     * </p>
     *
     * @param describeIpGroupsRequest
     * @return Result of the DescribeIpGroups operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeIpGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeIpGroups" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeIpGroupsResponse describeIpGroups(DescribeIpGroupsRequest describeIpGroupsRequest)
            throws InvalidParameterValuesException, AccessDeniedException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeIpGroupsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeIpGroupsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeIpGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeIpGroups");

            return clientHandler.execute(new ClientExecutionParams<DescribeIpGroupsRequest, DescribeIpGroupsResponse>()
                    .withOperationName("DescribeIpGroups").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeIpGroupsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeIpGroupsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the specified tags for the specified WorkSpaces resource.
     * </p>
     *
     * @param describeTagsRequest
     * @return Result of the DescribeTags operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeTags" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeTagsResponse describeTags(DescribeTagsRequest describeTagsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeTagsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeTagsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeTagsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTags");

            return clientHandler.execute(new ClientExecutionParams<DescribeTagsRequest, DescribeTagsResponse>()
                    .withOperationName("DescribeTags").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeTagsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeTagsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list that describes the available WorkSpace bundles.
     * </p>
     * <p>
     * You can filter the results using either bundle ID or owner, but not both.
     * </p>
     *
     * @param describeWorkspaceBundlesRequest
     * @return Result of the DescribeWorkspaceBundles operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspaceBundles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceBundles"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeWorkspaceBundlesResponse describeWorkspaceBundles(
            DescribeWorkspaceBundlesRequest describeWorkspaceBundlesRequest) throws InvalidParameterValuesException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeWorkspaceBundlesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeWorkspaceBundlesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeWorkspaceBundlesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeWorkspaceBundles");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeWorkspaceBundlesRequest, DescribeWorkspaceBundlesResponse>()
                            .withOperationName("DescribeWorkspaceBundles").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeWorkspaceBundlesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeWorkspaceBundlesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list that describes the available WorkSpace bundles.
     * </p>
     * <p>
     * You can filter the results using either bundle ID or owner, but not both.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeWorkspaceBundles(software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspaceBundlesIterable responses = client.describeWorkspaceBundlesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspaceBundlesIterable responses = client
     *             .describeWorkspaceBundlesPaginator(request);
     *     for (software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspaceBundlesIterable responses = client.describeWorkspaceBundlesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeWorkspaceBundles(software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeWorkspaceBundlesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspaceBundles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceBundles"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeWorkspaceBundlesIterable describeWorkspaceBundlesPaginator(
            DescribeWorkspaceBundlesRequest describeWorkspaceBundlesRequest) throws InvalidParameterValuesException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        return new DescribeWorkspaceBundlesIterable(this, applyPaginatorUserAgent(describeWorkspaceBundlesRequest));
    }

    /**
     * <p>
     * Describes the available directories that are registered with Amazon WorkSpaces.
     * </p>
     *
     * @param describeWorkspaceDirectoriesRequest
     * @return Result of the DescribeWorkspaceDirectories operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspaceDirectories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceDirectories"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeWorkspaceDirectoriesResponse describeWorkspaceDirectories(
            DescribeWorkspaceDirectoriesRequest describeWorkspaceDirectoriesRequest) throws InvalidParameterValuesException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeWorkspaceDirectoriesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeWorkspaceDirectoriesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeWorkspaceDirectoriesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeWorkspaceDirectories");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeWorkspaceDirectoriesRequest, DescribeWorkspaceDirectoriesResponse>()
                            .withOperationName("DescribeWorkspaceDirectories").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeWorkspaceDirectoriesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeWorkspaceDirectoriesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the available directories that are registered with Amazon WorkSpaces.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeWorkspaceDirectories(software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspaceDirectoriesIterable responses = client.describeWorkspaceDirectoriesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspaceDirectoriesIterable responses = client
     *             .describeWorkspaceDirectoriesPaginator(request);
     *     for (software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspaceDirectoriesIterable responses = client.describeWorkspaceDirectoriesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeWorkspaceDirectories(software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeWorkspaceDirectoriesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspaceDirectories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceDirectories"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeWorkspaceDirectoriesIterable describeWorkspaceDirectoriesPaginator(
            DescribeWorkspaceDirectoriesRequest describeWorkspaceDirectoriesRequest) throws InvalidParameterValuesException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        return new DescribeWorkspaceDirectoriesIterable(this, applyPaginatorUserAgent(describeWorkspaceDirectoriesRequest));
    }

    /**
     * <p>
     * Describes the permissions that the owner of an image has granted to other Amazon Web Services accounts for an
     * image.
     * </p>
     *
     * @param describeWorkspaceImagePermissionsRequest
     * @return Result of the DescribeWorkspaceImagePermissions operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspaceImagePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceImagePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeWorkspaceImagePermissionsResponse describeWorkspaceImagePermissions(
            DescribeWorkspaceImagePermissionsRequest describeWorkspaceImagePermissionsRequest) throws ResourceNotFoundException,
            AccessDeniedException, InvalidParameterValuesException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeWorkspaceImagePermissionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeWorkspaceImagePermissionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeWorkspaceImagePermissionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeWorkspaceImagePermissions");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeWorkspaceImagePermissionsRequest, DescribeWorkspaceImagePermissionsResponse>()
                            .withOperationName("DescribeWorkspaceImagePermissions").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeWorkspaceImagePermissionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeWorkspaceImagePermissionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list that describes one or more specified images, if the image identifiers are provided. Otherwise,
     * all images in the account are described.
     * </p>
     *
     * @param describeWorkspaceImagesRequest
     * @return Result of the DescribeWorkspaceImages operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspaceImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceImages"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeWorkspaceImagesResponse describeWorkspaceImages(DescribeWorkspaceImagesRequest describeWorkspaceImagesRequest)
            throws AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeWorkspaceImagesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeWorkspaceImagesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeWorkspaceImagesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeWorkspaceImages");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeWorkspaceImagesRequest, DescribeWorkspaceImagesResponse>()
                            .withOperationName("DescribeWorkspaceImages").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeWorkspaceImagesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeWorkspaceImagesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the snapshots for the specified WorkSpace.
     * </p>
     *
     * @param describeWorkspaceSnapshotsRequest
     * @return Result of the DescribeWorkspaceSnapshots operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspaceSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeWorkspaceSnapshotsResponse describeWorkspaceSnapshots(
            DescribeWorkspaceSnapshotsRequest describeWorkspaceSnapshotsRequest) throws InvalidParameterValuesException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeWorkspaceSnapshotsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeWorkspaceSnapshotsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeWorkspaceSnapshotsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeWorkspaceSnapshots");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeWorkspaceSnapshotsRequest, DescribeWorkspaceSnapshotsResponse>()
                            .withOperationName("DescribeWorkspaceSnapshots").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeWorkspaceSnapshotsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeWorkspaceSnapshotsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the specified WorkSpaces.
     * </p>
     * <p>
     * You can filter the results by using the bundle identifier, directory identifier, or owner, but you can specify
     * only one filter at a time.
     * </p>
     *
     * @param describeWorkspacesRequest
     * @return Result of the DescribeWorkspaces operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceUnavailableException
     *         The specified resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaces" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeWorkspacesResponse describeWorkspaces(DescribeWorkspacesRequest describeWorkspacesRequest)
            throws InvalidParameterValuesException, ResourceUnavailableException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeWorkspacesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeWorkspacesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeWorkspacesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeWorkspaces");

            return clientHandler.execute(new ClientExecutionParams<DescribeWorkspacesRequest, DescribeWorkspacesResponse>()
                    .withOperationName("DescribeWorkspaces").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeWorkspacesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeWorkspacesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the specified WorkSpaces.
     * </p>
     * <p>
     * You can filter the results by using the bundle identifier, directory identifier, or owner, but you can specify
     * only one filter at a time.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeWorkspaces(software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspacesIterable responses = client.describeWorkspacesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspacesIterable responses = client
     *             .describeWorkspacesPaginator(request);
     *     for (software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspaces.paginators.DescribeWorkspacesIterable responses = client.describeWorkspacesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeWorkspaces(software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeWorkspacesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceUnavailableException
     *         The specified resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaces" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeWorkspacesIterable describeWorkspacesPaginator(DescribeWorkspacesRequest describeWorkspacesRequest)
            throws InvalidParameterValuesException, ResourceUnavailableException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        return new DescribeWorkspacesIterable(this, applyPaginatorUserAgent(describeWorkspacesRequest));
    }

    /**
     * <p>
     * Describes the connection status of the specified WorkSpaces.
     * </p>
     *
     * @param describeWorkspacesConnectionStatusRequest
     * @return Result of the DescribeWorkspacesConnectionStatus operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspacesConnectionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspacesConnectionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeWorkspacesConnectionStatusResponse describeWorkspacesConnectionStatus(
            DescribeWorkspacesConnectionStatusRequest describeWorkspacesConnectionStatusRequest)
            throws InvalidParameterValuesException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeWorkspacesConnectionStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeWorkspacesConnectionStatusResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeWorkspacesConnectionStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeWorkspacesConnectionStatus");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeWorkspacesConnectionStatusRequest, DescribeWorkspacesConnectionStatusResponse>()
                            .withOperationName("DescribeWorkspacesConnectionStatus").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeWorkspacesConnectionStatusRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeWorkspacesConnectionStatusRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disassociates a connection alias from a directory. Disassociating a connection alias disables cross-Region
     * redirection between two directories in different Regions. For more information, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html"> Cross-Region
     * Redirection for Amazon WorkSpaces</a>.
     * </p>
     * <note>
     * <p>
     * Before performing this operation, call <a
     * href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeConnectionAliases.html">
     * DescribeConnectionAliases</a> to make sure that the current state of the connection alias is <code>CREATED</code>
     * .
     * </p>
     * </note>
     *
     * @param disassociateConnectionAliasRequest
     * @return Result of the DisassociateConnectionAlias operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DisassociateConnectionAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DisassociateConnectionAlias"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociateConnectionAliasResponse disassociateConnectionAlias(
            DisassociateConnectionAliasRequest disassociateConnectionAliasRequest) throws AccessDeniedException,
            ResourceNotFoundException, InvalidParameterValuesException, InvalidResourceStateException,
            OperationNotSupportedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateConnectionAliasResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DisassociateConnectionAliasResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disassociateConnectionAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateConnectionAlias");

            return clientHandler
                    .execute(new ClientExecutionParams<DisassociateConnectionAliasRequest, DisassociateConnectionAliasResponse>()
                            .withOperationName("DisassociateConnectionAlias").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(disassociateConnectionAliasRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DisassociateConnectionAliasRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disassociates the specified IP access control group from the specified directory.
     * </p>
     *
     * @param disassociateIpGroupsRequest
     * @return Result of the DisassociateIpGroups operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DisassociateIpGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DisassociateIpGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociateIpGroupsResponse disassociateIpGroups(DisassociateIpGroupsRequest disassociateIpGroupsRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, InvalidResourceStateException,
            AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateIpGroupsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DisassociateIpGroupsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disassociateIpGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateIpGroups");

            return clientHandler.execute(new ClientExecutionParams<DisassociateIpGroupsRequest, DisassociateIpGroupsResponse>()
                    .withOperationName("DisassociateIpGroups").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(disassociateIpGroupsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DisassociateIpGroupsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Imports client branding. Client branding allows you to customize your WorkSpace's client login portal. You can
     * tailor your login portal company logo, the support email address, support link, link to reset password, and a
     * custom message for users trying to sign in.
     * </p>
     * <p>
     * After you import client branding, the default branding experience for the specified platform type is replaced
     * with the imported experience
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * You must specify at least one platform type when importing client branding.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can import up to 6 MB of data with each request. If your request exceeds this limit, you can import client
     * branding for different platform types using separate requests.
     * </p>
     * </li>
     * <li>
     * <p>
     * In each platform type, the <code>SupportEmail</code> and <code>SupportLink</code> parameters are mutually
     * exclusive. You can specify only one parameter for each platform type, but not both.
     * </p>
     * </li>
     * <li>
     * <p>
     * Imported data can take up to a minute to appear in the WorkSpaces client.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param importClientBrandingRequest
     * @return Result of the ImportClientBranding operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ImportClientBranding
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ImportClientBranding"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ImportClientBrandingResponse importClientBranding(ImportClientBrandingRequest importClientBrandingRequest)
            throws InvalidParameterValuesException, ResourceLimitExceededException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ImportClientBrandingResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ImportClientBrandingResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, importClientBrandingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ImportClientBranding");

            return clientHandler.execute(new ClientExecutionParams<ImportClientBrandingRequest, ImportClientBrandingResponse>()
                    .withOperationName("ImportClientBranding").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(importClientBrandingRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ImportClientBrandingRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Imports the specified Windows 10 or 11 Bring Your Own License (BYOL) image into Amazon WorkSpaces. The image must
     * be an already licensed Amazon EC2 image that is in your Amazon Web Services account, and you must own the image.
     * For more information about creating BYOL images, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html"> Bring Your Own Windows
     * Desktop Licenses</a>.
     * </p>
     *
     * @param importWorkspaceImageRequest
     * @return Result of the ImportWorkspaceImage operation returned by the service.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ImportWorkspaceImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ImportWorkspaceImage"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ImportWorkspaceImageResponse importWorkspaceImage(ImportWorkspaceImageRequest importWorkspaceImageRequest)
            throws ResourceLimitExceededException, ResourceAlreadyExistsException, ResourceNotFoundException,
            OperationNotSupportedException, AccessDeniedException, InvalidParameterValuesException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ImportWorkspaceImageResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ImportWorkspaceImageResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, importWorkspaceImageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ImportWorkspaceImage");

            return clientHandler.execute(new ClientExecutionParams<ImportWorkspaceImageRequest, ImportWorkspaceImageResponse>()
                    .withOperationName("ImportWorkspaceImage").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(importWorkspaceImageRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ImportWorkspaceImageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of IP address ranges, specified as IPv4 CIDR blocks, that you can use for the network management
     * interface when you enable Bring Your Own License (BYOL).
     * </p>
     * <p>
     * This operation can be run only by Amazon Web Services accounts that are enabled for BYOL. If your account isn't
     * enabled for BYOL, you'll receive an <code>AccessDeniedException</code> error.
     * </p>
     * <p>
     * The management network interface is connected to a secure Amazon WorkSpaces management network. It is used for
     * interactive streaming of the WorkSpace desktop to Amazon WorkSpaces clients, and to allow Amazon WorkSpaces to
     * manage the WorkSpace.
     * </p>
     *
     * @param listAvailableManagementCidrRangesRequest
     * @return Result of the ListAvailableManagementCidrRanges operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ListAvailableManagementCidrRanges
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ListAvailableManagementCidrRanges"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAvailableManagementCidrRangesResponse listAvailableManagementCidrRanges(
            ListAvailableManagementCidrRangesRequest listAvailableManagementCidrRangesRequest)
            throws InvalidParameterValuesException, AccessDeniedException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAvailableManagementCidrRangesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListAvailableManagementCidrRangesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listAvailableManagementCidrRangesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAvailableManagementCidrRanges");

            return clientHandler
                    .execute(new ClientExecutionParams<ListAvailableManagementCidrRangesRequest, ListAvailableManagementCidrRangesResponse>()
                            .withOperationName("ListAvailableManagementCidrRanges").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listAvailableManagementCidrRangesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListAvailableManagementCidrRangesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Migrates a WorkSpace from one operating system or bundle type to another, while retaining the data on the user
     * volume.
     * </p>
     * <p>
     * The migration process recreates the WorkSpace by using a new root volume from the target bundle image and the
     * user volume from the last available snapshot of the original WorkSpace. During migration, the original
     * <code>D:\Users\%USERNAME%</code> user profile folder is renamed to
     * <code>D:\Users\%USERNAME%MMddyyTHHmmss%.NotMigrated</code>. A new <code>D:\Users\%USERNAME%\</code> folder is
     * generated by the new OS. Certain files in the old user profile are moved to the new user profile.
     * </p>
     * <p>
     * For available migration scenarios, details about what happens during migration, and best practices, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/migrate-workspaces.html">Migrate a WorkSpace</a>.
     * </p>
     *
     * @param migrateWorkspaceRequest
     * @return Result of the MigrateWorkspace operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws OperationInProgressException
     *         The properties of this WorkSpace are currently being modified. Try again in a moment.
     * @throws ResourceUnavailableException
     *         The specified resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.MigrateWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/MigrateWorkspace" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public MigrateWorkspaceResponse migrateWorkspace(MigrateWorkspaceRequest migrateWorkspaceRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, AccessDeniedException,
            OperationNotSupportedException, OperationInProgressException, ResourceUnavailableException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<MigrateWorkspaceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                MigrateWorkspaceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, migrateWorkspaceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "MigrateWorkspace");

            return clientHandler.execute(new ClientExecutionParams<MigrateWorkspaceRequest, MigrateWorkspaceResponse>()
                    .withOperationName("MigrateWorkspace").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(migrateWorkspaceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new MigrateWorkspaceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies the configuration of Bring Your Own License (BYOL) for the specified account.
     * </p>
     *
     * @param modifyAccountRequest
     * @return Result of the ModifyAccount operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws ResourceUnavailableException
     *         The specified resource is not available.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ModifyAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyAccount" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ModifyAccountResponse modifyAccount(ModifyAccountRequest modifyAccountRequest) throws InvalidParameterValuesException,
            AccessDeniedException, InvalidResourceStateException, ResourceUnavailableException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ModifyAccountResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ModifyAccountResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyAccountRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyAccount");

            return clientHandler.execute(new ClientExecutionParams<ModifyAccountRequest, ModifyAccountResponse>()
                    .withOperationName("ModifyAccount").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(modifyAccountRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ModifyAccountRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies the properties of the certificate-based authentication you want to use with your WorkSpaces.
     * </p>
     *
     * @param modifyCertificateBasedAuthPropertiesRequest
     * @return Result of the ModifyCertificateBasedAuthProperties operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ModifyCertificateBasedAuthProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyCertificateBasedAuthProperties"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ModifyCertificateBasedAuthPropertiesResponse modifyCertificateBasedAuthProperties(
            ModifyCertificateBasedAuthPropertiesRequest modifyCertificateBasedAuthPropertiesRequest)
            throws AccessDeniedException, InvalidParameterValuesException, OperationNotSupportedException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ModifyCertificateBasedAuthPropertiesResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, ModifyCertificateBasedAuthPropertiesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                modifyCertificateBasedAuthPropertiesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyCertificateBasedAuthProperties");

            return clientHandler
                    .execute(new ClientExecutionParams<ModifyCertificateBasedAuthPropertiesRequest, ModifyCertificateBasedAuthPropertiesResponse>()
                            .withOperationName("ModifyCertificateBasedAuthProperties").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(modifyCertificateBasedAuthPropertiesRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ModifyCertificateBasedAuthPropertiesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies the properties of the specified Amazon WorkSpaces clients.
     * </p>
     *
     * @param modifyClientPropertiesRequest
     * @return Result of the ModifyClientProperties operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ModifyClientProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyClientProperties"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ModifyClientPropertiesResponse modifyClientProperties(ModifyClientPropertiesRequest modifyClientPropertiesRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ModifyClientPropertiesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ModifyClientPropertiesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyClientPropertiesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyClientProperties");

            return clientHandler
                    .execute(new ClientExecutionParams<ModifyClientPropertiesRequest, ModifyClientPropertiesResponse>()
                            .withOperationName("ModifyClientProperties").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(modifyClientPropertiesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ModifyClientPropertiesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies multiple properties related to SAML 2.0 authentication, including the enablement status, user access
     * URL, and relay state parameter name that are used for configuring federation with an SAML 2.0 identity provider.
     * </p>
     *
     * @param modifySamlPropertiesRequest
     * @return Result of the ModifySamlProperties operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ModifySamlProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifySamlProperties"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ModifySamlPropertiesResponse modifySamlProperties(ModifySamlPropertiesRequest modifySamlPropertiesRequest)
            throws AccessDeniedException, InvalidParameterValuesException, OperationNotSupportedException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ModifySamlPropertiesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ModifySamlPropertiesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifySamlPropertiesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifySamlProperties");

            return clientHandler.execute(new ClientExecutionParams<ModifySamlPropertiesRequest, ModifySamlPropertiesResponse>()
                    .withOperationName("ModifySamlProperties").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(modifySamlPropertiesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ModifySamlPropertiesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies the self-service WorkSpace management capabilities for your users. For more information, see <a href=
     * "https://docs.aws.amazon.com/workspaces/latest/adminguide/enable-user-self-service-workspace-management.html"
     * >Enable Self-Service WorkSpace Management Capabilities for Your Users</a>.
     * </p>
     *
     * @param modifySelfservicePermissionsRequest
     * @return Result of the ModifySelfservicePermissions operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ModifySelfservicePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifySelfservicePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ModifySelfservicePermissionsResponse modifySelfservicePermissions(
            ModifySelfservicePermissionsRequest modifySelfservicePermissionsRequest) throws AccessDeniedException,
            InvalidParameterValuesException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ModifySelfservicePermissionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ModifySelfservicePermissionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifySelfservicePermissionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifySelfservicePermissions");

            return clientHandler
                    .execute(new ClientExecutionParams<ModifySelfservicePermissionsRequest, ModifySelfservicePermissionsResponse>()
                            .withOperationName("ModifySelfservicePermissions").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(modifySelfservicePermissionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ModifySelfservicePermissionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Specifies which devices and operating systems users can use to access their WorkSpaces. For more information, see
     * <a href=
     * "https://docs.aws.amazon.com/workspaces/latest/adminguide/update-directory-details.html#control-device-access">
     * Control Device Access</a>.
     * </p>
     *
     * @param modifyWorkspaceAccessPropertiesRequest
     * @return Result of the ModifyWorkspaceAccessProperties operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ModifyWorkspaceAccessProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyWorkspaceAccessProperties"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ModifyWorkspaceAccessPropertiesResponse modifyWorkspaceAccessProperties(
            ModifyWorkspaceAccessPropertiesRequest modifyWorkspaceAccessPropertiesRequest) throws ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ModifyWorkspaceAccessPropertiesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ModifyWorkspaceAccessPropertiesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                modifyWorkspaceAccessPropertiesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyWorkspaceAccessProperties");

            return clientHandler
                    .execute(new ClientExecutionParams<ModifyWorkspaceAccessPropertiesRequest, ModifyWorkspaceAccessPropertiesResponse>()
                            .withOperationName("ModifyWorkspaceAccessProperties").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(modifyWorkspaceAccessPropertiesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ModifyWorkspaceAccessPropertiesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modify the default properties used to create WorkSpaces.
     * </p>
     *
     * @param modifyWorkspaceCreationPropertiesRequest
     * @return Result of the ModifyWorkspaceCreationProperties operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ModifyWorkspaceCreationProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyWorkspaceCreationProperties"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ModifyWorkspaceCreationPropertiesResponse modifyWorkspaceCreationProperties(
            ModifyWorkspaceCreationPropertiesRequest modifyWorkspaceCreationPropertiesRequest) throws AccessDeniedException,
            InvalidParameterValuesException, ResourceNotFoundException, OperationNotSupportedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ModifyWorkspaceCreationPropertiesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ModifyWorkspaceCreationPropertiesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                modifyWorkspaceCreationPropertiesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyWorkspaceCreationProperties");

            return clientHandler
                    .execute(new ClientExecutionParams<ModifyWorkspaceCreationPropertiesRequest, ModifyWorkspaceCreationPropertiesResponse>()
                            .withOperationName("ModifyWorkspaceCreationProperties").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(modifyWorkspaceCreationPropertiesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ModifyWorkspaceCreationPropertiesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies the specified WorkSpace properties. For important information about how to modify the size of the root
     * and user volumes, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/modify-workspaces.html">
     * Modify a WorkSpace</a>.
     * </p>
     * <note>
     * <p>
     * The <code>MANUAL</code> running mode value is only supported by Amazon WorkSpaces Core. Contact your account team
     * to be allow-listed to use this value. For more information, see <a
     * href="http://aws.amazon.com/workspaces/core/">Amazon WorkSpaces Core</a>.
     * </p>
     * </note>
     *
     * @param modifyWorkspacePropertiesRequest
     * @return Result of the ModifyWorkspaceProperties operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws OperationInProgressException
     *         The properties of this WorkSpace are currently being modified. Try again in a moment.
     * @throws UnsupportedWorkspaceConfigurationException
     *         The configuration of this WorkSpace is not supported for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/workspaces/latest/adminguide/required-service-components.html">Required
     *         Configuration and Service Components for WorkSpaces </a>.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws ResourceUnavailableException
     *         The specified resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ModifyWorkspaceProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyWorkspaceProperties"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ModifyWorkspacePropertiesResponse modifyWorkspaceProperties(
            ModifyWorkspacePropertiesRequest modifyWorkspacePropertiesRequest) throws InvalidParameterValuesException,
            InvalidResourceStateException, OperationInProgressException, UnsupportedWorkspaceConfigurationException,
            ResourceNotFoundException, AccessDeniedException, ResourceUnavailableException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ModifyWorkspacePropertiesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ModifyWorkspacePropertiesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyWorkspacePropertiesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyWorkspaceProperties");

            return clientHandler
                    .execute(new ClientExecutionParams<ModifyWorkspacePropertiesRequest, ModifyWorkspacePropertiesResponse>()
                            .withOperationName("ModifyWorkspaceProperties").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(modifyWorkspacePropertiesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ModifyWorkspacePropertiesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Sets the state of the specified WorkSpace.
     * </p>
     * <p>
     * To maintain a WorkSpace without being interrupted, set the WorkSpace state to <code>ADMIN_MAINTENANCE</code>.
     * WorkSpaces in this state do not respond to requests to reboot, stop, start, rebuild, or restore. An AutoStop
     * WorkSpace in this state is not stopped. Users cannot log into a WorkSpace in the <code>ADMIN_MAINTENANCE</code>
     * state.
     * </p>
     *
     * @param modifyWorkspaceStateRequest
     * @return Result of the ModifyWorkspaceState operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ModifyWorkspaceState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyWorkspaceState"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ModifyWorkspaceStateResponse modifyWorkspaceState(ModifyWorkspaceStateRequest modifyWorkspaceStateRequest)
            throws InvalidParameterValuesException, InvalidResourceStateException, ResourceNotFoundException,
            OperationNotSupportedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ModifyWorkspaceStateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ModifyWorkspaceStateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyWorkspaceStateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyWorkspaceState");

            return clientHandler.execute(new ClientExecutionParams<ModifyWorkspaceStateRequest, ModifyWorkspaceStateResponse>()
                    .withOperationName("ModifyWorkspaceState").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(modifyWorkspaceStateRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ModifyWorkspaceStateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Reboots the specified WorkSpaces.
     * </p>
     * <p>
     * You cannot reboot a WorkSpace unless its state is <code>AVAILABLE</code> or <code>UNHEALTHY</code>.
     * </p>
     * <p>
     * This operation is asynchronous and returns before the WorkSpaces have rebooted.
     * </p>
     *
     * @param rebootWorkspacesRequest
     * @return Result of the RebootWorkspaces operation returned by the service.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.RebootWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RebootWorkspaces" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public RebootWorkspacesResponse rebootWorkspaces(RebootWorkspacesRequest rebootWorkspacesRequest)
            throws OperationNotSupportedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RebootWorkspacesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                RebootWorkspacesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, rebootWorkspacesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RebootWorkspaces");

            return clientHandler.execute(new ClientExecutionParams<RebootWorkspacesRequest, RebootWorkspacesResponse>()
                    .withOperationName("RebootWorkspaces").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(rebootWorkspacesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new RebootWorkspacesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Rebuilds the specified WorkSpace.
     * </p>
     * <p>
     * You cannot rebuild a WorkSpace unless its state is <code>AVAILABLE</code>, <code>ERROR</code>,
     * <code>UNHEALTHY</code>, <code>STOPPED</code>, or <code>REBOOTING</code>.
     * </p>
     * <p>
     * Rebuilding a WorkSpace is a potentially destructive action that can result in the loss of data. For more
     * information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/reset-workspace.html">Rebuild
     * a WorkSpace</a>.
     * </p>
     * <p>
     * This operation is asynchronous and returns before the WorkSpaces have been completely rebuilt.
     * </p>
     *
     * @param rebuildWorkspacesRequest
     * @return Result of the RebuildWorkspaces operation returned by the service.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.RebuildWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RebuildWorkspaces" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public RebuildWorkspacesResponse rebuildWorkspaces(RebuildWorkspacesRequest rebuildWorkspacesRequest)
            throws OperationNotSupportedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RebuildWorkspacesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                RebuildWorkspacesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, rebuildWorkspacesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RebuildWorkspaces");

            return clientHandler.execute(new ClientExecutionParams<RebuildWorkspacesRequest, RebuildWorkspacesResponse>()
                    .withOperationName("RebuildWorkspaces").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(rebuildWorkspacesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new RebuildWorkspacesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Registers the specified directory. This operation is asynchronous and returns before the WorkSpace directory is
     * registered. If this is the first time you are registering a directory, you will need to create the
     * workspaces_DefaultRole role before you can register a directory. For more information, see <a href=
     * "https://docs.aws.amazon.com/workspaces/latest/adminguide/workspaces-access-control.html#create-default-role">
     * Creating the workspaces_DefaultRole Role</a>.
     * </p>
     *
     * @param registerWorkspaceDirectoryRequest
     * @return Result of the RegisterWorkspaceDirectory operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws WorkspacesDefaultRoleNotFoundException
     *         The workspaces_DefaultRole role could not be found. If this is the first time you are registering a
     *         directory, you will need to create the workspaces_DefaultRole role before you can register a directory.
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/workspaces/latest/adminguide/workspaces-access-control.html#create-default-role"
     *         >Creating the workspaces_DefaultRole Role</a>.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws UnsupportedNetworkConfigurationException
     *         The configuration of this network is not supported for this operation, or your network configuration
     *         conflicts with the Amazon WorkSpaces management network IP range. For more information, see <a
     *         href="https://docs.aws.amazon.com/workspaces/latest/adminguide/amazon-workspaces-vpc.html"> Configure a
     *         VPC for Amazon WorkSpaces</a>.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.RegisterWorkspaceDirectory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RegisterWorkspaceDirectory"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RegisterWorkspaceDirectoryResponse registerWorkspaceDirectory(
            RegisterWorkspaceDirectoryRequest registerWorkspaceDirectoryRequest) throws InvalidParameterValuesException,
            ResourceNotFoundException, ResourceLimitExceededException, AccessDeniedException,
            WorkspacesDefaultRoleNotFoundException, InvalidResourceStateException, UnsupportedNetworkConfigurationException,
            OperationNotSupportedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RegisterWorkspaceDirectoryResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, RegisterWorkspaceDirectoryResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, registerWorkspaceDirectoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RegisterWorkspaceDirectory");

            return clientHandler
                    .execute(new ClientExecutionParams<RegisterWorkspaceDirectoryRequest, RegisterWorkspaceDirectoryResponse>()
                            .withOperationName("RegisterWorkspaceDirectory").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(registerWorkspaceDirectoryRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new RegisterWorkspaceDirectoryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Restores the specified WorkSpace to its last known healthy state.
     * </p>
     * <p>
     * You cannot restore a WorkSpace unless its state is <code> AVAILABLE</code>, <code>ERROR</code>,
     * <code>UNHEALTHY</code>, or <code>STOPPED</code>.
     * </p>
     * <p>
     * Restoring a WorkSpace is a potentially destructive action that can result in the loss of data. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/restore-workspace.html">Restore a WorkSpace</a>.
     * </p>
     * <p>
     * This operation is asynchronous and returns before the WorkSpace is completely restored.
     * </p>
     *
     * @param restoreWorkspaceRequest
     * @return Result of the RestoreWorkspace operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.RestoreWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RestoreWorkspace" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public RestoreWorkspaceResponse restoreWorkspace(RestoreWorkspaceRequest restoreWorkspaceRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, AccessDeniedException,
            OperationNotSupportedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RestoreWorkspaceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                RestoreWorkspaceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, restoreWorkspaceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RestoreWorkspace");

            return clientHandler.execute(new ClientExecutionParams<RestoreWorkspaceRequest, RestoreWorkspaceResponse>()
                    .withOperationName("RestoreWorkspace").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(restoreWorkspaceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new RestoreWorkspaceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes one or more rules from the specified IP access control group.
     * </p>
     *
     * @param revokeIpRulesRequest
     * @return Result of the RevokeIpRules operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.RevokeIpRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RevokeIpRules" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public RevokeIpRulesResponse revokeIpRules(RevokeIpRulesRequest revokeIpRulesRequest) throws InvalidParameterValuesException,
            ResourceNotFoundException, InvalidResourceStateException, AccessDeniedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RevokeIpRulesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                RevokeIpRulesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, revokeIpRulesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RevokeIpRules");

            return clientHandler.execute(new ClientExecutionParams<RevokeIpRulesRequest, RevokeIpRulesResponse>()
                    .withOperationName("RevokeIpRules").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(revokeIpRulesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new RevokeIpRulesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Starts the specified WorkSpaces.
     * </p>
     * <p>
     * You cannot start a WorkSpace unless it has a running mode of <code>AutoStop</code> and a state of
     * <code>STOPPED</code>.
     * </p>
     *
     * @param startWorkspacesRequest
     * @return Result of the StartWorkspaces operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.StartWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/StartWorkspaces" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public StartWorkspacesResponse startWorkspaces(StartWorkspacesRequest startWorkspacesRequest) throws AwsServiceException,
            SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartWorkspacesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                StartWorkspacesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startWorkspacesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartWorkspaces");

            return clientHandler.execute(new ClientExecutionParams<StartWorkspacesRequest, StartWorkspacesResponse>()
                    .withOperationName("StartWorkspaces").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(startWorkspacesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StartWorkspacesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Stops the specified WorkSpaces.
     * </p>
     * <p>
     * You cannot stop a WorkSpace unless it has a running mode of <code>AutoStop</code> and a state of
     * <code>AVAILABLE</code>, <code>IMPAIRED</code>, <code>UNHEALTHY</code>, or <code>ERROR</code>.
     * </p>
     *
     * @param stopWorkspacesRequest
     * @return Result of the StopWorkspaces operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.StopWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/StopWorkspaces" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public StopWorkspacesResponse stopWorkspaces(StopWorkspacesRequest stopWorkspacesRequest) throws AwsServiceException,
            SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StopWorkspacesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                StopWorkspacesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopWorkspacesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopWorkspaces");

            return clientHandler.execute(new ClientExecutionParams<StopWorkspacesRequest, StopWorkspacesResponse>()
                    .withOperationName("StopWorkspaces").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(stopWorkspacesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StopWorkspacesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Terminates the specified WorkSpaces.
     * </p>
     * <important>
     * <p>
     * Terminating a WorkSpace is a permanent action and cannot be undone. The user's data is destroyed. If you need to
     * archive any user data, contact Amazon Web Services Support before terminating the WorkSpace.
     * </p>
     * </important>
     * <p>
     * You can terminate a WorkSpace that is in any state except <code>SUSPENDED</code>.
     * </p>
     * <p>
     * This operation is asynchronous and returns before the WorkSpaces have been completely terminated. After a
     * WorkSpace is terminated, the <code>TERMINATED</code> state is returned only briefly before the WorkSpace
     * directory metadata is cleaned up, so this state is rarely returned. To confirm that a WorkSpace is terminated,
     * check for the WorkSpace ID by using <a
     * href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaces.html"> DescribeWorkSpaces</a>. If
     * the WorkSpace ID isn't returned, then the WorkSpace has been successfully terminated.
     * </p>
     * <note>
     * <p>
     * Simple AD and AD Connector are made available to you free of charge to use with WorkSpaces. If there are no
     * WorkSpaces being used with your Simple AD or AD Connector directory for 30 consecutive days, this directory will
     * be automatically deregistered for use with Amazon WorkSpaces, and you will be charged for this directory as per
     * the <a href="http://aws.amazon.com/directoryservice/pricing/">Directory Service pricing terms</a>.
     * </p>
     * <p>
     * To delete empty directories, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/delete-workspaces-directory.html"> Delete the
     * Directory for Your WorkSpaces</a>. If you delete your Simple AD or AD Connector directory, you can always create
     * a new one when you want to start using WorkSpaces again.
     * </p>
     * </note>
     *
     * @param terminateWorkspacesRequest
     * @return Result of the TerminateWorkspaces operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.TerminateWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/TerminateWorkspaces"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public TerminateWorkspacesResponse terminateWorkspaces(TerminateWorkspacesRequest terminateWorkspacesRequest)
            throws AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TerminateWorkspacesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, TerminateWorkspacesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, terminateWorkspacesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TerminateWorkspaces");

            return clientHandler.execute(new ClientExecutionParams<TerminateWorkspacesRequest, TerminateWorkspacesResponse>()
                    .withOperationName("TerminateWorkspaces").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(terminateWorkspacesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TerminateWorkspacesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a Amazon Connect client add-in. Use this action to update the name and endpoint URL of a Amazon Connect
     * client add-in.
     * </p>
     *
     * @param updateConnectClientAddInRequest
     * @return Result of the UpdateConnectClientAddIn operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.UpdateConnectClientAddIn
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/UpdateConnectClientAddIn"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateConnectClientAddInResponse updateConnectClientAddIn(
            UpdateConnectClientAddInRequest updateConnectClientAddInRequest) throws InvalidParameterValuesException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateConnectClientAddInResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateConnectClientAddInResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateConnectClientAddInRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateConnectClientAddIn");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateConnectClientAddInRequest, UpdateConnectClientAddInResponse>()
                            .withOperationName("UpdateConnectClientAddIn").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(updateConnectClientAddInRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateConnectClientAddInRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Shares or unshares a connection alias with one account by specifying whether that account has permission to
     * associate the connection alias with a directory. If the association permission is granted, the connection alias
     * is shared with that account. If the association permission is revoked, the connection alias is unshared with the
     * account. For more information, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html"> Cross-Region
     * Redirection for Amazon WorkSpaces</a>.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * Before performing this operation, call <a
     * href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeConnectionAliases.html">
     * DescribeConnectionAliases</a> to make sure that the current state of the connection alias is <code>CREATED</code>
     * .
     * </p>
     * </li>
     * <li>
     * <p>
     * To delete a connection alias that has been shared, the shared account must first disassociate the connection
     * alias from any directories it has been associated with. Then you must unshare the connection alias from the
     * account it has been shared with. You can delete a connection alias only after it is no longer shared with any
     * accounts or associated with any directories.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param updateConnectionAliasPermissionRequest
     * @return Result of the UpdateConnectionAliasPermission operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceAssociatedException
     *         The resource is associated with a directory.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.UpdateConnectionAliasPermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/UpdateConnectionAliasPermission"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateConnectionAliasPermissionResponse updateConnectionAliasPermission(
            UpdateConnectionAliasPermissionRequest updateConnectionAliasPermissionRequest) throws AccessDeniedException,
            InvalidParameterValuesException, ResourceLimitExceededException, ResourceNotFoundException,
            ResourceAssociatedException, InvalidResourceStateException, OperationNotSupportedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateConnectionAliasPermissionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateConnectionAliasPermissionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateConnectionAliasPermissionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateConnectionAliasPermission");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateConnectionAliasPermissionRequest, UpdateConnectionAliasPermissionResponse>()
                            .withOperationName("UpdateConnectionAliasPermission").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(updateConnectionAliasPermissionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateConnectionAliasPermissionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Replaces the current rules of the specified IP access control group with the specified rules.
     * </p>
     *
     * @param updateRulesOfIpGroupRequest
     * @return Result of the UpdateRulesOfIpGroup operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.UpdateRulesOfIpGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/UpdateRulesOfIpGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateRulesOfIpGroupResponse updateRulesOfIpGroup(UpdateRulesOfIpGroupRequest updateRulesOfIpGroupRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, ResourceLimitExceededException,
            InvalidResourceStateException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateRulesOfIpGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateRulesOfIpGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateRulesOfIpGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateRulesOfIpGroup");

            return clientHandler.execute(new ClientExecutionParams<UpdateRulesOfIpGroupRequest, UpdateRulesOfIpGroupResponse>()
                    .withOperationName("UpdateRulesOfIpGroup").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateRulesOfIpGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateRulesOfIpGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a WorkSpace bundle with a new image. For more information about updating WorkSpace bundles, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/update-custom-bundle.html"> Update a Custom
     * WorkSpaces Bundle</a>.
     * </p>
     * <important>
     * <p>
     * Existing WorkSpaces aren't automatically updated when you update the bundle that they're based on. To update
     * existing WorkSpaces that are based on a bundle that you've updated, you must either rebuild the WorkSpaces or
     * delete and recreate them.
     * </p>
     * </important>
     *
     * @param updateWorkspaceBundleRequest
     * @return Result of the UpdateWorkspaceBundle operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceUnavailableException
     *         The specified resource is not available.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.UpdateWorkspaceBundle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/UpdateWorkspaceBundle"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateWorkspaceBundleResponse updateWorkspaceBundle(UpdateWorkspaceBundleRequest updateWorkspaceBundleRequest)
            throws AccessDeniedException, InvalidParameterValuesException, ResourceNotFoundException,
            ResourceUnavailableException, OperationNotSupportedException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateWorkspaceBundleResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateWorkspaceBundleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateWorkspaceBundleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateWorkspaceBundle");

            return clientHandler.execute(new ClientExecutionParams<UpdateWorkspaceBundleRequest, UpdateWorkspaceBundleResponse>()
                    .withOperationName("UpdateWorkspaceBundle").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateWorkspaceBundleRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateWorkspaceBundleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Shares or unshares an image with one account in the same Amazon Web Services Region by specifying whether that
     * account has permission to copy the image. If the copy image permission is granted, the image is shared with that
     * account. If the copy image permission is revoked, the image is unshared with the account.
     * </p>
     * <p>
     * After an image has been shared, the recipient account can copy the image to other Regions as needed.
     * </p>
     * <p>
     * In the China (Ningxia) Region, you can copy images only within the same Region.
     * </p>
     * <p>
     * In Amazon Web Services GovCloud (US), to copy images to and from other Regions, contact Amazon Web Services
     * Support.
     * </p>
     * <p>
     * For more information about sharing images, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/share-custom-image.html"> Share or Unshare a
     * Custom WorkSpaces Image</a>.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * To delete an image that has been shared, you must unshare the image before you delete it.
     * </p>
     * </li>
     * <li>
     * <p>
     * Sharing Bring Your Own License (BYOL) images across Amazon Web Services accounts isn't supported at this time in
     * Amazon Web Services GovCloud (US). To share BYOL images across accounts in Amazon Web Services GovCloud (US),
     * contact Amazon Web Services Support.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param updateWorkspaceImagePermissionRequest
     * @return Result of the UpdateWorkspaceImagePermission operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceUnavailableException
     *         The specified resource is not available.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.UpdateWorkspaceImagePermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/UpdateWorkspaceImagePermission"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateWorkspaceImagePermissionResponse updateWorkspaceImagePermission(
            UpdateWorkspaceImagePermissionRequest updateWorkspaceImagePermissionRequest) throws ResourceNotFoundException,
            ResourceUnavailableException, AccessDeniedException, InvalidParameterValuesException, OperationNotSupportedException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateWorkspaceImagePermissionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateWorkspaceImagePermissionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateWorkspaceImagePermissionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateWorkspaceImagePermission");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateWorkspaceImagePermissionRequest, UpdateWorkspaceImagePermissionResponse>()
                            .withOperationName("UpdateWorkspaceImagePermission").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(updateWorkspaceImagePermissionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateWorkspaceImagePermissionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    private <T extends WorkSpacesRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder()
                .version(VersionInfo.SDK_VERSION).name("PAGINATED").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration()
                .map(c -> c.toBuilder().applyMutation(userAgentApplier).build())
                .orElse((AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build()));
        return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(WorkSpacesException::builder)
                .protocol(AwsJsonProtocol.AWS_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OperationNotSupportedException")
                                .exceptionBuilderSupplier(OperationNotSupportedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceAssociatedException")
                                .exceptionBuilderSupplier(ResourceAssociatedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidParameterValuesException")
                                .exceptionBuilderSupplier(InvalidParameterValuesException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OperationInProgressException")
                                .exceptionBuilderSupplier(OperationInProgressException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceUnavailableException")
                                .exceptionBuilderSupplier(ResourceUnavailableException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                                .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceCreationFailedException")
                                .exceptionBuilderSupplier(ResourceCreationFailedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                                .exceptionBuilderSupplier(ResourceLimitExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                                .exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                                .exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                                .exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidResourceStateException")
                                .exceptionBuilderSupplier(InvalidResourceStateException::builder).httpStatusCode(400).build());
    }

    @Override
    public final WorkSpacesServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
