/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the default properties that are used for creating WorkSpaces. For more information, see <a
 * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/update-directory-details.html">Update Directory
 * Details for Your WorkSpaces</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkspaceCreationProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<WorkspaceCreationProperties.Builder, WorkspaceCreationProperties> {
    private static final SdkField<Boolean> ENABLE_WORK_DOCS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableWorkDocs").getter(getter(WorkspaceCreationProperties::enableWorkDocs))
            .setter(setter(Builder::enableWorkDocs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableWorkDocs").build()).build();

    private static final SdkField<Boolean> ENABLE_INTERNET_ACCESS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableInternetAccess").getter(getter(WorkspaceCreationProperties::enableInternetAccess))
            .setter(setter(Builder::enableInternetAccess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableInternetAccess").build())
            .build();

    private static final SdkField<String> DEFAULT_OU_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultOu").getter(getter(WorkspaceCreationProperties::defaultOu)).setter(setter(Builder::defaultOu))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultOu").build()).build();

    private static final SdkField<String> CUSTOM_SECURITY_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomSecurityGroupId").getter(getter(WorkspaceCreationProperties::customSecurityGroupId))
            .setter(setter(Builder::customSecurityGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomSecurityGroupId").build())
            .build();

    private static final SdkField<Boolean> USER_ENABLED_AS_LOCAL_ADMINISTRATOR_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UserEnabledAsLocalAdministrator")
            .getter(getter(WorkspaceCreationProperties::userEnabledAsLocalAdministrator))
            .setter(setter(Builder::userEnabledAsLocalAdministrator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserEnabledAsLocalAdministrator")
                    .build()).build();

    private static final SdkField<Boolean> ENABLE_MAINTENANCE_MODE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableMaintenanceMode").getter(getter(WorkspaceCreationProperties::enableMaintenanceMode))
            .setter(setter(Builder::enableMaintenanceMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableMaintenanceMode").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLE_WORK_DOCS_FIELD,
            ENABLE_INTERNET_ACCESS_FIELD, DEFAULT_OU_FIELD, CUSTOM_SECURITY_GROUP_ID_FIELD,
            USER_ENABLED_AS_LOCAL_ADMINISTRATOR_FIELD, ENABLE_MAINTENANCE_MODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean enableWorkDocs;

    private final Boolean enableInternetAccess;

    private final String defaultOu;

    private final String customSecurityGroupId;

    private final Boolean userEnabledAsLocalAdministrator;

    private final Boolean enableMaintenanceMode;

    private WorkspaceCreationProperties(BuilderImpl builder) {
        this.enableWorkDocs = builder.enableWorkDocs;
        this.enableInternetAccess = builder.enableInternetAccess;
        this.defaultOu = builder.defaultOu;
        this.customSecurityGroupId = builder.customSecurityGroupId;
        this.userEnabledAsLocalAdministrator = builder.userEnabledAsLocalAdministrator;
        this.enableMaintenanceMode = builder.enableMaintenanceMode;
    }

    /**
     * <p>
     * Indicates whether Amazon WorkDocs is enabled for your WorkSpaces.
     * </p>
     * <note>
     * <p>
     * If WorkDocs is already enabled for a WorkSpaces directory and you disable it, new WorkSpaces launched in the
     * directory will not have WorkDocs enabled. However, WorkDocs remains enabled for any existing WorkSpaces, unless
     * you either disable users' access to WorkDocs or you delete the WorkDocs site. To disable users' access to
     * WorkDocs, see <a href="https://docs.aws.amazon.com/workdocs/latest/adminguide/inactive-user.html">Disabling
     * Users</a> in the <i>Amazon WorkDocs Administration Guide</i>. To delete a WorkDocs site, see <a
     * href="https://docs.aws.amazon.com/workdocs/latest/adminguide/manage-sites.html">Deleting a Site</a> in the
     * <i>Amazon WorkDocs Administration Guide</i>.
     * </p>
     * <p>
     * If you enable WorkDocs on a directory that already has existing WorkSpaces, the existing WorkSpaces and any new
     * WorkSpaces that are launched in the directory will have WorkDocs enabled.
     * </p>
     * </note>
     * 
     * @return Indicates whether Amazon WorkDocs is enabled for your WorkSpaces.</p> <note>
     *         <p>
     *         If WorkDocs is already enabled for a WorkSpaces directory and you disable it, new WorkSpaces launched in
     *         the directory will not have WorkDocs enabled. However, WorkDocs remains enabled for any existing
     *         WorkSpaces, unless you either disable users' access to WorkDocs or you delete the WorkDocs site. To
     *         disable users' access to WorkDocs, see <a
     *         href="https://docs.aws.amazon.com/workdocs/latest/adminguide/inactive-user.html">Disabling Users</a> in
     *         the <i>Amazon WorkDocs Administration Guide</i>. To delete a WorkDocs site, see <a
     *         href="https://docs.aws.amazon.com/workdocs/latest/adminguide/manage-sites.html">Deleting a Site</a> in
     *         the <i>Amazon WorkDocs Administration Guide</i>.
     *         </p>
     *         <p>
     *         If you enable WorkDocs on a directory that already has existing WorkSpaces, the existing WorkSpaces and
     *         any new WorkSpaces that are launched in the directory will have WorkDocs enabled.
     *         </p>
     */
    public final Boolean enableWorkDocs() {
        return enableWorkDocs;
    }

    /**
     * <p>
     * Indicates whether internet access is enabled for your WorkSpaces.
     * </p>
     * 
     * @return Indicates whether internet access is enabled for your WorkSpaces.
     */
    public final Boolean enableInternetAccess() {
        return enableInternetAccess;
    }

    /**
     * <p>
     * The default organizational unit (OU) for your WorkSpaces directories. This string must be the full Lightweight
     * Directory Access Protocol (LDAP) distinguished name for the target domain and OU. It must be in the form
     * <code>"OU=<i>value</i>,DC=<i>value</i>,DC=<i>value</i>"</code>, where <i>value</i> is any string of characters,
     * and the number of domain components (DCs) is two or more. For example,
     * <code>OU=WorkSpaces_machines,DC=machines,DC=example,DC=com</code>.
     * </p>
     * <important>
     * <ul>
     * <li>
     * <p>
     * To avoid errors, certain characters in the distinguished name must be escaped. For more information, see <a
     * href="https://docs.microsoft.com/previous-versions/windows/desktop/ldap/distinguished-names"> Distinguished
     * Names</a> in the Microsoft documentation.
     * </p>
     * </li>
     * <li>
     * <p>
     * The API doesn't validate whether the OU exists.
     * </p>
     * </li>
     * </ul>
     * </important>
     * 
     * @return The default organizational unit (OU) for your WorkSpaces directories. This string must be the full
     *         Lightweight Directory Access Protocol (LDAP) distinguished name for the target domain and OU. It must be
     *         in the form <code>"OU=<i>value</i>,DC=<i>value</i>,DC=<i>value</i>"</code>, where <i>value</i> is any
     *         string of characters, and the number of domain components (DCs) is two or more. For example,
     *         <code>OU=WorkSpaces_machines,DC=machines,DC=example,DC=com</code>. </p> <important>
     *         <ul>
     *         <li>
     *         <p>
     *         To avoid errors, certain characters in the distinguished name must be escaped. For more information, see
     *         <a href="https://docs.microsoft.com/previous-versions/windows/desktop/ldap/distinguished-names">
     *         Distinguished Names</a> in the Microsoft documentation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The API doesn't validate whether the OU exists.
     *         </p>
     *         </li>
     *         </ul>
     */
    public final String defaultOu() {
        return defaultOu;
    }

    /**
     * <p>
     * The identifier of your custom security group.
     * </p>
     * 
     * @return The identifier of your custom security group.
     */
    public final String customSecurityGroupId() {
        return customSecurityGroupId;
    }

    /**
     * <p>
     * Indicates whether users are local administrators of their WorkSpaces.
     * </p>
     * 
     * @return Indicates whether users are local administrators of their WorkSpaces.
     */
    public final Boolean userEnabledAsLocalAdministrator() {
        return userEnabledAsLocalAdministrator;
    }

    /**
     * <p>
     * Indicates whether maintenance mode is enabled for your WorkSpaces. For more information, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/workspace-maintenance.html">WorkSpace
     * Maintenance</a>.
     * </p>
     * 
     * @return Indicates whether maintenance mode is enabled for your WorkSpaces. For more information, see <a
     *         href="https://docs.aws.amazon.com/workspaces/latest/adminguide/workspace-maintenance.html">WorkSpace
     *         Maintenance</a>.
     */
    public final Boolean enableMaintenanceMode() {
        return enableMaintenanceMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enableWorkDocs());
        hashCode = 31 * hashCode + Objects.hashCode(enableInternetAccess());
        hashCode = 31 * hashCode + Objects.hashCode(defaultOu());
        hashCode = 31 * hashCode + Objects.hashCode(customSecurityGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(userEnabledAsLocalAdministrator());
        hashCode = 31 * hashCode + Objects.hashCode(enableMaintenanceMode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkspaceCreationProperties)) {
            return false;
        }
        WorkspaceCreationProperties other = (WorkspaceCreationProperties) obj;
        return Objects.equals(enableWorkDocs(), other.enableWorkDocs())
                && Objects.equals(enableInternetAccess(), other.enableInternetAccess())
                && Objects.equals(defaultOu(), other.defaultOu())
                && Objects.equals(customSecurityGroupId(), other.customSecurityGroupId())
                && Objects.equals(userEnabledAsLocalAdministrator(), other.userEnabledAsLocalAdministrator())
                && Objects.equals(enableMaintenanceMode(), other.enableMaintenanceMode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkspaceCreationProperties").add("EnableWorkDocs", enableWorkDocs())
                .add("EnableInternetAccess", enableInternetAccess()).add("DefaultOu", defaultOu())
                .add("CustomSecurityGroupId", customSecurityGroupId())
                .add("UserEnabledAsLocalAdministrator", userEnabledAsLocalAdministrator())
                .add("EnableMaintenanceMode", enableMaintenanceMode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EnableWorkDocs":
            return Optional.ofNullable(clazz.cast(enableWorkDocs()));
        case "EnableInternetAccess":
            return Optional.ofNullable(clazz.cast(enableInternetAccess()));
        case "DefaultOu":
            return Optional.ofNullable(clazz.cast(defaultOu()));
        case "CustomSecurityGroupId":
            return Optional.ofNullable(clazz.cast(customSecurityGroupId()));
        case "UserEnabledAsLocalAdministrator":
            return Optional.ofNullable(clazz.cast(userEnabledAsLocalAdministrator()));
        case "EnableMaintenanceMode":
            return Optional.ofNullable(clazz.cast(enableMaintenanceMode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkspaceCreationProperties, T> g) {
        return obj -> g.apply((WorkspaceCreationProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkspaceCreationProperties> {
        /**
         * <p>
         * Indicates whether Amazon WorkDocs is enabled for your WorkSpaces.
         * </p>
         * <note>
         * <p>
         * If WorkDocs is already enabled for a WorkSpaces directory and you disable it, new WorkSpaces launched in the
         * directory will not have WorkDocs enabled. However, WorkDocs remains enabled for any existing WorkSpaces,
         * unless you either disable users' access to WorkDocs or you delete the WorkDocs site. To disable users' access
         * to WorkDocs, see <a
         * href="https://docs.aws.amazon.com/workdocs/latest/adminguide/inactive-user.html">Disabling Users</a> in the
         * <i>Amazon WorkDocs Administration Guide</i>. To delete a WorkDocs site, see <a
         * href="https://docs.aws.amazon.com/workdocs/latest/adminguide/manage-sites.html">Deleting a Site</a> in the
         * <i>Amazon WorkDocs Administration Guide</i>.
         * </p>
         * <p>
         * If you enable WorkDocs on a directory that already has existing WorkSpaces, the existing WorkSpaces and any
         * new WorkSpaces that are launched in the directory will have WorkDocs enabled.
         * </p>
         * </note>
         * 
         * @param enableWorkDocs
         *        Indicates whether Amazon WorkDocs is enabled for your WorkSpaces.</p> <note>
         *        <p>
         *        If WorkDocs is already enabled for a WorkSpaces directory and you disable it, new WorkSpaces launched
         *        in the directory will not have WorkDocs enabled. However, WorkDocs remains enabled for any existing
         *        WorkSpaces, unless you either disable users' access to WorkDocs or you delete the WorkDocs site. To
         *        disable users' access to WorkDocs, see <a
         *        href="https://docs.aws.amazon.com/workdocs/latest/adminguide/inactive-user.html">Disabling Users</a>
         *        in the <i>Amazon WorkDocs Administration Guide</i>. To delete a WorkDocs site, see <a
         *        href="https://docs.aws.amazon.com/workdocs/latest/adminguide/manage-sites.html">Deleting a Site</a> in
         *        the <i>Amazon WorkDocs Administration Guide</i>.
         *        </p>
         *        <p>
         *        If you enable WorkDocs on a directory that already has existing WorkSpaces, the existing WorkSpaces
         *        and any new WorkSpaces that are launched in the directory will have WorkDocs enabled.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableWorkDocs(Boolean enableWorkDocs);

        /**
         * <p>
         * Indicates whether internet access is enabled for your WorkSpaces.
         * </p>
         * 
         * @param enableInternetAccess
         *        Indicates whether internet access is enabled for your WorkSpaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableInternetAccess(Boolean enableInternetAccess);

        /**
         * <p>
         * The default organizational unit (OU) for your WorkSpaces directories. This string must be the full
         * Lightweight Directory Access Protocol (LDAP) distinguished name for the target domain and OU. It must be in
         * the form <code>"OU=<i>value</i>,DC=<i>value</i>,DC=<i>value</i>"</code>, where <i>value</i> is any string of
         * characters, and the number of domain components (DCs) is two or more. For example,
         * <code>OU=WorkSpaces_machines,DC=machines,DC=example,DC=com</code>.
         * </p>
         * <important>
         * <ul>
         * <li>
         * <p>
         * To avoid errors, certain characters in the distinguished name must be escaped. For more information, see <a
         * href="https://docs.microsoft.com/previous-versions/windows/desktop/ldap/distinguished-names"> Distinguished
         * Names</a> in the Microsoft documentation.
         * </p>
         * </li>
         * <li>
         * <p>
         * The API doesn't validate whether the OU exists.
         * </p>
         * </li>
         * </ul>
         * </important>
         * 
         * @param defaultOu
         *        The default organizational unit (OU) for your WorkSpaces directories. This string must be the full
         *        Lightweight Directory Access Protocol (LDAP) distinguished name for the target domain and OU. It must
         *        be in the form <code>"OU=<i>value</i>,DC=<i>value</i>,DC=<i>value</i>"</code>, where <i>value</i> is
         *        any string of characters, and the number of domain components (DCs) is two or more. For example,
         *        <code>OU=WorkSpaces_machines,DC=machines,DC=example,DC=com</code>. </p> <important>
         *        <ul>
         *        <li>
         *        <p>
         *        To avoid errors, certain characters in the distinguished name must be escaped. For more information,
         *        see <a href="https://docs.microsoft.com/previous-versions/windows/desktop/ldap/distinguished-names">
         *        Distinguished Names</a> in the Microsoft documentation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The API doesn't validate whether the OU exists.
         *        </p>
         *        </li>
         *        </ul>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultOu(String defaultOu);

        /**
         * <p>
         * The identifier of your custom security group.
         * </p>
         * 
         * @param customSecurityGroupId
         *        The identifier of your custom security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customSecurityGroupId(String customSecurityGroupId);

        /**
         * <p>
         * Indicates whether users are local administrators of their WorkSpaces.
         * </p>
         * 
         * @param userEnabledAsLocalAdministrator
         *        Indicates whether users are local administrators of their WorkSpaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userEnabledAsLocalAdministrator(Boolean userEnabledAsLocalAdministrator);

        /**
         * <p>
         * Indicates whether maintenance mode is enabled for your WorkSpaces. For more information, see <a
         * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/workspace-maintenance.html">WorkSpace
         * Maintenance</a>.
         * </p>
         * 
         * @param enableMaintenanceMode
         *        Indicates whether maintenance mode is enabled for your WorkSpaces. For more information, see <a
         *        href="https://docs.aws.amazon.com/workspaces/latest/adminguide/workspace-maintenance.html">WorkSpace
         *        Maintenance</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableMaintenanceMode(Boolean enableMaintenanceMode);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enableWorkDocs;

        private Boolean enableInternetAccess;

        private String defaultOu;

        private String customSecurityGroupId;

        private Boolean userEnabledAsLocalAdministrator;

        private Boolean enableMaintenanceMode;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkspaceCreationProperties model) {
            enableWorkDocs(model.enableWorkDocs);
            enableInternetAccess(model.enableInternetAccess);
            defaultOu(model.defaultOu);
            customSecurityGroupId(model.customSecurityGroupId);
            userEnabledAsLocalAdministrator(model.userEnabledAsLocalAdministrator);
            enableMaintenanceMode(model.enableMaintenanceMode);
        }

        public final Boolean getEnableWorkDocs() {
            return enableWorkDocs;
        }

        public final void setEnableWorkDocs(Boolean enableWorkDocs) {
            this.enableWorkDocs = enableWorkDocs;
        }

        @Override
        public final Builder enableWorkDocs(Boolean enableWorkDocs) {
            this.enableWorkDocs = enableWorkDocs;
            return this;
        }

        public final Boolean getEnableInternetAccess() {
            return enableInternetAccess;
        }

        public final void setEnableInternetAccess(Boolean enableInternetAccess) {
            this.enableInternetAccess = enableInternetAccess;
        }

        @Override
        public final Builder enableInternetAccess(Boolean enableInternetAccess) {
            this.enableInternetAccess = enableInternetAccess;
            return this;
        }

        public final String getDefaultOu() {
            return defaultOu;
        }

        public final void setDefaultOu(String defaultOu) {
            this.defaultOu = defaultOu;
        }

        @Override
        public final Builder defaultOu(String defaultOu) {
            this.defaultOu = defaultOu;
            return this;
        }

        public final String getCustomSecurityGroupId() {
            return customSecurityGroupId;
        }

        public final void setCustomSecurityGroupId(String customSecurityGroupId) {
            this.customSecurityGroupId = customSecurityGroupId;
        }

        @Override
        public final Builder customSecurityGroupId(String customSecurityGroupId) {
            this.customSecurityGroupId = customSecurityGroupId;
            return this;
        }

        public final Boolean getUserEnabledAsLocalAdministrator() {
            return userEnabledAsLocalAdministrator;
        }

        public final void setUserEnabledAsLocalAdministrator(Boolean userEnabledAsLocalAdministrator) {
            this.userEnabledAsLocalAdministrator = userEnabledAsLocalAdministrator;
        }

        @Override
        public final Builder userEnabledAsLocalAdministrator(Boolean userEnabledAsLocalAdministrator) {
            this.userEnabledAsLocalAdministrator = userEnabledAsLocalAdministrator;
            return this;
        }

        public final Boolean getEnableMaintenanceMode() {
            return enableMaintenanceMode;
        }

        public final void setEnableMaintenanceMode(Boolean enableMaintenanceMode) {
            this.enableMaintenanceMode = enableMaintenanceMode;
        }

        @Override
        public final Builder enableMaintenanceMode(Boolean enableMaintenanceMode) {
            this.enableMaintenanceMode = enableMaintenanceMode;
            return this;
        }

        @Override
        public WorkspaceCreationProperties build() {
            return new WorkspaceCreationProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
