/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeWorkspacesResponse extends WorkSpacesResponse implements
        ToCopyableBuilder<DescribeWorkspacesResponse.Builder, DescribeWorkspacesResponse> {
    private static final SdkField<List<Workspace>> WORKSPACES_FIELD = SdkField
            .<List<Workspace>> builder(MarshallingType.LIST)
            .memberName("Workspaces")
            .getter(getter(DescribeWorkspacesResponse::workspaces))
            .setter(setter(Builder::workspaces))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Workspaces").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Workspace> builder(MarshallingType.SDK_POJO)
                                            .constructor(Workspace::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeWorkspacesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKSPACES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<Workspace> workspaces;

    private final String nextToken;

    private DescribeWorkspacesResponse(BuilderImpl builder) {
        super(builder);
        this.workspaces = builder.workspaces;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Workspaces property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasWorkspaces() {
        return workspaces != null && !(workspaces instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the WorkSpaces.
     * </p>
     * <p>
     * Because <a>CreateWorkspaces</a> is an asynchronous operation, some of the returned information could be
     * incomplete.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWorkspaces} method.
     * </p>
     * 
     * @return Information about the WorkSpaces.</p>
     *         <p>
     *         Because <a>CreateWorkspaces</a> is an asynchronous operation, some of the returned information could be
     *         incomplete.
     */
    public final List<Workspace> workspaces() {
        return workspaces;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is null when there are no more results to
     * return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is null when there are no more results
     *         to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasWorkspaces() ? workspaces() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWorkspacesResponse)) {
            return false;
        }
        DescribeWorkspacesResponse other = (DescribeWorkspacesResponse) obj;
        return hasWorkspaces() == other.hasWorkspaces() && Objects.equals(workspaces(), other.workspaces())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeWorkspacesResponse").add("Workspaces", hasWorkspaces() ? workspaces() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Workspaces":
            return Optional.ofNullable(clazz.cast(workspaces()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeWorkspacesResponse, T> g) {
        return obj -> g.apply((DescribeWorkspacesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkSpacesResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeWorkspacesResponse> {
        /**
         * <p>
         * Information about the WorkSpaces.
         * </p>
         * <p>
         * Because <a>CreateWorkspaces</a> is an asynchronous operation, some of the returned information could be
         * incomplete.
         * </p>
         * 
         * @param workspaces
         *        Information about the WorkSpaces.</p>
         *        <p>
         *        Because <a>CreateWorkspaces</a> is an asynchronous operation, some of the returned information could
         *        be incomplete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaces(Collection<Workspace> workspaces);

        /**
         * <p>
         * Information about the WorkSpaces.
         * </p>
         * <p>
         * Because <a>CreateWorkspaces</a> is an asynchronous operation, some of the returned information could be
         * incomplete.
         * </p>
         * 
         * @param workspaces
         *        Information about the WorkSpaces.</p>
         *        <p>
         *        Because <a>CreateWorkspaces</a> is an asynchronous operation, some of the returned information could
         *        be incomplete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaces(Workspace... workspaces);

        /**
         * <p>
         * Information about the WorkSpaces.
         * </p>
         * <p>
         * Because <a>CreateWorkspaces</a> is an asynchronous operation, some of the returned information could be
         * incomplete.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.workspaces.model.Workspace.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.workspaces.model.Workspace#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.workspaces.model.Workspace.Builder#build()} is called immediately and
         * its result is passed to {@link #workspaces(List<Workspace>)}.
         * 
         * @param workspaces
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.workspaces.model.Workspace.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workspaces(java.util.Collection<Workspace>)
         */
        Builder workspaces(Consumer<Workspace.Builder>... workspaces);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is null when there are no more results to
         * return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is null when there are no more
         *        results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends WorkSpacesResponse.BuilderImpl implements Builder {
        private List<Workspace> workspaces = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWorkspacesResponse model) {
            super(model);
            workspaces(model.workspaces);
            nextToken(model.nextToken);
        }

        public final List<Workspace.Builder> getWorkspaces() {
            List<Workspace.Builder> result = WorkspaceListCopier.copyToBuilder(this.workspaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWorkspaces(Collection<Workspace.BuilderImpl> workspaces) {
            this.workspaces = WorkspaceListCopier.copyFromBuilder(workspaces);
        }

        @Override
        public final Builder workspaces(Collection<Workspace> workspaces) {
            this.workspaces = WorkspaceListCopier.copy(workspaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workspaces(Workspace... workspaces) {
            workspaces(Arrays.asList(workspaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workspaces(Consumer<Workspace.Builder>... workspaces) {
            workspaces(Stream.of(workspaces).map(c -> Workspace.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeWorkspacesResponse build() {
            return new DescribeWorkspacesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
