/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateWorkspaceBundleRequest extends WorkSpacesRequest implements
        ToCopyableBuilder<CreateWorkspaceBundleRequest.Builder, CreateWorkspaceBundleRequest> {
    private static final SdkField<String> BUNDLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BundleName").getter(getter(CreateWorkspaceBundleRequest::bundleName))
            .setter(setter(Builder::bundleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BundleName").build()).build();

    private static final SdkField<String> BUNDLE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BundleDescription").getter(getter(CreateWorkspaceBundleRequest::bundleDescription))
            .setter(setter(Builder::bundleDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BundleDescription").build()).build();

    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImageId").getter(getter(CreateWorkspaceBundleRequest::imageId)).setter(setter(Builder::imageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").build()).build();

    private static final SdkField<ComputeType> COMPUTE_TYPE_FIELD = SdkField.<ComputeType> builder(MarshallingType.SDK_POJO)
            .memberName("ComputeType").getter(getter(CreateWorkspaceBundleRequest::computeType))
            .setter(setter(Builder::computeType)).constructor(ComputeType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeType").build()).build();

    private static final SdkField<UserStorage> USER_STORAGE_FIELD = SdkField.<UserStorage> builder(MarshallingType.SDK_POJO)
            .memberName("UserStorage").getter(getter(CreateWorkspaceBundleRequest::userStorage))
            .setter(setter(Builder::userStorage)).constructor(UserStorage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserStorage").build()).build();

    private static final SdkField<RootStorage> ROOT_STORAGE_FIELD = SdkField.<RootStorage> builder(MarshallingType.SDK_POJO)
            .memberName("RootStorage").getter(getter(CreateWorkspaceBundleRequest::rootStorage))
            .setter(setter(Builder::rootStorage)).constructor(RootStorage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootStorage").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateWorkspaceBundleRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUNDLE_NAME_FIELD,
            BUNDLE_DESCRIPTION_FIELD, IMAGE_ID_FIELD, COMPUTE_TYPE_FIELD, USER_STORAGE_FIELD, ROOT_STORAGE_FIELD, TAGS_FIELD));

    private final String bundleName;

    private final String bundleDescription;

    private final String imageId;

    private final ComputeType computeType;

    private final UserStorage userStorage;

    private final RootStorage rootStorage;

    private final List<Tag> tags;

    private CreateWorkspaceBundleRequest(BuilderImpl builder) {
        super(builder);
        this.bundleName = builder.bundleName;
        this.bundleDescription = builder.bundleDescription;
        this.imageId = builder.imageId;
        this.computeType = builder.computeType;
        this.userStorage = builder.userStorage;
        this.rootStorage = builder.rootStorage;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the bundle.
     * </p>
     * 
     * @return The name of the bundle.
     */
    public final String bundleName() {
        return bundleName;
    }

    /**
     * <p>
     * The description of the bundle.
     * </p>
     * 
     * @return The description of the bundle.
     */
    public final String bundleDescription() {
        return bundleDescription;
    }

    /**
     * <p>
     * The identifier of the image that is used to create the bundle.
     * </p>
     * 
     * @return The identifier of the image that is used to create the bundle.
     */
    public final String imageId() {
        return imageId;
    }

    /**
     * Returns the value of the ComputeType property for this object.
     * 
     * @return The value of the ComputeType property for this object.
     */
    public final ComputeType computeType() {
        return computeType;
    }

    /**
     * Returns the value of the UserStorage property for this object.
     * 
     * @return The value of the UserStorage property for this object.
     */
    public final UserStorage userStorage() {
        return userStorage;
    }

    /**
     * Returns the value of the RootStorage property for this object.
     * 
     * @return The value of the RootStorage property for this object.
     */
    public final RootStorage rootStorage() {
        return rootStorage;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags associated with the bundle.
     * </p>
     * <note>
     * <p>
     * To add tags at the same time when you're creating the bundle, you must create an IAM policy that grants your IAM
     * user permissions to use <code>workspaces:CreateTags</code>.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags associated with the bundle.</p> <note>
     *         <p>
     *         To add tags at the same time when you're creating the bundle, you must create an IAM policy that grants
     *         your IAM user permissions to use <code>workspaces:CreateTags</code>.
     *         </p>
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(bundleName());
        hashCode = 31 * hashCode + Objects.hashCode(bundleDescription());
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        hashCode = 31 * hashCode + Objects.hashCode(computeType());
        hashCode = 31 * hashCode + Objects.hashCode(userStorage());
        hashCode = 31 * hashCode + Objects.hashCode(rootStorage());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkspaceBundleRequest)) {
            return false;
        }
        CreateWorkspaceBundleRequest other = (CreateWorkspaceBundleRequest) obj;
        return Objects.equals(bundleName(), other.bundleName()) && Objects.equals(bundleDescription(), other.bundleDescription())
                && Objects.equals(imageId(), other.imageId()) && Objects.equals(computeType(), other.computeType())
                && Objects.equals(userStorage(), other.userStorage()) && Objects.equals(rootStorage(), other.rootStorage())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateWorkspaceBundleRequest").add("BundleName", bundleName())
                .add("BundleDescription", bundleDescription()).add("ImageId", imageId()).add("ComputeType", computeType())
                .add("UserStorage", userStorage()).add("RootStorage", rootStorage()).add("Tags", hasTags() ? tags() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BundleName":
            return Optional.ofNullable(clazz.cast(bundleName()));
        case "BundleDescription":
            return Optional.ofNullable(clazz.cast(bundleDescription()));
        case "ImageId":
            return Optional.ofNullable(clazz.cast(imageId()));
        case "ComputeType":
            return Optional.ofNullable(clazz.cast(computeType()));
        case "UserStorage":
            return Optional.ofNullable(clazz.cast(userStorage()));
        case "RootStorage":
            return Optional.ofNullable(clazz.cast(rootStorage()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateWorkspaceBundleRequest, T> g) {
        return obj -> g.apply((CreateWorkspaceBundleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkSpacesRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateWorkspaceBundleRequest> {
        /**
         * <p>
         * The name of the bundle.
         * </p>
         * 
         * @param bundleName
         *        The name of the bundle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bundleName(String bundleName);

        /**
         * <p>
         * The description of the bundle.
         * </p>
         * 
         * @param bundleDescription
         *        The description of the bundle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bundleDescription(String bundleDescription);

        /**
         * <p>
         * The identifier of the image that is used to create the bundle.
         * </p>
         * 
         * @param imageId
         *        The identifier of the image that is used to create the bundle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * Sets the value of the ComputeType property for this object.
         *
         * @param computeType
         *        The new value for the ComputeType property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeType(ComputeType computeType);

        /**
         * Sets the value of the ComputeType property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ComputeType.Builder} avoiding the need to
         * create one manually via {@link ComputeType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ComputeType.Builder#build()} is called immediately and its result
         * is passed to {@link #computeType(ComputeType)}.
         * 
         * @param computeType
         *        a consumer that will call methods on {@link ComputeType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #computeType(ComputeType)
         */
        default Builder computeType(Consumer<ComputeType.Builder> computeType) {
            return computeType(ComputeType.builder().applyMutation(computeType).build());
        }

        /**
         * Sets the value of the UserStorage property for this object.
         *
         * @param userStorage
         *        The new value for the UserStorage property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userStorage(UserStorage userStorage);

        /**
         * Sets the value of the UserStorage property for this object.
         *
         * This is a convenience method that creates an instance of the {@link UserStorage.Builder} avoiding the need to
         * create one manually via {@link UserStorage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserStorage.Builder#build()} is called immediately and its result
         * is passed to {@link #userStorage(UserStorage)}.
         * 
         * @param userStorage
         *        a consumer that will call methods on {@link UserStorage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userStorage(UserStorage)
         */
        default Builder userStorage(Consumer<UserStorage.Builder> userStorage) {
            return userStorage(UserStorage.builder().applyMutation(userStorage).build());
        }

        /**
         * Sets the value of the RootStorage property for this object.
         *
         * @param rootStorage
         *        The new value for the RootStorage property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rootStorage(RootStorage rootStorage);

        /**
         * Sets the value of the RootStorage property for this object.
         *
         * This is a convenience method that creates an instance of the {@link RootStorage.Builder} avoiding the need to
         * create one manually via {@link RootStorage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RootStorage.Builder#build()} is called immediately and its result
         * is passed to {@link #rootStorage(RootStorage)}.
         * 
         * @param rootStorage
         *        a consumer that will call methods on {@link RootStorage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rootStorage(RootStorage)
         */
        default Builder rootStorage(Consumer<RootStorage.Builder> rootStorage) {
            return rootStorage(RootStorage.builder().applyMutation(rootStorage).build());
        }

        /**
         * <p>
         * The tags associated with the bundle.
         * </p>
         * <note>
         * <p>
         * To add tags at the same time when you're creating the bundle, you must create an IAM policy that grants your
         * IAM user permissions to use <code>workspaces:CreateTags</code>.
         * </p>
         * </note>
         * 
         * @param tags
         *        The tags associated with the bundle.</p> <note>
         *        <p>
         *        To add tags at the same time when you're creating the bundle, you must create an IAM policy that
         *        grants your IAM user permissions to use <code>workspaces:CreateTags</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags associated with the bundle.
         * </p>
         * <note>
         * <p>
         * To add tags at the same time when you're creating the bundle, you must create an IAM policy that grants your
         * IAM user permissions to use <code>workspaces:CreateTags</code>.
         * </p>
         * </note>
         * 
         * @param tags
         *        The tags associated with the bundle.</p> <note>
         *        <p>
         *        To add tags at the same time when you're creating the bundle, you must create an IAM policy that
         *        grants your IAM user permissions to use <code>workspaces:CreateTags</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags associated with the bundle.
         * </p>
         * <note>
         * <p>
         * To add tags at the same time when you're creating the bundle, you must create an IAM policy that grants your
         * IAM user permissions to use <code>workspaces:CreateTags</code>.
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.workspaces.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.workspaces.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.workspaces.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.workspaces.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkSpacesRequest.BuilderImpl implements Builder {
        private String bundleName;

        private String bundleDescription;

        private String imageId;

        private ComputeType computeType;

        private UserStorage userStorage;

        private RootStorage rootStorage;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWorkspaceBundleRequest model) {
            super(model);
            bundleName(model.bundleName);
            bundleDescription(model.bundleDescription);
            imageId(model.imageId);
            computeType(model.computeType);
            userStorage(model.userStorage);
            rootStorage(model.rootStorage);
            tags(model.tags);
        }

        public final String getBundleName() {
            return bundleName;
        }

        public final void setBundleName(String bundleName) {
            this.bundleName = bundleName;
        }

        @Override
        public final Builder bundleName(String bundleName) {
            this.bundleName = bundleName;
            return this;
        }

        public final String getBundleDescription() {
            return bundleDescription;
        }

        public final void setBundleDescription(String bundleDescription) {
            this.bundleDescription = bundleDescription;
        }

        @Override
        public final Builder bundleDescription(String bundleDescription) {
            this.bundleDescription = bundleDescription;
            return this;
        }

        public final String getImageId() {
            return imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final ComputeType.Builder getComputeType() {
            return computeType != null ? computeType.toBuilder() : null;
        }

        public final void setComputeType(ComputeType.BuilderImpl computeType) {
            this.computeType = computeType != null ? computeType.build() : null;
        }

        @Override
        public final Builder computeType(ComputeType computeType) {
            this.computeType = computeType;
            return this;
        }

        public final UserStorage.Builder getUserStorage() {
            return userStorage != null ? userStorage.toBuilder() : null;
        }

        public final void setUserStorage(UserStorage.BuilderImpl userStorage) {
            this.userStorage = userStorage != null ? userStorage.build() : null;
        }

        @Override
        public final Builder userStorage(UserStorage userStorage) {
            this.userStorage = userStorage;
            return this;
        }

        public final RootStorage.Builder getRootStorage() {
            return rootStorage != null ? rootStorage.toBuilder() : null;
        }

        public final void setRootStorage(RootStorage.BuilderImpl rootStorage) {
            this.rootStorage = rootStorage != null ? rootStorage.build() : null;
        }

        @Override
        public final Builder rootStorage(RootStorage rootStorage) {
            this.rootStorage = rootStorage;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateWorkspaceBundleRequest build() {
            return new CreateWorkspaceBundleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
