/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateImpersonationRoleRequest extends WorkMailRequest implements
        ToCopyableBuilder<CreateImpersonationRoleRequest.Builder, CreateImpersonationRoleRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateImpersonationRoleRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> ORGANIZATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OrganizationId").getter(getter(CreateImpersonationRoleRequest::organizationId))
            .setter(setter(Builder::organizationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateImpersonationRoleRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(CreateImpersonationRoleRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateImpersonationRoleRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<ImpersonationRule>> RULES_FIELD = SdkField
            .<List<ImpersonationRule>> builder(MarshallingType.LIST)
            .memberName("Rules")
            .getter(getter(CreateImpersonationRoleRequest::rules))
            .setter(setter(Builder::rules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ImpersonationRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(ImpersonationRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            ORGANIZATION_ID_FIELD, NAME_FIELD, TYPE_FIELD, DESCRIPTION_FIELD, RULES_FIELD));

    private final String clientToken;

    private final String organizationId;

    private final String name;

    private final String type;

    private final String description;

    private final List<ImpersonationRule> rules;

    private CreateImpersonationRoleRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.organizationId = builder.organizationId;
        this.name = builder.name;
        this.type = builder.type;
        this.description = builder.description;
        this.rules = builder.rules;
    }

    /**
     * <p>
     * The idempotency token for the client request.
     * </p>
     * 
     * @return The idempotency token for the client request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The WorkMail organization to create the new impersonation role within.
     * </p>
     * 
     * @return The WorkMail organization to create the new impersonation role within.
     */
    public final String organizationId() {
        return organizationId;
    }

    /**
     * <p>
     * The name of the new impersonation role.
     * </p>
     * 
     * @return The name of the new impersonation role.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The impersonation role's type. The available impersonation role types are <code>READ_ONLY</code> or
     * <code>FULL_ACCESS</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ImpersonationRoleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The impersonation role's type. The available impersonation role types are <code>READ_ONLY</code> or
     *         <code>FULL_ACCESS</code>.
     * @see ImpersonationRoleType
     */
    public final ImpersonationRoleType type() {
        return ImpersonationRoleType.fromValue(type);
    }

    /**
     * <p>
     * The impersonation role's type. The available impersonation role types are <code>READ_ONLY</code> or
     * <code>FULL_ACCESS</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ImpersonationRoleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The impersonation role's type. The available impersonation role types are <code>READ_ONLY</code> or
     *         <code>FULL_ACCESS</code>.
     * @see ImpersonationRoleType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The description of the new impersonation role.
     * </p>
     * 
     * @return The description of the new impersonation role.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Rules property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasRules() {
        return rules != null && !(rules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of rules for the impersonation role.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRules} method.
     * </p>
     * 
     * @return The list of rules for the impersonation role.
     */
    public final List<ImpersonationRule> rules() {
        return rules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(organizationId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasRules() ? rules() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateImpersonationRoleRequest)) {
            return false;
        }
        CreateImpersonationRoleRequest other = (CreateImpersonationRoleRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(organizationId(), other.organizationId())
                && Objects.equals(name(), other.name()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(description(), other.description()) && hasRules() == other.hasRules()
                && Objects.equals(rules(), other.rules());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateImpersonationRoleRequest").add("ClientToken", clientToken())
                .add("OrganizationId", organizationId()).add("Name", name()).add("Type", typeAsString())
                .add("Description", description()).add("Rules", hasRules() ? rules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "OrganizationId":
            return Optional.ofNullable(clazz.cast(organizationId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Rules":
            return Optional.ofNullable(clazz.cast(rules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateImpersonationRoleRequest, T> g) {
        return obj -> g.apply((CreateImpersonationRoleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkMailRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateImpersonationRoleRequest> {
        /**
         * <p>
         * The idempotency token for the client request.
         * </p>
         * 
         * @param clientToken
         *        The idempotency token for the client request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The WorkMail organization to create the new impersonation role within.
         * </p>
         * 
         * @param organizationId
         *        The WorkMail organization to create the new impersonation role within.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationId(String organizationId);

        /**
         * <p>
         * The name of the new impersonation role.
         * </p>
         * 
         * @param name
         *        The name of the new impersonation role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The impersonation role's type. The available impersonation role types are <code>READ_ONLY</code> or
         * <code>FULL_ACCESS</code>.
         * </p>
         * 
         * @param type
         *        The impersonation role's type. The available impersonation role types are <code>READ_ONLY</code> or
         *        <code>FULL_ACCESS</code>.
         * @see ImpersonationRoleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImpersonationRoleType
         */
        Builder type(String type);

        /**
         * <p>
         * The impersonation role's type. The available impersonation role types are <code>READ_ONLY</code> or
         * <code>FULL_ACCESS</code>.
         * </p>
         * 
         * @param type
         *        The impersonation role's type. The available impersonation role types are <code>READ_ONLY</code> or
         *        <code>FULL_ACCESS</code>.
         * @see ImpersonationRoleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImpersonationRoleType
         */
        Builder type(ImpersonationRoleType type);

        /**
         * <p>
         * The description of the new impersonation role.
         * </p>
         * 
         * @param description
         *        The description of the new impersonation role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The list of rules for the impersonation role.
         * </p>
         * 
         * @param rules
         *        The list of rules for the impersonation role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Collection<ImpersonationRule> rules);

        /**
         * <p>
         * The list of rules for the impersonation role.
         * </p>
         * 
         * @param rules
         *        The list of rules for the impersonation role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(ImpersonationRule... rules);

        /**
         * <p>
         * The list of rules for the impersonation role.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.workmail.model.ImpersonationRule.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.workmail.model.ImpersonationRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.workmail.model.ImpersonationRule.Builder#build()} is called
         * immediately and its result is passed to {@link #rules(List<ImpersonationRule>)}.
         * 
         * @param rules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.workmail.model.ImpersonationRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rules(java.util.Collection<ImpersonationRule>)
         */
        Builder rules(Consumer<ImpersonationRule.Builder>... rules);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkMailRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String organizationId;

        private String name;

        private String type;

        private String description;

        private List<ImpersonationRule> rules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateImpersonationRoleRequest model) {
            super(model);
            clientToken(model.clientToken);
            organizationId(model.organizationId);
            name(model.name);
            type(model.type);
            description(model.description);
            rules(model.rules);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getOrganizationId() {
            return organizationId;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        @Override
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ImpersonationRoleType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<ImpersonationRule.Builder> getRules() {
            List<ImpersonationRule.Builder> result = ImpersonationRuleListCopier.copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRules(Collection<ImpersonationRule.BuilderImpl> rules) {
            this.rules = ImpersonationRuleListCopier.copyFromBuilder(rules);
        }

        @Override
        public final Builder rules(Collection<ImpersonationRule> rules) {
            this.rules = ImpersonationRuleListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(ImpersonationRule... rules) {
            rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<ImpersonationRule.Builder>... rules) {
            rules(Stream.of(rules).map(c -> ImpersonationRule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateImpersonationRoleRequest build() {
            return new CreateImpersonationRoleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
