/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The rule that a simulated user matches.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MobileDeviceAccessMatchedRule implements SdkPojo, Serializable,
        ToCopyableBuilder<MobileDeviceAccessMatchedRule.Builder, MobileDeviceAccessMatchedRule> {
    private static final SdkField<String> MOBILE_DEVICE_ACCESS_RULE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MobileDeviceAccessRuleId").getter(getter(MobileDeviceAccessMatchedRule::mobileDeviceAccessRuleId))
            .setter(setter(Builder::mobileDeviceAccessRuleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MobileDeviceAccessRuleId").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(MobileDeviceAccessMatchedRule::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MOBILE_DEVICE_ACCESS_RULE_ID_FIELD, NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String mobileDeviceAccessRuleId;

    private final String name;

    private MobileDeviceAccessMatchedRule(BuilderImpl builder) {
        this.mobileDeviceAccessRuleId = builder.mobileDeviceAccessRuleId;
        this.name = builder.name;
    }

    /**
     * <p>
     * Identifier of the rule that a simulated user matches.
     * </p>
     * 
     * @return Identifier of the rule that a simulated user matches.
     */
    public final String mobileDeviceAccessRuleId() {
        return mobileDeviceAccessRuleId;
    }

    /**
     * <p>
     * Name of a rule that a simulated user matches.
     * </p>
     * 
     * @return Name of a rule that a simulated user matches.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mobileDeviceAccessRuleId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MobileDeviceAccessMatchedRule)) {
            return false;
        }
        MobileDeviceAccessMatchedRule other = (MobileDeviceAccessMatchedRule) obj;
        return Objects.equals(mobileDeviceAccessRuleId(), other.mobileDeviceAccessRuleId())
                && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MobileDeviceAccessMatchedRule").add("MobileDeviceAccessRuleId", mobileDeviceAccessRuleId())
                .add("Name", name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MobileDeviceAccessRuleId":
            return Optional.ofNullable(clazz.cast(mobileDeviceAccessRuleId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MobileDeviceAccessMatchedRule, T> g) {
        return obj -> g.apply((MobileDeviceAccessMatchedRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MobileDeviceAccessMatchedRule> {
        /**
         * <p>
         * Identifier of the rule that a simulated user matches.
         * </p>
         * 
         * @param mobileDeviceAccessRuleId
         *        Identifier of the rule that a simulated user matches.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mobileDeviceAccessRuleId(String mobileDeviceAccessRuleId);

        /**
         * <p>
         * Name of a rule that a simulated user matches.
         * </p>
         * 
         * @param name
         *        Name of a rule that a simulated user matches.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);
    }

    static final class BuilderImpl implements Builder {
        private String mobileDeviceAccessRuleId;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(MobileDeviceAccessMatchedRule model) {
            mobileDeviceAccessRuleId(model.mobileDeviceAccessRuleId);
            name(model.name);
        }

        public final String getMobileDeviceAccessRuleId() {
            return mobileDeviceAccessRuleId;
        }

        public final void setMobileDeviceAccessRuleId(String mobileDeviceAccessRuleId) {
            this.mobileDeviceAccessRuleId = mobileDeviceAccessRuleId;
        }

        @Override
        public final Builder mobileDeviceAccessRuleId(String mobileDeviceAccessRuleId) {
            this.mobileDeviceAccessRuleId = mobileDeviceAccessRuleId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public MobileDeviceAccessMatchedRule build() {
            return new MobileDeviceAccessMatchedRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
