/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.workmail.DefaultWorkMailAsyncClient;
import software.amazon.awssdk.services.workmail.DefaultWorkMailBaseClientBuilder;
import software.amazon.awssdk.services.workmail.WorkMailAsyncClient;
import software.amazon.awssdk.services.workmail.WorkMailAsyncClientBuilder;
import software.amazon.awssdk.services.workmail.WorkMailServiceClientConfiguration;
import software.amazon.awssdk.services.workmail.endpoints.WorkMailEndpointProvider;

@SdkInternalApi
final class DefaultWorkMailAsyncClientBuilder
extends DefaultWorkMailBaseClientBuilder<WorkMailAsyncClientBuilder, WorkMailAsyncClient>
implements WorkMailAsyncClientBuilder {
    DefaultWorkMailAsyncClientBuilder() {
    }

    @Override
    public DefaultWorkMailAsyncClientBuilder endpointProvider(WorkMailEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final WorkMailAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultWorkMailAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        WorkMailServiceClientConfiguration serviceClientConfiguration = WorkMailServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultWorkMailAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

