/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workmail.WorkMailClient;
import software.amazon.awssdk.services.workmail.internal.UserAgentUtils;
import software.amazon.awssdk.services.workmail.model.ListUsersRequest;
import software.amazon.awssdk.services.workmail.model.ListUsersResponse;

public class ListUsersIterable
implements SdkIterable<ListUsersResponse> {
    private final WorkMailClient client;
    private final ListUsersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListUsersIterable(WorkMailClient client, ListUsersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListUsersResponseFetcher();
    }

    public Iterator<ListUsersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListUsersResponseFetcher
    implements SyncPageFetcher<ListUsersResponse> {
        private ListUsersResponseFetcher() {
        }

        public boolean hasNextPage(ListUsersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListUsersResponse nextPage(ListUsersResponse previousPage) {
            if (previousPage == null) {
                return ListUsersIterable.this.client.listUsers(ListUsersIterable.this.firstRequest);
            }
            return ListUsersIterable.this.client.listUsers((ListUsersRequest)((Object)ListUsersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

