/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.worklink.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.worklink.WorkLinkClient;
import software.amazon.awssdk.services.worklink.internal.UserAgentUtils;
import software.amazon.awssdk.services.worklink.model.ListWebsiteAuthorizationProvidersRequest;
import software.amazon.awssdk.services.worklink.model.ListWebsiteAuthorizationProvidersResponse;

public class ListWebsiteAuthorizationProvidersIterable
implements SdkIterable<ListWebsiteAuthorizationProvidersResponse> {
    private final WorkLinkClient client;
    private final ListWebsiteAuthorizationProvidersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListWebsiteAuthorizationProvidersIterable(WorkLinkClient client, ListWebsiteAuthorizationProvidersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListWebsiteAuthorizationProvidersResponseFetcher();
    }

    public Iterator<ListWebsiteAuthorizationProvidersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListWebsiteAuthorizationProvidersResponseFetcher
    implements SyncPageFetcher<ListWebsiteAuthorizationProvidersResponse> {
        private ListWebsiteAuthorizationProvidersResponseFetcher() {
        }

        public boolean hasNextPage(ListWebsiteAuthorizationProvidersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListWebsiteAuthorizationProvidersResponse nextPage(ListWebsiteAuthorizationProvidersResponse previousPage) {
            if (previousPage == null) {
                return ListWebsiteAuthorizationProvidersIterable.this.client.listWebsiteAuthorizationProviders(ListWebsiteAuthorizationProvidersIterable.this.firstRequest);
            }
            return ListWebsiteAuthorizationProvidersIterable.this.client.listWebsiteAuthorizationProviders((ListWebsiteAuthorizationProvidersRequest)((Object)ListWebsiteAuthorizationProvidersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

