/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.worklink.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AuthorizationProviderType {
    SAML("SAML"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AuthorizationProviderType> VALUE_MAP;
    private final String value;

    private AuthorizationProviderType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AuthorizationProviderType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AuthorizationProviderType> knownValues() {
        EnumSet<AuthorizationProviderType> knownValues = EnumSet.allOf(AuthorizationProviderType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AuthorizationProviderType.class, AuthorizationProviderType::toString);
    }
}

