/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.worklink.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.worklink.model.DeviceStatus;
import software.amazon.awssdk.services.worklink.model.WorkLinkResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDeviceResponse
extends WorkLinkResponse
implements ToCopyableBuilder<Builder, DescribeDeviceResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribeDeviceResponse.getter(DescribeDeviceResponse::statusAsString)).setter(DescribeDeviceResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Model").getter(DescribeDeviceResponse.getter(DescribeDeviceResponse::model)).setter(DescribeDeviceResponse.setter(Builder::model)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Model").build()}).build();
    private static final SdkField<String> MANUFACTURER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Manufacturer").getter(DescribeDeviceResponse.getter(DescribeDeviceResponse::manufacturer)).setter(DescribeDeviceResponse.setter(Builder::manufacturer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Manufacturer").build()}).build();
    private static final SdkField<String> OPERATING_SYSTEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperatingSystem").getter(DescribeDeviceResponse.getter(DescribeDeviceResponse::operatingSystem)).setter(DescribeDeviceResponse.setter(Builder::operatingSystem)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingSystem").build()}).build();
    private static final SdkField<String> OPERATING_SYSTEM_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperatingSystemVersion").getter(DescribeDeviceResponse.getter(DescribeDeviceResponse::operatingSystemVersion)).setter(DescribeDeviceResponse.setter(Builder::operatingSystemVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingSystemVersion").build()}).build();
    private static final SdkField<String> PATCH_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PatchLevel").getter(DescribeDeviceResponse.getter(DescribeDeviceResponse::patchLevel)).setter(DescribeDeviceResponse.setter(Builder::patchLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PatchLevel").build()}).build();
    private static final SdkField<Instant> FIRST_ACCESSED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("FirstAccessedTime").getter(DescribeDeviceResponse.getter(DescribeDeviceResponse::firstAccessedTime)).setter(DescribeDeviceResponse.setter(Builder::firstAccessedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirstAccessedTime").build()}).build();
    private static final SdkField<Instant> LAST_ACCESSED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastAccessedTime").getter(DescribeDeviceResponse.getter(DescribeDeviceResponse::lastAccessedTime)).setter(DescribeDeviceResponse.setter(Builder::lastAccessedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastAccessedTime").build()}).build();
    private static final SdkField<String> USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Username").getter(DescribeDeviceResponse.getter(DescribeDeviceResponse::username)).setter(DescribeDeviceResponse.setter(Builder::username)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, MODEL_FIELD, MANUFACTURER_FIELD, OPERATING_SYSTEM_FIELD, OPERATING_SYSTEM_VERSION_FIELD, PATCH_LEVEL_FIELD, FIRST_ACCESSED_TIME_FIELD, LAST_ACCESSED_TIME_FIELD, USERNAME_FIELD));
    private final String status;
    private final String model;
    private final String manufacturer;
    private final String operatingSystem;
    private final String operatingSystemVersion;
    private final String patchLevel;
    private final Instant firstAccessedTime;
    private final Instant lastAccessedTime;
    private final String username;

    private DescribeDeviceResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.model = builder.model;
        this.manufacturer = builder.manufacturer;
        this.operatingSystem = builder.operatingSystem;
        this.operatingSystemVersion = builder.operatingSystemVersion;
        this.patchLevel = builder.patchLevel;
        this.firstAccessedTime = builder.firstAccessedTime;
        this.lastAccessedTime = builder.lastAccessedTime;
        this.username = builder.username;
    }

    public final DeviceStatus status() {
        return DeviceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String model() {
        return this.model;
    }

    public final String manufacturer() {
        return this.manufacturer;
    }

    public final String operatingSystem() {
        return this.operatingSystem;
    }

    public final String operatingSystemVersion() {
        return this.operatingSystemVersion;
    }

    public final String patchLevel() {
        return this.patchLevel;
    }

    public final Instant firstAccessedTime() {
        return this.firstAccessedTime;
    }

    public final Instant lastAccessedTime() {
        return this.lastAccessedTime;
    }

    public final String username() {
        return this.username;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.model());
        hashCode = 31 * hashCode + Objects.hashCode(this.manufacturer());
        hashCode = 31 * hashCode + Objects.hashCode(this.operatingSystem());
        hashCode = 31 * hashCode + Objects.hashCode(this.operatingSystemVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.patchLevel());
        hashCode = 31 * hashCode + Objects.hashCode(this.firstAccessedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastAccessedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDeviceResponse)) {
            return false;
        }
        DescribeDeviceResponse other = (DescribeDeviceResponse)((Object)obj);
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.model(), other.model()) && Objects.equals(this.manufacturer(), other.manufacturer()) && Objects.equals(this.operatingSystem(), other.operatingSystem()) && Objects.equals(this.operatingSystemVersion(), other.operatingSystemVersion()) && Objects.equals(this.patchLevel(), other.patchLevel()) && Objects.equals(this.firstAccessedTime(), other.firstAccessedTime()) && Objects.equals(this.lastAccessedTime(), other.lastAccessedTime()) && Objects.equals(this.username(), other.username());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDeviceResponse").add("Status", (Object)this.statusAsString()).add("Model", (Object)this.model()).add("Manufacturer", (Object)this.manufacturer()).add("OperatingSystem", (Object)this.operatingSystem()).add("OperatingSystemVersion", (Object)this.operatingSystemVersion()).add("PatchLevel", (Object)this.patchLevel()).add("FirstAccessedTime", (Object)this.firstAccessedTime()).add("LastAccessedTime", (Object)this.lastAccessedTime()).add("Username", (Object)this.username()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Model": {
                return Optional.ofNullable(clazz.cast(this.model()));
            }
            case "Manufacturer": {
                return Optional.ofNullable(clazz.cast(this.manufacturer()));
            }
            case "OperatingSystem": {
                return Optional.ofNullable(clazz.cast(this.operatingSystem()));
            }
            case "OperatingSystemVersion": {
                return Optional.ofNullable(clazz.cast(this.operatingSystemVersion()));
            }
            case "PatchLevel": {
                return Optional.ofNullable(clazz.cast(this.patchLevel()));
            }
            case "FirstAccessedTime": {
                return Optional.ofNullable(clazz.cast(this.firstAccessedTime()));
            }
            case "LastAccessedTime": {
                return Optional.ofNullable(clazz.cast(this.lastAccessedTime()));
            }
            case "Username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDeviceResponse, T> g) {
        return obj -> g.apply((DescribeDeviceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkLinkResponse.BuilderImpl
    implements Builder {
        private String status;
        private String model;
        private String manufacturer;
        private String operatingSystem;
        private String operatingSystemVersion;
        private String patchLevel;
        private Instant firstAccessedTime;
        private Instant lastAccessedTime;
        private String username;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDeviceResponse model) {
            super(model);
            this.status(model.status);
            this.model(model.model);
            this.manufacturer(model.manufacturer);
            this.operatingSystem(model.operatingSystem);
            this.operatingSystemVersion(model.operatingSystemVersion);
            this.patchLevel(model.patchLevel);
            this.firstAccessedTime(model.firstAccessedTime);
            this.lastAccessedTime(model.lastAccessedTime);
            this.username(model.username);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DeviceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getModel() {
            return this.model;
        }

        public final void setModel(String model) {
            this.model = model;
        }

        @Override
        public final Builder model(String model) {
            this.model = model;
            return this;
        }

        public final String getManufacturer() {
            return this.manufacturer;
        }

        public final void setManufacturer(String manufacturer) {
            this.manufacturer = manufacturer;
        }

        @Override
        public final Builder manufacturer(String manufacturer) {
            this.manufacturer = manufacturer;
            return this;
        }

        public final String getOperatingSystem() {
            return this.operatingSystem;
        }

        public final void setOperatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
        }

        @Override
        public final Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        public final String getOperatingSystemVersion() {
            return this.operatingSystemVersion;
        }

        public final void setOperatingSystemVersion(String operatingSystemVersion) {
            this.operatingSystemVersion = operatingSystemVersion;
        }

        @Override
        public final Builder operatingSystemVersion(String operatingSystemVersion) {
            this.operatingSystemVersion = operatingSystemVersion;
            return this;
        }

        public final String getPatchLevel() {
            return this.patchLevel;
        }

        public final void setPatchLevel(String patchLevel) {
            this.patchLevel = patchLevel;
        }

        @Override
        public final Builder patchLevel(String patchLevel) {
            this.patchLevel = patchLevel;
            return this;
        }

        public final Instant getFirstAccessedTime() {
            return this.firstAccessedTime;
        }

        public final void setFirstAccessedTime(Instant firstAccessedTime) {
            this.firstAccessedTime = firstAccessedTime;
        }

        @Override
        public final Builder firstAccessedTime(Instant firstAccessedTime) {
            this.firstAccessedTime = firstAccessedTime;
            return this;
        }

        public final Instant getLastAccessedTime() {
            return this.lastAccessedTime;
        }

        public final void setLastAccessedTime(Instant lastAccessedTime) {
            this.lastAccessedTime = lastAccessedTime;
        }

        @Override
        public final Builder lastAccessedTime(Instant lastAccessedTime) {
            this.lastAccessedTime = lastAccessedTime;
            return this;
        }

        public final String getUsername() {
            return this.username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        @Override
        public DescribeDeviceResponse build() {
            return new DescribeDeviceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkLinkResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDeviceResponse> {
        public Builder status(String var1);

        public Builder status(DeviceStatus var1);

        public Builder model(String var1);

        public Builder manufacturer(String var1);

        public Builder operatingSystem(String var1);

        public Builder operatingSystemVersion(String var1);

        public Builder patchLevel(String var1);

        public Builder firstAccessedTime(Instant var1);

        public Builder lastAccessedTime(Instant var1);

        public Builder username(String var1);
    }
}

