/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wisdom.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the import job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QuickResponseSearchExpression implements SdkPojo, Serializable,
        ToCopyableBuilder<QuickResponseSearchExpression.Builder, QuickResponseSearchExpression> {
    private static final SdkField<List<QuickResponseFilterField>> FILTERS_FIELD = SdkField
            .<List<QuickResponseFilterField>> builder(MarshallingType.LIST)
            .memberName("filters")
            .getter(getter(QuickResponseSearchExpression::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<QuickResponseFilterField> builder(MarshallingType.SDK_POJO)
                                            .constructor(QuickResponseFilterField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<QuickResponseOrderField> ORDER_ON_FIELD_FIELD = SdkField
            .<QuickResponseOrderField> builder(MarshallingType.SDK_POJO).memberName("orderOnField")
            .getter(getter(QuickResponseSearchExpression::orderOnField)).setter(setter(Builder::orderOnField))
            .constructor(QuickResponseOrderField::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orderOnField").build()).build();

    private static final SdkField<List<QuickResponseQueryField>> QUERIES_FIELD = SdkField
            .<List<QuickResponseQueryField>> builder(MarshallingType.LIST)
            .memberName("queries")
            .getter(getter(QuickResponseSearchExpression::queries))
            .setter(setter(Builder::queries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<QuickResponseQueryField> builder(MarshallingType.SDK_POJO)
                                            .constructor(QuickResponseQueryField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD,
            ORDER_ON_FIELD_FIELD, QUERIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<QuickResponseFilterField> filters;

    private final QuickResponseOrderField orderOnField;

    private final List<QuickResponseQueryField> queries;

    private QuickResponseSearchExpression(BuilderImpl builder) {
        this.filters = builder.filters;
        this.orderOnField = builder.orderOnField;
        this.queries = builder.queries;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The configuration of filtering rules applied to quick response query results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return The configuration of filtering rules applied to quick response query results.
     */
    public final List<QuickResponseFilterField> filters() {
        return filters;
    }

    /**
     * <p>
     * The quick response attribute fields on which the query results are ordered.
     * </p>
     * 
     * @return The quick response attribute fields on which the query results are ordered.
     */
    public final QuickResponseOrderField orderOnField() {
        return orderOnField;
    }

    /**
     * For responses, this returns true if the service returned a value for the Queries property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasQueries() {
        return queries != null && !(queries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The quick response query expressions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasQueries} method.
     * </p>
     * 
     * @return The quick response query expressions.
     */
    public final List<QuickResponseQueryField> queries() {
        return queries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(orderOnField());
        hashCode = 31 * hashCode + Objects.hashCode(hasQueries() ? queries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QuickResponseSearchExpression)) {
            return false;
        }
        QuickResponseSearchExpression other = (QuickResponseSearchExpression) obj;
        return hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && Objects.equals(orderOnField(), other.orderOnField()) && hasQueries() == other.hasQueries()
                && Objects.equals(queries(), other.queries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QuickResponseSearchExpression").add("Filters", hasFilters() ? filters() : null)
                .add("OrderOnField", orderOnField()).add("Queries", hasQueries() ? queries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "orderOnField":
            return Optional.ofNullable(clazz.cast(orderOnField()));
        case "queries":
            return Optional.ofNullable(clazz.cast(queries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QuickResponseSearchExpression, T> g) {
        return obj -> g.apply((QuickResponseSearchExpression) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QuickResponseSearchExpression> {
        /**
         * <p>
         * The configuration of filtering rules applied to quick response query results.
         * </p>
         * 
         * @param filters
         *        The configuration of filtering rules applied to quick response query results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<QuickResponseFilterField> filters);

        /**
         * <p>
         * The configuration of filtering rules applied to quick response query results.
         * </p>
         * 
         * @param filters
         *        The configuration of filtering rules applied to quick response query results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(QuickResponseFilterField... filters);

        /**
         * <p>
         * The configuration of filtering rules applied to quick response query results.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.wisdom.model.QuickResponseFilterField.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.wisdom.model.QuickResponseFilterField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.wisdom.model.QuickResponseFilterField.Builder#build()} is called
         * immediately and its result is passed to {@link #filters(List<QuickResponseFilterField>)}.
         * 
         * @param filters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.wisdom.model.QuickResponseFilterField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<QuickResponseFilterField>)
         */
        Builder filters(Consumer<QuickResponseFilterField.Builder>... filters);

        /**
         * <p>
         * The quick response attribute fields on which the query results are ordered.
         * </p>
         * 
         * @param orderOnField
         *        The quick response attribute fields on which the query results are ordered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orderOnField(QuickResponseOrderField orderOnField);

        /**
         * <p>
         * The quick response attribute fields on which the query results are ordered.
         * </p>
         * This is a convenience method that creates an instance of the {@link QuickResponseOrderField.Builder} avoiding
         * the need to create one manually via {@link QuickResponseOrderField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QuickResponseOrderField.Builder#build()} is called immediately
         * and its result is passed to {@link #orderOnField(QuickResponseOrderField)}.
         * 
         * @param orderOnField
         *        a consumer that will call methods on {@link QuickResponseOrderField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #orderOnField(QuickResponseOrderField)
         */
        default Builder orderOnField(Consumer<QuickResponseOrderField.Builder> orderOnField) {
            return orderOnField(QuickResponseOrderField.builder().applyMutation(orderOnField).build());
        }

        /**
         * <p>
         * The quick response query expressions.
         * </p>
         * 
         * @param queries
         *        The quick response query expressions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queries(Collection<QuickResponseQueryField> queries);

        /**
         * <p>
         * The quick response query expressions.
         * </p>
         * 
         * @param queries
         *        The quick response query expressions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queries(QuickResponseQueryField... queries);

        /**
         * <p>
         * The quick response query expressions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.wisdom.model.QuickResponseQueryField.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.wisdom.model.QuickResponseQueryField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.wisdom.model.QuickResponseQueryField.Builder#build()} is called
         * immediately and its result is passed to {@link #queries(List<QuickResponseQueryField>)}.
         * 
         * @param queries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.wisdom.model.QuickResponseQueryField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queries(java.util.Collection<QuickResponseQueryField>)
         */
        Builder queries(Consumer<QuickResponseQueryField.Builder>... queries);
    }

    static final class BuilderImpl implements Builder {
        private List<QuickResponseFilterField> filters = DefaultSdkAutoConstructList.getInstance();

        private QuickResponseOrderField orderOnField;

        private List<QuickResponseQueryField> queries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(QuickResponseSearchExpression model) {
            filters(model.filters);
            orderOnField(model.orderOnField);
            queries(model.queries);
        }

        public final List<QuickResponseFilterField.Builder> getFilters() {
            List<QuickResponseFilterField.Builder> result = QuickResponseFilterFieldListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<QuickResponseFilterField.BuilderImpl> filters) {
            this.filters = QuickResponseFilterFieldListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<QuickResponseFilterField> filters) {
            this.filters = QuickResponseFilterFieldListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(QuickResponseFilterField... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<QuickResponseFilterField.Builder>... filters) {
            filters(Stream.of(filters).map(c -> QuickResponseFilterField.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final QuickResponseOrderField.Builder getOrderOnField() {
            return orderOnField != null ? orderOnField.toBuilder() : null;
        }

        public final void setOrderOnField(QuickResponseOrderField.BuilderImpl orderOnField) {
            this.orderOnField = orderOnField != null ? orderOnField.build() : null;
        }

        @Override
        public final Builder orderOnField(QuickResponseOrderField orderOnField) {
            this.orderOnField = orderOnField;
            return this;
        }

        public final List<QuickResponseQueryField.Builder> getQueries() {
            List<QuickResponseQueryField.Builder> result = QuickResponseQueryFieldListCopier.copyToBuilder(this.queries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setQueries(Collection<QuickResponseQueryField.BuilderImpl> queries) {
            this.queries = QuickResponseQueryFieldListCopier.copyFromBuilder(queries);
        }

        @Override
        public final Builder queries(Collection<QuickResponseQueryField> queries) {
            this.queries = QuickResponseQueryFieldListCopier.copy(queries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queries(QuickResponseQueryField... queries) {
            queries(Arrays.asList(queries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queries(Consumer<QuickResponseQueryField.Builder>... queries) {
            queries(Stream.of(queries).map(c -> QuickResponseQueryField.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public QuickResponseSearchExpression build() {
            return new QuickResponseSearchExpression(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
