/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wisdom.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information about the knowledge base.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KnowledgeBaseSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<KnowledgeBaseSummary.Builder, KnowledgeBaseSummary> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(KnowledgeBaseSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> KNOWLEDGE_BASE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("knowledgeBaseArn").getter(getter(KnowledgeBaseSummary::knowledgeBaseArn))
            .setter(setter(Builder::knowledgeBaseArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseArn").build()).build();

    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("knowledgeBaseId").getter(getter(KnowledgeBaseSummary::knowledgeBaseId))
            .setter(setter(Builder::knowledgeBaseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseId").build()).build();

    private static final SdkField<String> KNOWLEDGE_BASE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("knowledgeBaseType").getter(getter(KnowledgeBaseSummary::knowledgeBaseTypeAsString))
            .setter(setter(Builder::knowledgeBaseType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseType").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(KnowledgeBaseSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<RenderingConfiguration> RENDERING_CONFIGURATION_FIELD = SdkField
            .<RenderingConfiguration> builder(MarshallingType.SDK_POJO).memberName("renderingConfiguration")
            .getter(getter(KnowledgeBaseSummary::renderingConfiguration)).setter(setter(Builder::renderingConfiguration))
            .constructor(RenderingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("renderingConfiguration").build())
            .build();

    private static final SdkField<ServerSideEncryptionConfiguration> SERVER_SIDE_ENCRYPTION_CONFIGURATION_FIELD = SdkField
            .<ServerSideEncryptionConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("serverSideEncryptionConfiguration")
            .getter(getter(KnowledgeBaseSummary::serverSideEncryptionConfiguration))
            .setter(setter(Builder::serverSideEncryptionConfiguration))
            .constructor(ServerSideEncryptionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverSideEncryptionConfiguration")
                    .build()).build();

    private static final SdkField<SourceConfiguration> SOURCE_CONFIGURATION_FIELD = SdkField
            .<SourceConfiguration> builder(MarshallingType.SDK_POJO).memberName("sourceConfiguration")
            .getter(getter(KnowledgeBaseSummary::sourceConfiguration)).setter(setter(Builder::sourceConfiguration))
            .constructor(SourceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceConfiguration").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(KnowledgeBaseSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(KnowledgeBaseSummary::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            KNOWLEDGE_BASE_ARN_FIELD, KNOWLEDGE_BASE_ID_FIELD, KNOWLEDGE_BASE_TYPE_FIELD, NAME_FIELD,
            RENDERING_CONFIGURATION_FIELD, SERVER_SIDE_ENCRYPTION_CONFIGURATION_FIELD, SOURCE_CONFIGURATION_FIELD, STATUS_FIELD,
            TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String description;

    private final String knowledgeBaseArn;

    private final String knowledgeBaseId;

    private final String knowledgeBaseType;

    private final String name;

    private final RenderingConfiguration renderingConfiguration;

    private final ServerSideEncryptionConfiguration serverSideEncryptionConfiguration;

    private final SourceConfiguration sourceConfiguration;

    private final String status;

    private final Map<String, String> tags;

    private KnowledgeBaseSummary(BuilderImpl builder) {
        this.description = builder.description;
        this.knowledgeBaseArn = builder.knowledgeBaseArn;
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.knowledgeBaseType = builder.knowledgeBaseType;
        this.name = builder.name;
        this.renderingConfiguration = builder.renderingConfiguration;
        this.serverSideEncryptionConfiguration = builder.serverSideEncryptionConfiguration;
        this.sourceConfiguration = builder.sourceConfiguration;
        this.status = builder.status;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The description of the knowledge base.
     * </p>
     * 
     * @return The description of the knowledge base.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the knowledge base.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the knowledge base.
     */
    public final String knowledgeBaseArn() {
        return knowledgeBaseArn;
    }

    /**
     * <p>
     * The identifier of the knowledge base.
     * </p>
     * 
     * @return The identifier of the knowledge base.
     */
    public final String knowledgeBaseId() {
        return knowledgeBaseId;
    }

    /**
     * <p>
     * The type of knowledge base.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #knowledgeBaseType}
     * will return {@link KnowledgeBaseType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #knowledgeBaseTypeAsString}.
     * </p>
     * 
     * @return The type of knowledge base.
     * @see KnowledgeBaseType
     */
    public final KnowledgeBaseType knowledgeBaseType() {
        return KnowledgeBaseType.fromValue(knowledgeBaseType);
    }

    /**
     * <p>
     * The type of knowledge base.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #knowledgeBaseType}
     * will return {@link KnowledgeBaseType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #knowledgeBaseTypeAsString}.
     * </p>
     * 
     * @return The type of knowledge base.
     * @see KnowledgeBaseType
     */
    public final String knowledgeBaseTypeAsString() {
        return knowledgeBaseType;
    }

    /**
     * <p>
     * The name of the knowledge base.
     * </p>
     * 
     * @return The name of the knowledge base.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Information about how to render the content.
     * </p>
     * 
     * @return Information about how to render the content.
     */
    public final RenderingConfiguration renderingConfiguration() {
        return renderingConfiguration;
    }

    /**
     * <p>
     * The configuration information for the customer managed key used for encryption.
     * </p>
     * <p>
     * This KMS key must have a policy that allows <code>kms:CreateGrant</code> and <code>kms:DescribeKey</code>
     * permissions to the IAM identity using the key to invoke Wisdom.
     * </p>
     * <p>
     * For more information about setting up a customer managed key for Wisdom, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/enable-wisdom.html">Enable Amazon Connect Wisdom for
     * your instance</a>.
     * </p>
     * 
     * @return The configuration information for the customer managed key used for encryption. </p>
     *         <p>
     *         This KMS key must have a policy that allows <code>kms:CreateGrant</code> and <code>kms:DescribeKey</code>
     *         permissions to the IAM identity using the key to invoke Wisdom.
     *         </p>
     *         <p>
     *         For more information about setting up a customer managed key for Wisdom, see <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/enable-wisdom.html">Enable Amazon Connect
     *         Wisdom for your instance</a>.
     */
    public final ServerSideEncryptionConfiguration serverSideEncryptionConfiguration() {
        return serverSideEncryptionConfiguration;
    }

    /**
     * <p>
     * Configuration information about the external data source.
     * </p>
     * 
     * @return Configuration information about the external data source.
     */
    public final SourceConfiguration sourceConfiguration() {
        return sourceConfiguration;
    }

    /**
     * <p>
     * The status of the knowledge base summary.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link KnowledgeBaseStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the knowledge base summary.
     * @see KnowledgeBaseStatus
     */
    public final KnowledgeBaseStatus status() {
        return KnowledgeBaseStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the knowledge base summary.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link KnowledgeBaseStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the knowledge base summary.
     * @see KnowledgeBaseStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for this resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags used to organize, track, or control access for this resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseArn());
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(renderingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(serverSideEncryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(sourceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KnowledgeBaseSummary)) {
            return false;
        }
        KnowledgeBaseSummary other = (KnowledgeBaseSummary) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(knowledgeBaseArn(), other.knowledgeBaseArn())
                && Objects.equals(knowledgeBaseId(), other.knowledgeBaseId())
                && Objects.equals(knowledgeBaseTypeAsString(), other.knowledgeBaseTypeAsString())
                && Objects.equals(name(), other.name())
                && Objects.equals(renderingConfiguration(), other.renderingConfiguration())
                && Objects.equals(serverSideEncryptionConfiguration(), other.serverSideEncryptionConfiguration())
                && Objects.equals(sourceConfiguration(), other.sourceConfiguration())
                && Objects.equals(statusAsString(), other.statusAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KnowledgeBaseSummary").add("Description", description())
                .add("KnowledgeBaseArn", knowledgeBaseArn()).add("KnowledgeBaseId", knowledgeBaseId())
                .add("KnowledgeBaseType", knowledgeBaseTypeAsString()).add("Name", name())
                .add("RenderingConfiguration", renderingConfiguration())
                .add("ServerSideEncryptionConfiguration", serverSideEncryptionConfiguration())
                .add("SourceConfiguration", sourceConfiguration()).add("Status", statusAsString())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "knowledgeBaseArn":
            return Optional.ofNullable(clazz.cast(knowledgeBaseArn()));
        case "knowledgeBaseId":
            return Optional.ofNullable(clazz.cast(knowledgeBaseId()));
        case "knowledgeBaseType":
            return Optional.ofNullable(clazz.cast(knowledgeBaseTypeAsString()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "renderingConfiguration":
            return Optional.ofNullable(clazz.cast(renderingConfiguration()));
        case "serverSideEncryptionConfiguration":
            return Optional.ofNullable(clazz.cast(serverSideEncryptionConfiguration()));
        case "sourceConfiguration":
            return Optional.ofNullable(clazz.cast(sourceConfiguration()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KnowledgeBaseSummary, T> g) {
        return obj -> g.apply((KnowledgeBaseSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KnowledgeBaseSummary> {
        /**
         * <p>
         * The description of the knowledge base.
         * </p>
         * 
         * @param description
         *        The description of the knowledge base.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the knowledge base.
         * </p>
         * 
         * @param knowledgeBaseArn
         *        The Amazon Resource Name (ARN) of the knowledge base.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseArn(String knowledgeBaseArn);

        /**
         * <p>
         * The identifier of the knowledge base.
         * </p>
         * 
         * @param knowledgeBaseId
         *        The identifier of the knowledge base.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseId(String knowledgeBaseId);

        /**
         * <p>
         * The type of knowledge base.
         * </p>
         * 
         * @param knowledgeBaseType
         *        The type of knowledge base.
         * @see KnowledgeBaseType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KnowledgeBaseType
         */
        Builder knowledgeBaseType(String knowledgeBaseType);

        /**
         * <p>
         * The type of knowledge base.
         * </p>
         * 
         * @param knowledgeBaseType
         *        The type of knowledge base.
         * @see KnowledgeBaseType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KnowledgeBaseType
         */
        Builder knowledgeBaseType(KnowledgeBaseType knowledgeBaseType);

        /**
         * <p>
         * The name of the knowledge base.
         * </p>
         * 
         * @param name
         *        The name of the knowledge base.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Information about how to render the content.
         * </p>
         * 
         * @param renderingConfiguration
         *        Information about how to render the content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder renderingConfiguration(RenderingConfiguration renderingConfiguration);

        /**
         * <p>
         * Information about how to render the content.
         * </p>
         * This is a convenience method that creates an instance of the {@link RenderingConfiguration.Builder} avoiding
         * the need to create one manually via {@link RenderingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RenderingConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #renderingConfiguration(RenderingConfiguration)}.
         * 
         * @param renderingConfiguration
         *        a consumer that will call methods on {@link RenderingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #renderingConfiguration(RenderingConfiguration)
         */
        default Builder renderingConfiguration(Consumer<RenderingConfiguration.Builder> renderingConfiguration) {
            return renderingConfiguration(RenderingConfiguration.builder().applyMutation(renderingConfiguration).build());
        }

        /**
         * <p>
         * The configuration information for the customer managed key used for encryption.
         * </p>
         * <p>
         * This KMS key must have a policy that allows <code>kms:CreateGrant</code> and <code>kms:DescribeKey</code>
         * permissions to the IAM identity using the key to invoke Wisdom.
         * </p>
         * <p>
         * For more information about setting up a customer managed key for Wisdom, see <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/enable-wisdom.html">Enable Amazon Connect Wisdom
         * for your instance</a>.
         * </p>
         * 
         * @param serverSideEncryptionConfiguration
         *        The configuration information for the customer managed key used for encryption. </p>
         *        <p>
         *        This KMS key must have a policy that allows <code>kms:CreateGrant</code> and
         *        <code>kms:DescribeKey</code> permissions to the IAM identity using the key to invoke Wisdom.
         *        </p>
         *        <p>
         *        For more information about setting up a customer managed key for Wisdom, see <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/enable-wisdom.html">Enable Amazon Connect
         *        Wisdom for your instance</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration serverSideEncryptionConfiguration);

        /**
         * <p>
         * The configuration information for the customer managed key used for encryption.
         * </p>
         * <p>
         * This KMS key must have a policy that allows <code>kms:CreateGrant</code> and <code>kms:DescribeKey</code>
         * permissions to the IAM identity using the key to invoke Wisdom.
         * </p>
         * <p>
         * For more information about setting up a customer managed key for Wisdom, see <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/enable-wisdom.html">Enable Amazon Connect Wisdom
         * for your instance</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ServerSideEncryptionConfiguration.Builder} avoiding the need to create one manually via
         * {@link ServerSideEncryptionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServerSideEncryptionConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration)}.
         * 
         * @param serverSideEncryptionConfiguration
         *        a consumer that will call methods on {@link ServerSideEncryptionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration)
         */
        default Builder serverSideEncryptionConfiguration(
                Consumer<ServerSideEncryptionConfiguration.Builder> serverSideEncryptionConfiguration) {
            return serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration.builder()
                    .applyMutation(serverSideEncryptionConfiguration).build());
        }

        /**
         * <p>
         * Configuration information about the external data source.
         * </p>
         * 
         * @param sourceConfiguration
         *        Configuration information about the external data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceConfiguration(SourceConfiguration sourceConfiguration);

        /**
         * <p>
         * Configuration information about the external data source.
         * </p>
         * This is a convenience method that creates an instance of the {@link SourceConfiguration.Builder} avoiding the
         * need to create one manually via {@link SourceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SourceConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #sourceConfiguration(SourceConfiguration)}.
         * 
         * @param sourceConfiguration
         *        a consumer that will call methods on {@link SourceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceConfiguration(SourceConfiguration)
         */
        default Builder sourceConfiguration(Consumer<SourceConfiguration.Builder> sourceConfiguration) {
            return sourceConfiguration(SourceConfiguration.builder().applyMutation(sourceConfiguration).build());
        }

        /**
         * <p>
         * The status of the knowledge base summary.
         * </p>
         * 
         * @param status
         *        The status of the knowledge base summary.
         * @see KnowledgeBaseStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KnowledgeBaseStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the knowledge base summary.
         * </p>
         * 
         * @param status
         *        The status of the knowledge base summary.
         * @see KnowledgeBaseStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KnowledgeBaseStatus
         */
        Builder status(KnowledgeBaseStatus status);

        /**
         * <p>
         * The tags used to organize, track, or control access for this resource.
         * </p>
         * 
         * @param tags
         *        The tags used to organize, track, or control access for this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private String knowledgeBaseArn;

        private String knowledgeBaseId;

        private String knowledgeBaseType;

        private String name;

        private RenderingConfiguration renderingConfiguration;

        private ServerSideEncryptionConfiguration serverSideEncryptionConfiguration;

        private SourceConfiguration sourceConfiguration;

        private String status;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(KnowledgeBaseSummary model) {
            description(model.description);
            knowledgeBaseArn(model.knowledgeBaseArn);
            knowledgeBaseId(model.knowledgeBaseId);
            knowledgeBaseType(model.knowledgeBaseType);
            name(model.name);
            renderingConfiguration(model.renderingConfiguration);
            serverSideEncryptionConfiguration(model.serverSideEncryptionConfiguration);
            sourceConfiguration(model.sourceConfiguration);
            status(model.status);
            tags(model.tags);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getKnowledgeBaseArn() {
            return knowledgeBaseArn;
        }

        public final void setKnowledgeBaseArn(String knowledgeBaseArn) {
            this.knowledgeBaseArn = knowledgeBaseArn;
        }

        @Override
        public final Builder knowledgeBaseArn(String knowledgeBaseArn) {
            this.knowledgeBaseArn = knowledgeBaseArn;
            return this;
        }

        public final String getKnowledgeBaseId() {
            return knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final String getKnowledgeBaseType() {
            return knowledgeBaseType;
        }

        public final void setKnowledgeBaseType(String knowledgeBaseType) {
            this.knowledgeBaseType = knowledgeBaseType;
        }

        @Override
        public final Builder knowledgeBaseType(String knowledgeBaseType) {
            this.knowledgeBaseType = knowledgeBaseType;
            return this;
        }

        @Override
        public final Builder knowledgeBaseType(KnowledgeBaseType knowledgeBaseType) {
            this.knowledgeBaseType(knowledgeBaseType == null ? null : knowledgeBaseType.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final RenderingConfiguration.Builder getRenderingConfiguration() {
            return renderingConfiguration != null ? renderingConfiguration.toBuilder() : null;
        }

        public final void setRenderingConfiguration(RenderingConfiguration.BuilderImpl renderingConfiguration) {
            this.renderingConfiguration = renderingConfiguration != null ? renderingConfiguration.build() : null;
        }

        @Override
        public final Builder renderingConfiguration(RenderingConfiguration renderingConfiguration) {
            this.renderingConfiguration = renderingConfiguration;
            return this;
        }

        public final ServerSideEncryptionConfiguration.Builder getServerSideEncryptionConfiguration() {
            return serverSideEncryptionConfiguration != null ? serverSideEncryptionConfiguration.toBuilder() : null;
        }

        public final void setServerSideEncryptionConfiguration(
                ServerSideEncryptionConfiguration.BuilderImpl serverSideEncryptionConfiguration) {
            this.serverSideEncryptionConfiguration = serverSideEncryptionConfiguration != null ? serverSideEncryptionConfiguration
                    .build() : null;
        }

        @Override
        public final Builder serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration serverSideEncryptionConfiguration) {
            this.serverSideEncryptionConfiguration = serverSideEncryptionConfiguration;
            return this;
        }

        public final SourceConfiguration.Builder getSourceConfiguration() {
            return sourceConfiguration != null ? sourceConfiguration.toBuilder() : null;
        }

        public final void setSourceConfiguration(SourceConfiguration.BuilderImpl sourceConfiguration) {
            this.sourceConfiguration = sourceConfiguration != null ? sourceConfiguration.build() : null;
        }

        @Override
        public final Builder sourceConfiguration(SourceConfiguration sourceConfiguration) {
            this.sourceConfiguration = sourceConfiguration;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(KnowledgeBaseStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public KnowledgeBaseSummary build() {
            return new KnowledgeBaseSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
