/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wisdom.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.wisdom.WisdomClient;
import software.amazon.awssdk.services.wisdom.model.AssistantAssociationSummary;
import software.amazon.awssdk.services.wisdom.model.ListAssistantAssociationsRequest;
import software.amazon.awssdk.services.wisdom.model.ListAssistantAssociationsResponse;

public class ListAssistantAssociationsIterable
implements SdkIterable<ListAssistantAssociationsResponse> {
    private final WisdomClient client;
    private final ListAssistantAssociationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAssistantAssociationsIterable(WisdomClient client, ListAssistantAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAssistantAssociationsResponseFetcher();
    }

    public Iterator<ListAssistantAssociationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AssistantAssociationSummary> assistantAssociationSummaries() {
        Function<ListAssistantAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.assistantAssociationSummaries() != null) {
                return response.assistantAssociationSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAssistantAssociationsResponseFetcher
    implements SyncPageFetcher<ListAssistantAssociationsResponse> {
        private ListAssistantAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListAssistantAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAssistantAssociationsResponse nextPage(ListAssistantAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListAssistantAssociationsIterable.this.client.listAssistantAssociations(ListAssistantAssociationsIterable.this.firstRequest);
            }
            return ListAssistantAssociationsIterable.this.client.listAssistantAssociations((ListAssistantAssociationsRequest)((Object)ListAssistantAssociationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

