/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wisdom;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.wisdom.DefaultWisdomClientBuilder;
import software.amazon.awssdk.services.wisdom.WisdomClientBuilder;
import software.amazon.awssdk.services.wisdom.model.AccessDeniedException;
import software.amazon.awssdk.services.wisdom.model.ConflictException;
import software.amazon.awssdk.services.wisdom.model.CreateAssistantAssociationRequest;
import software.amazon.awssdk.services.wisdom.model.CreateAssistantAssociationResponse;
import software.amazon.awssdk.services.wisdom.model.CreateAssistantRequest;
import software.amazon.awssdk.services.wisdom.model.CreateAssistantResponse;
import software.amazon.awssdk.services.wisdom.model.CreateContentRequest;
import software.amazon.awssdk.services.wisdom.model.CreateContentResponse;
import software.amazon.awssdk.services.wisdom.model.CreateKnowledgeBaseRequest;
import software.amazon.awssdk.services.wisdom.model.CreateKnowledgeBaseResponse;
import software.amazon.awssdk.services.wisdom.model.CreateSessionRequest;
import software.amazon.awssdk.services.wisdom.model.CreateSessionResponse;
import software.amazon.awssdk.services.wisdom.model.DeleteAssistantAssociationRequest;
import software.amazon.awssdk.services.wisdom.model.DeleteAssistantAssociationResponse;
import software.amazon.awssdk.services.wisdom.model.DeleteAssistantRequest;
import software.amazon.awssdk.services.wisdom.model.DeleteAssistantResponse;
import software.amazon.awssdk.services.wisdom.model.DeleteContentRequest;
import software.amazon.awssdk.services.wisdom.model.DeleteContentResponse;
import software.amazon.awssdk.services.wisdom.model.DeleteKnowledgeBaseRequest;
import software.amazon.awssdk.services.wisdom.model.DeleteKnowledgeBaseResponse;
import software.amazon.awssdk.services.wisdom.model.GetAssistantAssociationRequest;
import software.amazon.awssdk.services.wisdom.model.GetAssistantAssociationResponse;
import software.amazon.awssdk.services.wisdom.model.GetAssistantRequest;
import software.amazon.awssdk.services.wisdom.model.GetAssistantResponse;
import software.amazon.awssdk.services.wisdom.model.GetContentRequest;
import software.amazon.awssdk.services.wisdom.model.GetContentResponse;
import software.amazon.awssdk.services.wisdom.model.GetContentSummaryRequest;
import software.amazon.awssdk.services.wisdom.model.GetContentSummaryResponse;
import software.amazon.awssdk.services.wisdom.model.GetKnowledgeBaseRequest;
import software.amazon.awssdk.services.wisdom.model.GetKnowledgeBaseResponse;
import software.amazon.awssdk.services.wisdom.model.GetRecommendationsRequest;
import software.amazon.awssdk.services.wisdom.model.GetRecommendationsResponse;
import software.amazon.awssdk.services.wisdom.model.GetSessionRequest;
import software.amazon.awssdk.services.wisdom.model.GetSessionResponse;
import software.amazon.awssdk.services.wisdom.model.ListAssistantAssociationsRequest;
import software.amazon.awssdk.services.wisdom.model.ListAssistantAssociationsResponse;
import software.amazon.awssdk.services.wisdom.model.ListAssistantsRequest;
import software.amazon.awssdk.services.wisdom.model.ListAssistantsResponse;
import software.amazon.awssdk.services.wisdom.model.ListContentsRequest;
import software.amazon.awssdk.services.wisdom.model.ListContentsResponse;
import software.amazon.awssdk.services.wisdom.model.ListKnowledgeBasesRequest;
import software.amazon.awssdk.services.wisdom.model.ListKnowledgeBasesResponse;
import software.amazon.awssdk.services.wisdom.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.wisdom.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.wisdom.model.NotifyRecommendationsReceivedRequest;
import software.amazon.awssdk.services.wisdom.model.NotifyRecommendationsReceivedResponse;
import software.amazon.awssdk.services.wisdom.model.PreconditionFailedException;
import software.amazon.awssdk.services.wisdom.model.PutFeedbackRequest;
import software.amazon.awssdk.services.wisdom.model.PutFeedbackResponse;
import software.amazon.awssdk.services.wisdom.model.QueryAssistantRequest;
import software.amazon.awssdk.services.wisdom.model.QueryAssistantResponse;
import software.amazon.awssdk.services.wisdom.model.RemoveKnowledgeBaseTemplateUriRequest;
import software.amazon.awssdk.services.wisdom.model.RemoveKnowledgeBaseTemplateUriResponse;
import software.amazon.awssdk.services.wisdom.model.ResourceNotFoundException;
import software.amazon.awssdk.services.wisdom.model.SearchContentRequest;
import software.amazon.awssdk.services.wisdom.model.SearchContentResponse;
import software.amazon.awssdk.services.wisdom.model.SearchSessionsRequest;
import software.amazon.awssdk.services.wisdom.model.SearchSessionsResponse;
import software.amazon.awssdk.services.wisdom.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.wisdom.model.StartContentUploadRequest;
import software.amazon.awssdk.services.wisdom.model.StartContentUploadResponse;
import software.amazon.awssdk.services.wisdom.model.TagResourceRequest;
import software.amazon.awssdk.services.wisdom.model.TagResourceResponse;
import software.amazon.awssdk.services.wisdom.model.TooManyTagsException;
import software.amazon.awssdk.services.wisdom.model.UntagResourceRequest;
import software.amazon.awssdk.services.wisdom.model.UntagResourceResponse;
import software.amazon.awssdk.services.wisdom.model.UpdateContentRequest;
import software.amazon.awssdk.services.wisdom.model.UpdateContentResponse;
import software.amazon.awssdk.services.wisdom.model.UpdateKnowledgeBaseTemplateUriRequest;
import software.amazon.awssdk.services.wisdom.model.UpdateKnowledgeBaseTemplateUriResponse;
import software.amazon.awssdk.services.wisdom.model.ValidationException;
import software.amazon.awssdk.services.wisdom.model.WisdomException;
import software.amazon.awssdk.services.wisdom.paginators.ListAssistantAssociationsIterable;
import software.amazon.awssdk.services.wisdom.paginators.ListAssistantsIterable;
import software.amazon.awssdk.services.wisdom.paginators.ListContentsIterable;
import software.amazon.awssdk.services.wisdom.paginators.ListKnowledgeBasesIterable;
import software.amazon.awssdk.services.wisdom.paginators.QueryAssistantIterable;
import software.amazon.awssdk.services.wisdom.paginators.SearchContentIterable;
import software.amazon.awssdk.services.wisdom.paginators.SearchSessionsIterable;

@SdkPublicApi
@ThreadSafe
public interface WisdomClient
extends SdkClient {
    public static final String SERVICE_NAME = "wisdom";
    public static final String SERVICE_METADATA_ID = "wisdom";

    public static WisdomClient create() {
        return (WisdomClient)WisdomClient.builder().build();
    }

    public static WisdomClientBuilder builder() {
        return new DefaultWisdomClientBuilder();
    }

    default public CreateAssistantResponse createAssistant(CreateAssistantRequest createAssistantRequest) throws ConflictException, ValidationException, ServiceQuotaExceededException, AccessDeniedException, AwsServiceException, SdkClientException, WisdomException {
        throw new UnsupportedOperationException();
    }

    default public CreateAssistantResponse createAssistant(Consumer<CreateAssistantRequest.Builder> createAssistantRequest) throws ConflictException, ValidationException, ServiceQuotaExceededException, AccessDeniedException, AwsServiceException, SdkClientException, WisdomException {
        return this.createAssistant((CreateAssistantRequest)((Object)((CreateAssistantRequest.Builder)CreateAssistantRequest.builder().applyMutation(createAssistantRequest)).build()));
    }

    default public CreateAssistantAssociationResponse createAssistantAssociation(CreateAssistantAssociationRequest createAssistantAssociationRequest) throws ConflictException, ValidationException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        throw new UnsupportedOperationException();
    }

    default public CreateAssistantAssociationResponse createAssistantAssociation(Consumer<CreateAssistantAssociationRequest.Builder> createAssistantAssociationRequest) throws ConflictException, ValidationException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        return this.createAssistantAssociation((CreateAssistantAssociationRequest)((Object)((CreateAssistantAssociationRequest.Builder)CreateAssistantAssociationRequest.builder().applyMutation(createAssistantAssociationRequest)).build()));
    }

    default public CreateContentResponse createContent(CreateContentRequest createContentRequest) throws ConflictException, ValidationException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        throw new UnsupportedOperationException();
    }

    default public CreateContentResponse createContent(Consumer<CreateContentRequest.Builder> createContentRequest) throws ConflictException, ValidationException, ServiceQuotaExceededException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        return this.createContent((CreateContentRequest)((Object)((CreateContentRequest.Builder)CreateContentRequest.builder().applyMutation(createContentRequest)).build()));
    }

    default public CreateKnowledgeBaseResponse createKnowledgeBase(CreateKnowledgeBaseRequest createKnowledgeBaseRequest) throws ConflictException, ValidationException, ServiceQuotaExceededException, AccessDeniedException, AwsServiceException, SdkClientException, WisdomException {
        throw new UnsupportedOperationException();
    }

    default public CreateKnowledgeBaseResponse createKnowledgeBase(Consumer<CreateKnowledgeBaseRequest.Builder> createKnowledgeBaseRequest) throws ConflictException, ValidationException, ServiceQuotaExceededException, AccessDeniedException, AwsServiceException, SdkClientException, WisdomException {
        return this.createKnowledgeBase((CreateKnowledgeBaseRequest)((Object)((CreateKnowledgeBaseRequest.Builder)CreateKnowledgeBaseRequest.builder().applyMutation(createKnowledgeBaseRequest)).build()));
    }

    default public CreateSessionResponse createSession(CreateSessionRequest createSessionRequest) throws ConflictException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        throw new UnsupportedOperationException();
    }

    default public CreateSessionResponse createSession(Consumer<CreateSessionRequest.Builder> createSessionRequest) throws ConflictException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        return this.createSession((CreateSessionRequest)((Object)((CreateSessionRequest.Builder)CreateSessionRequest.builder().applyMutation(createSessionRequest)).build()));
    }

    default public DeleteAssistantResponse deleteAssistant(DeleteAssistantRequest deleteAssistantRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        throw new UnsupportedOperationException();
    }

    default public DeleteAssistantResponse deleteAssistant(Consumer<DeleteAssistantRequest.Builder> deleteAssistantRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        return this.deleteAssistant((DeleteAssistantRequest)((Object)((DeleteAssistantRequest.Builder)DeleteAssistantRequest.builder().applyMutation(deleteAssistantRequest)).build()));
    }

    default public DeleteAssistantAssociationResponse deleteAssistantAssociation(DeleteAssistantAssociationRequest deleteAssistantAssociationRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        throw new UnsupportedOperationException();
    }

    default public DeleteAssistantAssociationResponse deleteAssistantAssociation(Consumer<DeleteAssistantAssociationRequest.Builder> deleteAssistantAssociationRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        return this.deleteAssistantAssociation((DeleteAssistantAssociationRequest)((Object)((DeleteAssistantAssociationRequest.Builder)DeleteAssistantAssociationRequest.builder().applyMutation(deleteAssistantAssociationRequest)).build()));
    }

    default public DeleteContentResponse deleteContent(DeleteContentRequest deleteContentRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        throw new UnsupportedOperationException();
    }

    default public DeleteContentResponse deleteContent(Consumer<DeleteContentRequest.Builder> deleteContentRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        return this.deleteContent((DeleteContentRequest)((Object)((DeleteContentRequest.Builder)DeleteContentRequest.builder().applyMutation(deleteContentRequest)).build()));
    }

    default public DeleteKnowledgeBaseResponse deleteKnowledgeBase(DeleteKnowledgeBaseRequest deleteKnowledgeBaseRequest) throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        throw new UnsupportedOperationException();
    }

    default public DeleteKnowledgeBaseResponse deleteKnowledgeBase(Consumer<DeleteKnowledgeBaseRequest.Builder> deleteKnowledgeBaseRequest) throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        return this.deleteKnowledgeBase((DeleteKnowledgeBaseRequest)((Object)((DeleteKnowledgeBaseRequest.Builder)DeleteKnowledgeBaseRequest.builder().applyMutation(deleteKnowledgeBaseRequest)).build()));
    }

    default public GetAssistantResponse getAssistant(GetAssistantRequest getAssistantRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        throw new UnsupportedOperationException();
    }

    default public GetAssistantResponse getAssistant(Consumer<GetAssistantRequest.Builder> getAssistantRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        return this.getAssistant((GetAssistantRequest)((Object)((GetAssistantRequest.Builder)GetAssistantRequest.builder().applyMutation(getAssistantRequest)).build()));
    }

    default public GetAssistantAssociationResponse getAssistantAssociation(GetAssistantAssociationRequest getAssistantAssociationRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        throw new UnsupportedOperationException();
    }

    default public GetAssistantAssociationResponse getAssistantAssociation(Consumer<GetAssistantAssociationRequest.Builder> getAssistantAssociationRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        return this.getAssistantAssociation((GetAssistantAssociationRequest)((Object)((GetAssistantAssociationRequest.Builder)GetAssistantAssociationRequest.builder().applyMutation(getAssistantAssociationRequest)).build()));
    }

    default public GetContentResponse getContent(GetContentRequest getContentRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        throw new UnsupportedOperationException();
    }

    default public GetContentResponse getContent(Consumer<GetContentRequest.Builder> getContentRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        return this.getContent((GetContentRequest)((Object)((GetContentRequest.Builder)GetContentRequest.builder().applyMutation(getContentRequest)).build()));
    }

    default public GetContentSummaryResponse getContentSummary(GetContentSummaryRequest getContentSummaryRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        throw new UnsupportedOperationException();
    }

    default public GetContentSummaryResponse getContentSummary(Consumer<GetContentSummaryRequest.Builder> getContentSummaryRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        return this.getContentSummary((GetContentSummaryRequest)((Object)((GetContentSummaryRequest.Builder)GetContentSummaryRequest.builder().applyMutation(getContentSummaryRequest)).build()));
    }

    default public GetKnowledgeBaseResponse getKnowledgeBase(GetKnowledgeBaseRequest getKnowledgeBaseRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        throw new UnsupportedOperationException();
    }

    default public GetKnowledgeBaseResponse getKnowledgeBase(Consumer<GetKnowledgeBaseRequest.Builder> getKnowledgeBaseRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        return this.getKnowledgeBase((GetKnowledgeBaseRequest)((Object)((GetKnowledgeBaseRequest.Builder)GetKnowledgeBaseRequest.builder().applyMutation(getKnowledgeBaseRequest)).build()));
    }

    default public GetRecommendationsResponse getRecommendations(GetRecommendationsRequest getRecommendationsRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        throw new UnsupportedOperationException();
    }

    default public GetRecommendationsResponse getRecommendations(Consumer<GetRecommendationsRequest.Builder> getRecommendationsRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        return this.getRecommendations((GetRecommendationsRequest)((Object)((GetRecommendationsRequest.Builder)GetRecommendationsRequest.builder().applyMutation(getRecommendationsRequest)).build()));
    }

    default public GetSessionResponse getSession(GetSessionRequest getSessionRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        throw new UnsupportedOperationException();
    }

    default public GetSessionResponse getSession(Consumer<GetSessionRequest.Builder> getSessionRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        return this.getSession((GetSessionRequest)((Object)((GetSessionRequest.Builder)GetSessionRequest.builder().applyMutation(getSessionRequest)).build()));
    }

    default public ListAssistantAssociationsResponse listAssistantAssociations(ListAssistantAssociationsRequest listAssistantAssociationsRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        throw new UnsupportedOperationException();
    }

    default public ListAssistantAssociationsResponse listAssistantAssociations(Consumer<ListAssistantAssociationsRequest.Builder> listAssistantAssociationsRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        return this.listAssistantAssociations((ListAssistantAssociationsRequest)((Object)((ListAssistantAssociationsRequest.Builder)ListAssistantAssociationsRequest.builder().applyMutation(listAssistantAssociationsRequest)).build()));
    }

    default public ListAssistantAssociationsIterable listAssistantAssociationsPaginator(ListAssistantAssociationsRequest listAssistantAssociationsRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        throw new UnsupportedOperationException();
    }

    default public ListAssistantAssociationsIterable listAssistantAssociationsPaginator(Consumer<ListAssistantAssociationsRequest.Builder> listAssistantAssociationsRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        return this.listAssistantAssociationsPaginator((ListAssistantAssociationsRequest)((Object)((ListAssistantAssociationsRequest.Builder)ListAssistantAssociationsRequest.builder().applyMutation(listAssistantAssociationsRequest)).build()));
    }

    default public ListAssistantsResponse listAssistants(ListAssistantsRequest listAssistantsRequest) throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, WisdomException {
        throw new UnsupportedOperationException();
    }

    default public ListAssistantsResponse listAssistants(Consumer<ListAssistantsRequest.Builder> listAssistantsRequest) throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, WisdomException {
        return this.listAssistants((ListAssistantsRequest)((Object)((ListAssistantsRequest.Builder)ListAssistantsRequest.builder().applyMutation(listAssistantsRequest)).build()));
    }

    default public ListAssistantsIterable listAssistantsPaginator(ListAssistantsRequest listAssistantsRequest) throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, WisdomException {
        throw new UnsupportedOperationException();
    }

    default public ListAssistantsIterable listAssistantsPaginator(Consumer<ListAssistantsRequest.Builder> listAssistantsRequest) throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, WisdomException {
        return this.listAssistantsPaginator((ListAssistantsRequest)((Object)((ListAssistantsRequest.Builder)ListAssistantsRequest.builder().applyMutation(listAssistantsRequest)).build()));
    }

    default public ListContentsResponse listContents(ListContentsRequest listContentsRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        throw new UnsupportedOperationException();
    }

    default public ListContentsResponse listContents(Consumer<ListContentsRequest.Builder> listContentsRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        return this.listContents((ListContentsRequest)((Object)((ListContentsRequest.Builder)ListContentsRequest.builder().applyMutation(listContentsRequest)).build()));
    }

    default public ListContentsIterable listContentsPaginator(ListContentsRequest listContentsRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        throw new UnsupportedOperationException();
    }

    default public ListContentsIterable listContentsPaginator(Consumer<ListContentsRequest.Builder> listContentsRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        return this.listContentsPaginator((ListContentsRequest)((Object)((ListContentsRequest.Builder)ListContentsRequest.builder().applyMutation(listContentsRequest)).build()));
    }

    default public ListKnowledgeBasesResponse listKnowledgeBases(ListKnowledgeBasesRequest listKnowledgeBasesRequest) throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, WisdomException {
        throw new UnsupportedOperationException();
    }

    default public ListKnowledgeBasesResponse listKnowledgeBases(Consumer<ListKnowledgeBasesRequest.Builder> listKnowledgeBasesRequest) throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, WisdomException {
        return this.listKnowledgeBases((ListKnowledgeBasesRequest)((Object)((ListKnowledgeBasesRequest.Builder)ListKnowledgeBasesRequest.builder().applyMutation(listKnowledgeBasesRequest)).build()));
    }

    default public ListKnowledgeBasesIterable listKnowledgeBasesPaginator(ListKnowledgeBasesRequest listKnowledgeBasesRequest) throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, WisdomException {
        throw new UnsupportedOperationException();
    }

    default public ListKnowledgeBasesIterable listKnowledgeBasesPaginator(Consumer<ListKnowledgeBasesRequest.Builder> listKnowledgeBasesRequest) throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, WisdomException {
        return this.listKnowledgeBasesPaginator((ListKnowledgeBasesRequest)((Object)((ListKnowledgeBasesRequest.Builder)ListKnowledgeBasesRequest.builder().applyMutation(listKnowledgeBasesRequest)).build()));
    }

    default public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        throw new UnsupportedOperationException();
    }

    default public ListTagsForResourceResponse listTagsForResource(Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        return this.listTagsForResource((ListTagsForResourceRequest)((Object)((ListTagsForResourceRequest.Builder)ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)).build()));
    }

    default public NotifyRecommendationsReceivedResponse notifyRecommendationsReceived(NotifyRecommendationsReceivedRequest notifyRecommendationsReceivedRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        throw new UnsupportedOperationException();
    }

    default public NotifyRecommendationsReceivedResponse notifyRecommendationsReceived(Consumer<NotifyRecommendationsReceivedRequest.Builder> notifyRecommendationsReceivedRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        return this.notifyRecommendationsReceived((NotifyRecommendationsReceivedRequest)((Object)((NotifyRecommendationsReceivedRequest.Builder)NotifyRecommendationsReceivedRequest.builder().applyMutation(notifyRecommendationsReceivedRequest)).build()));
    }

    default public PutFeedbackResponse putFeedback(PutFeedbackRequest putFeedbackRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        throw new UnsupportedOperationException();
    }

    default public PutFeedbackResponse putFeedback(Consumer<PutFeedbackRequest.Builder> putFeedbackRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        return this.putFeedback((PutFeedbackRequest)((Object)((PutFeedbackRequest.Builder)PutFeedbackRequest.builder().applyMutation(putFeedbackRequest)).build()));
    }

    default public QueryAssistantResponse queryAssistant(QueryAssistantRequest queryAssistantRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        throw new UnsupportedOperationException();
    }

    default public QueryAssistantResponse queryAssistant(Consumer<QueryAssistantRequest.Builder> queryAssistantRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        return this.queryAssistant((QueryAssistantRequest)((Object)((QueryAssistantRequest.Builder)QueryAssistantRequest.builder().applyMutation(queryAssistantRequest)).build()));
    }

    default public QueryAssistantIterable queryAssistantPaginator(QueryAssistantRequest queryAssistantRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        throw new UnsupportedOperationException();
    }

    default public QueryAssistantIterable queryAssistantPaginator(Consumer<QueryAssistantRequest.Builder> queryAssistantRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        return this.queryAssistantPaginator((QueryAssistantRequest)((Object)((QueryAssistantRequest.Builder)QueryAssistantRequest.builder().applyMutation(queryAssistantRequest)).build()));
    }

    default public RemoveKnowledgeBaseTemplateUriResponse removeKnowledgeBaseTemplateUri(RemoveKnowledgeBaseTemplateUriRequest removeKnowledgeBaseTemplateUriRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        throw new UnsupportedOperationException();
    }

    default public RemoveKnowledgeBaseTemplateUriResponse removeKnowledgeBaseTemplateUri(Consumer<RemoveKnowledgeBaseTemplateUriRequest.Builder> removeKnowledgeBaseTemplateUriRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        return this.removeKnowledgeBaseTemplateUri((RemoveKnowledgeBaseTemplateUriRequest)((Object)((RemoveKnowledgeBaseTemplateUriRequest.Builder)RemoveKnowledgeBaseTemplateUriRequest.builder().applyMutation(removeKnowledgeBaseTemplateUriRequest)).build()));
    }

    default public SearchContentResponse searchContent(SearchContentRequest searchContentRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        throw new UnsupportedOperationException();
    }

    default public SearchContentResponse searchContent(Consumer<SearchContentRequest.Builder> searchContentRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        return this.searchContent((SearchContentRequest)((Object)((SearchContentRequest.Builder)SearchContentRequest.builder().applyMutation(searchContentRequest)).build()));
    }

    default public SearchContentIterable searchContentPaginator(SearchContentRequest searchContentRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        throw new UnsupportedOperationException();
    }

    default public SearchContentIterable searchContentPaginator(Consumer<SearchContentRequest.Builder> searchContentRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        return this.searchContentPaginator((SearchContentRequest)((Object)((SearchContentRequest.Builder)SearchContentRequest.builder().applyMutation(searchContentRequest)).build()));
    }

    default public SearchSessionsResponse searchSessions(SearchSessionsRequest searchSessionsRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        throw new UnsupportedOperationException();
    }

    default public SearchSessionsResponse searchSessions(Consumer<SearchSessionsRequest.Builder> searchSessionsRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        return this.searchSessions((SearchSessionsRequest)((Object)((SearchSessionsRequest.Builder)SearchSessionsRequest.builder().applyMutation(searchSessionsRequest)).build()));
    }

    default public SearchSessionsIterable searchSessionsPaginator(SearchSessionsRequest searchSessionsRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        throw new UnsupportedOperationException();
    }

    default public SearchSessionsIterable searchSessionsPaginator(Consumer<SearchSessionsRequest.Builder> searchSessionsRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        return this.searchSessionsPaginator((SearchSessionsRequest)((Object)((SearchSessionsRequest.Builder)SearchSessionsRequest.builder().applyMutation(searchSessionsRequest)).build()));
    }

    default public StartContentUploadResponse startContentUpload(StartContentUploadRequest startContentUploadRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        throw new UnsupportedOperationException();
    }

    default public StartContentUploadResponse startContentUpload(Consumer<StartContentUploadRequest.Builder> startContentUploadRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        return this.startContentUpload((StartContentUploadRequest)((Object)((StartContentUploadRequest.Builder)StartContentUploadRequest.builder().applyMutation(startContentUploadRequest)).build()));
    }

    default public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws TooManyTagsException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        throw new UnsupportedOperationException();
    }

    default public TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws TooManyTagsException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        return this.tagResource((TagResourceRequest)((Object)((TagResourceRequest.Builder)TagResourceRequest.builder().applyMutation(tagResourceRequest)).build()));
    }

    default public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        throw new UnsupportedOperationException();
    }

    default public UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        return this.untagResource((UntagResourceRequest)((Object)((UntagResourceRequest.Builder)UntagResourceRequest.builder().applyMutation(untagResourceRequest)).build()));
    }

    default public UpdateContentResponse updateContent(UpdateContentRequest updateContentRequest) throws ValidationException, AccessDeniedException, PreconditionFailedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        throw new UnsupportedOperationException();
    }

    default public UpdateContentResponse updateContent(Consumer<UpdateContentRequest.Builder> updateContentRequest) throws ValidationException, AccessDeniedException, PreconditionFailedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        return this.updateContent((UpdateContentRequest)((Object)((UpdateContentRequest.Builder)UpdateContentRequest.builder().applyMutation(updateContentRequest)).build()));
    }

    default public UpdateKnowledgeBaseTemplateUriResponse updateKnowledgeBaseTemplateUri(UpdateKnowledgeBaseTemplateUriRequest updateKnowledgeBaseTemplateUriRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        throw new UnsupportedOperationException();
    }

    default public UpdateKnowledgeBaseTemplateUriResponse updateKnowledgeBaseTemplateUri(Consumer<UpdateKnowledgeBaseTemplateUriRequest.Builder> updateKnowledgeBaseTemplateUriRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, WisdomException {
        return this.updateKnowledgeBaseTemplateUri((UpdateKnowledgeBaseTemplateUriRequest)((Object)((UpdateKnowledgeBaseTemplateUriRequest.Builder)UpdateKnowledgeBaseTemplateUriRequest.builder().applyMutation(updateKnowledgeBaseTemplateUriRequest)).build()));
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)"wisdom");
    }
}

