/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.wellarchitected.WellArchitectedAsyncClient;
import software.amazon.awssdk.services.wellarchitected.model.ListLensSharesRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListLensSharesResponse;

public class ListLensSharesPublisher
implements SdkPublisher<ListLensSharesResponse> {
    private final WellArchitectedAsyncClient client;
    private final ListLensSharesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListLensSharesPublisher(WellArchitectedAsyncClient client, ListLensSharesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListLensSharesPublisher(WellArchitectedAsyncClient client, ListLensSharesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListLensSharesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListLensSharesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListLensSharesResponseFetcher
    implements AsyncPageFetcher<ListLensSharesResponse> {
        private ListLensSharesResponseFetcher() {
        }

        public boolean hasNextPage(ListLensSharesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListLensSharesResponse> nextPage(ListLensSharesResponse previousPage) {
            if (previousPage == null) {
                return ListLensSharesPublisher.this.client.listLensShares(ListLensSharesPublisher.this.firstRequest);
            }
            return ListLensSharesPublisher.this.client.listLensShares((ListLensSharesRequest)((Object)ListLensSharesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

