/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wellarchitected.model.ProfileNotificationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProfileNotificationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProfileNotificationSummary> {
    private static final SdkField<String> CURRENT_PROFILE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrentProfileVersion").getter(ProfileNotificationSummary.getter(ProfileNotificationSummary::currentProfileVersion)).setter(ProfileNotificationSummary.setter(Builder::currentProfileVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentProfileVersion").build()}).build();
    private static final SdkField<String> LATEST_PROFILE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LatestProfileVersion").getter(ProfileNotificationSummary.getter(ProfileNotificationSummary::latestProfileVersion)).setter(ProfileNotificationSummary.setter(Builder::latestProfileVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestProfileVersion").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(ProfileNotificationSummary.getter(ProfileNotificationSummary::typeAsString)).setter(ProfileNotificationSummary.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> PROFILE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProfileArn").getter(ProfileNotificationSummary.getter(ProfileNotificationSummary::profileArn)).setter(ProfileNotificationSummary.setter(Builder::profileArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileArn").build()}).build();
    private static final SdkField<String> PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProfileName").getter(ProfileNotificationSummary.getter(ProfileNotificationSummary::profileName)).setter(ProfileNotificationSummary.setter(Builder::profileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileName").build()}).build();
    private static final SdkField<String> WORKLOAD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkloadId").getter(ProfileNotificationSummary.getter(ProfileNotificationSummary::workloadId)).setter(ProfileNotificationSummary.setter(Builder::workloadId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadId").build()}).build();
    private static final SdkField<String> WORKLOAD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkloadName").getter(ProfileNotificationSummary.getter(ProfileNotificationSummary::workloadName)).setter(ProfileNotificationSummary.setter(Builder::workloadName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CURRENT_PROFILE_VERSION_FIELD, LATEST_PROFILE_VERSION_FIELD, TYPE_FIELD, PROFILE_ARN_FIELD, PROFILE_NAME_FIELD, WORKLOAD_ID_FIELD, WORKLOAD_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String currentProfileVersion;
    private final String latestProfileVersion;
    private final String type;
    private final String profileArn;
    private final String profileName;
    private final String workloadId;
    private final String workloadName;

    private ProfileNotificationSummary(BuilderImpl builder) {
        this.currentProfileVersion = builder.currentProfileVersion;
        this.latestProfileVersion = builder.latestProfileVersion;
        this.type = builder.type;
        this.profileArn = builder.profileArn;
        this.profileName = builder.profileName;
        this.workloadId = builder.workloadId;
        this.workloadName = builder.workloadName;
    }

    public final String currentProfileVersion() {
        return this.currentProfileVersion;
    }

    public final String latestProfileVersion() {
        return this.latestProfileVersion;
    }

    public final ProfileNotificationType type() {
        return ProfileNotificationType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String profileArn() {
        return this.profileArn;
    }

    public final String profileName() {
        return this.profileName;
    }

    public final String workloadId() {
        return this.workloadId;
    }

    public final String workloadName() {
        return this.workloadName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.currentProfileVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestProfileVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadId());
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProfileNotificationSummary)) {
            return false;
        }
        ProfileNotificationSummary other = (ProfileNotificationSummary)obj;
        return Objects.equals(this.currentProfileVersion(), other.currentProfileVersion()) && Objects.equals(this.latestProfileVersion(), other.latestProfileVersion()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.profileArn(), other.profileArn()) && Objects.equals(this.profileName(), other.profileName()) && Objects.equals(this.workloadId(), other.workloadId()) && Objects.equals(this.workloadName(), other.workloadName());
    }

    public final String toString() {
        return ToString.builder((String)"ProfileNotificationSummary").add("CurrentProfileVersion", (Object)this.currentProfileVersion()).add("LatestProfileVersion", (Object)this.latestProfileVersion()).add("Type", (Object)this.typeAsString()).add("ProfileArn", (Object)this.profileArn()).add("ProfileName", (Object)this.profileName()).add("WorkloadId", (Object)this.workloadId()).add("WorkloadName", (Object)this.workloadName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CurrentProfileVersion": {
                return Optional.ofNullable(clazz.cast(this.currentProfileVersion()));
            }
            case "LatestProfileVersion": {
                return Optional.ofNullable(clazz.cast(this.latestProfileVersion()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "ProfileArn": {
                return Optional.ofNullable(clazz.cast(this.profileArn()));
            }
            case "ProfileName": {
                return Optional.ofNullable(clazz.cast(this.profileName()));
            }
            case "WorkloadId": {
                return Optional.ofNullable(clazz.cast(this.workloadId()));
            }
            case "WorkloadName": {
                return Optional.ofNullable(clazz.cast(this.workloadName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProfileNotificationSummary, T> g) {
        return obj -> g.apply((ProfileNotificationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String currentProfileVersion;
        private String latestProfileVersion;
        private String type;
        private String profileArn;
        private String profileName;
        private String workloadId;
        private String workloadName;

        private BuilderImpl() {
        }

        private BuilderImpl(ProfileNotificationSummary model) {
            this.currentProfileVersion(model.currentProfileVersion);
            this.latestProfileVersion(model.latestProfileVersion);
            this.type(model.type);
            this.profileArn(model.profileArn);
            this.profileName(model.profileName);
            this.workloadId(model.workloadId);
            this.workloadName(model.workloadName);
        }

        public final String getCurrentProfileVersion() {
            return this.currentProfileVersion;
        }

        public final void setCurrentProfileVersion(String currentProfileVersion) {
            this.currentProfileVersion = currentProfileVersion;
        }

        @Override
        public final Builder currentProfileVersion(String currentProfileVersion) {
            this.currentProfileVersion = currentProfileVersion;
            return this;
        }

        public final String getLatestProfileVersion() {
            return this.latestProfileVersion;
        }

        public final void setLatestProfileVersion(String latestProfileVersion) {
            this.latestProfileVersion = latestProfileVersion;
        }

        @Override
        public final Builder latestProfileVersion(String latestProfileVersion) {
            this.latestProfileVersion = latestProfileVersion;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ProfileNotificationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getProfileArn() {
            return this.profileArn;
        }

        public final void setProfileArn(String profileArn) {
            this.profileArn = profileArn;
        }

        @Override
        public final Builder profileArn(String profileArn) {
            this.profileArn = profileArn;
            return this;
        }

        public final String getProfileName() {
            return this.profileName;
        }

        public final void setProfileName(String profileName) {
            this.profileName = profileName;
        }

        @Override
        public final Builder profileName(String profileName) {
            this.profileName = profileName;
            return this;
        }

        public final String getWorkloadId() {
            return this.workloadId;
        }

        public final void setWorkloadId(String workloadId) {
            this.workloadId = workloadId;
        }

        @Override
        public final Builder workloadId(String workloadId) {
            this.workloadId = workloadId;
            return this;
        }

        public final String getWorkloadName() {
            return this.workloadName;
        }

        public final void setWorkloadName(String workloadName) {
            this.workloadName = workloadName;
        }

        @Override
        public final Builder workloadName(String workloadName) {
            this.workloadName = workloadName;
            return this;
        }

        public ProfileNotificationSummary build() {
            return new ProfileNotificationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProfileNotificationSummary> {
        public Builder currentProfileVersion(String var1);

        public Builder latestProfileVersion(String var1);

        public Builder type(String var1);

        public Builder type(ProfileNotificationType var1);

        public Builder profileArn(String var1);

        public Builder profileName(String var1);

        public Builder workloadId(String var1);

        public Builder workloadName(String var1);
    }
}

