/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A share invitation summary return object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ShareInvitationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ShareInvitationSummary.Builder, ShareInvitationSummary> {
    private static final SdkField<String> SHARE_INVITATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ShareInvitationId").getter(getter(ShareInvitationSummary::shareInvitationId))
            .setter(setter(Builder::shareInvitationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareInvitationId").build()).build();

    private static final SdkField<String> SHARED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SharedBy").getter(getter(ShareInvitationSummary::sharedBy)).setter(setter(Builder::sharedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SharedBy").build()).build();

    private static final SdkField<String> SHARED_WITH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SharedWith").getter(getter(ShareInvitationSummary::sharedWith)).setter(setter(Builder::sharedWith))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SharedWith").build()).build();

    private static final SdkField<String> PERMISSION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PermissionType").getter(getter(ShareInvitationSummary::permissionTypeAsString))
            .setter(setter(Builder::permissionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionType").build()).build();

    private static final SdkField<String> SHARE_RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ShareResourceType").getter(getter(ShareInvitationSummary::shareResourceTypeAsString))
            .setter(setter(Builder::shareResourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareResourceType").build()).build();

    private static final SdkField<String> WORKLOAD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkloadName").getter(getter(ShareInvitationSummary::workloadName))
            .setter(setter(Builder::workloadName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadName").build()).build();

    private static final SdkField<String> WORKLOAD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkloadId").getter(getter(ShareInvitationSummary::workloadId)).setter(setter(Builder::workloadId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadId").build()).build();

    private static final SdkField<String> LENS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LensName").getter(getter(ShareInvitationSummary::lensName)).setter(setter(Builder::lensName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensName").build()).build();

    private static final SdkField<String> LENS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LensArn").getter(getter(ShareInvitationSummary::lensArn)).setter(setter(Builder::lensArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensArn").build()).build();

    private static final SdkField<String> PROFILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProfileName").getter(getter(ShareInvitationSummary::profileName)).setter(setter(Builder::profileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileName").build()).build();

    private static final SdkField<String> PROFILE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProfileArn").getter(getter(ShareInvitationSummary::profileArn)).setter(setter(Builder::profileArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHARE_INVITATION_ID_FIELD,
            SHARED_BY_FIELD, SHARED_WITH_FIELD, PERMISSION_TYPE_FIELD, SHARE_RESOURCE_TYPE_FIELD, WORKLOAD_NAME_FIELD,
            WORKLOAD_ID_FIELD, LENS_NAME_FIELD, LENS_ARN_FIELD, PROFILE_NAME_FIELD, PROFILE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String shareInvitationId;

    private final String sharedBy;

    private final String sharedWith;

    private final String permissionType;

    private final String shareResourceType;

    private final String workloadName;

    private final String workloadId;

    private final String lensName;

    private final String lensArn;

    private final String profileName;

    private final String profileArn;

    private ShareInvitationSummary(BuilderImpl builder) {
        this.shareInvitationId = builder.shareInvitationId;
        this.sharedBy = builder.sharedBy;
        this.sharedWith = builder.sharedWith;
        this.permissionType = builder.permissionType;
        this.shareResourceType = builder.shareResourceType;
        this.workloadName = builder.workloadName;
        this.workloadId = builder.workloadId;
        this.lensName = builder.lensName;
        this.lensArn = builder.lensArn;
        this.profileName = builder.profileName;
        this.profileArn = builder.profileArn;
    }

    /**
     * <p>
     * The ID assigned to the share invitation.
     * </p>
     * 
     * @return The ID assigned to the share invitation.
     */
    public final String shareInvitationId() {
        return shareInvitationId;
    }

    /**
     * Returns the value of the SharedBy property for this object.
     * 
     * @return The value of the SharedBy property for this object.
     */
    public final String sharedBy() {
        return sharedBy;
    }

    /**
     * Returns the value of the SharedWith property for this object.
     * 
     * @return The value of the SharedWith property for this object.
     */
    public final String sharedWith() {
        return sharedWith;
    }

    /**
     * Returns the value of the PermissionType property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permissionType}
     * will return {@link PermissionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #permissionTypeAsString}.
     * </p>
     * 
     * @return The value of the PermissionType property for this object.
     * @see PermissionType
     */
    public final PermissionType permissionType() {
        return PermissionType.fromValue(permissionType);
    }

    /**
     * Returns the value of the PermissionType property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permissionType}
     * will return {@link PermissionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #permissionTypeAsString}.
     * </p>
     * 
     * @return The value of the PermissionType property for this object.
     * @see PermissionType
     */
    public final String permissionTypeAsString() {
        return permissionType;
    }

    /**
     * <p>
     * The resource type of the share invitation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #shareResourceType}
     * will return {@link ShareResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #shareResourceTypeAsString}.
     * </p>
     * 
     * @return The resource type of the share invitation.
     * @see ShareResourceType
     */
    public final ShareResourceType shareResourceType() {
        return ShareResourceType.fromValue(shareResourceType);
    }

    /**
     * <p>
     * The resource type of the share invitation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #shareResourceType}
     * will return {@link ShareResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #shareResourceTypeAsString}.
     * </p>
     * 
     * @return The resource type of the share invitation.
     * @see ShareResourceType
     */
    public final String shareResourceTypeAsString() {
        return shareResourceType;
    }

    /**
     * Returns the value of the WorkloadName property for this object.
     * 
     * @return The value of the WorkloadName property for this object.
     */
    public final String workloadName() {
        return workloadName;
    }

    /**
     * Returns the value of the WorkloadId property for this object.
     * 
     * @return The value of the WorkloadId property for this object.
     */
    public final String workloadId() {
        return workloadId;
    }

    /**
     * Returns the value of the LensName property for this object.
     * 
     * @return The value of the LensName property for this object.
     */
    public final String lensName() {
        return lensName;
    }

    /**
     * <p>
     * The ARN for the lens.
     * </p>
     * 
     * @return The ARN for the lens.
     */
    public final String lensArn() {
        return lensArn;
    }

    /**
     * <p>
     * The profile name.
     * </p>
     * 
     * @return The profile name.
     */
    public final String profileName() {
        return profileName;
    }

    /**
     * <p>
     * The profile ARN.
     * </p>
     * 
     * @return The profile ARN.
     */
    public final String profileArn() {
        return profileArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(shareInvitationId());
        hashCode = 31 * hashCode + Objects.hashCode(sharedBy());
        hashCode = 31 * hashCode + Objects.hashCode(sharedWith());
        hashCode = 31 * hashCode + Objects.hashCode(permissionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(shareResourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(workloadName());
        hashCode = 31 * hashCode + Objects.hashCode(workloadId());
        hashCode = 31 * hashCode + Objects.hashCode(lensName());
        hashCode = 31 * hashCode + Objects.hashCode(lensArn());
        hashCode = 31 * hashCode + Objects.hashCode(profileName());
        hashCode = 31 * hashCode + Objects.hashCode(profileArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ShareInvitationSummary)) {
            return false;
        }
        ShareInvitationSummary other = (ShareInvitationSummary) obj;
        return Objects.equals(shareInvitationId(), other.shareInvitationId()) && Objects.equals(sharedBy(), other.sharedBy())
                && Objects.equals(sharedWith(), other.sharedWith())
                && Objects.equals(permissionTypeAsString(), other.permissionTypeAsString())
                && Objects.equals(shareResourceTypeAsString(), other.shareResourceTypeAsString())
                && Objects.equals(workloadName(), other.workloadName()) && Objects.equals(workloadId(), other.workloadId())
                && Objects.equals(lensName(), other.lensName()) && Objects.equals(lensArn(), other.lensArn())
                && Objects.equals(profileName(), other.profileName()) && Objects.equals(profileArn(), other.profileArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ShareInvitationSummary").add("ShareInvitationId", shareInvitationId())
                .add("SharedBy", sharedBy()).add("SharedWith", sharedWith()).add("PermissionType", permissionTypeAsString())
                .add("ShareResourceType", shareResourceTypeAsString()).add("WorkloadName", workloadName())
                .add("WorkloadId", workloadId()).add("LensName", lensName()).add("LensArn", lensArn())
                .add("ProfileName", profileName()).add("ProfileArn", profileArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ShareInvitationId":
            return Optional.ofNullable(clazz.cast(shareInvitationId()));
        case "SharedBy":
            return Optional.ofNullable(clazz.cast(sharedBy()));
        case "SharedWith":
            return Optional.ofNullable(clazz.cast(sharedWith()));
        case "PermissionType":
            return Optional.ofNullable(clazz.cast(permissionTypeAsString()));
        case "ShareResourceType":
            return Optional.ofNullable(clazz.cast(shareResourceTypeAsString()));
        case "WorkloadName":
            return Optional.ofNullable(clazz.cast(workloadName()));
        case "WorkloadId":
            return Optional.ofNullable(clazz.cast(workloadId()));
        case "LensName":
            return Optional.ofNullable(clazz.cast(lensName()));
        case "LensArn":
            return Optional.ofNullable(clazz.cast(lensArn()));
        case "ProfileName":
            return Optional.ofNullable(clazz.cast(profileName()));
        case "ProfileArn":
            return Optional.ofNullable(clazz.cast(profileArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ShareInvitationSummary, T> g) {
        return obj -> g.apply((ShareInvitationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ShareInvitationSummary> {
        /**
         * <p>
         * The ID assigned to the share invitation.
         * </p>
         * 
         * @param shareInvitationId
         *        The ID assigned to the share invitation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shareInvitationId(String shareInvitationId);

        /**
         * Sets the value of the SharedBy property for this object.
         *
         * @param sharedBy
         *        The new value for the SharedBy property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharedBy(String sharedBy);

        /**
         * Sets the value of the SharedWith property for this object.
         *
         * @param sharedWith
         *        The new value for the SharedWith property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharedWith(String sharedWith);

        /**
         * Sets the value of the PermissionType property for this object.
         *
         * @param permissionType
         *        The new value for the PermissionType property for this object.
         * @see PermissionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PermissionType
         */
        Builder permissionType(String permissionType);

        /**
         * Sets the value of the PermissionType property for this object.
         *
         * @param permissionType
         *        The new value for the PermissionType property for this object.
         * @see PermissionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PermissionType
         */
        Builder permissionType(PermissionType permissionType);

        /**
         * <p>
         * The resource type of the share invitation.
         * </p>
         * 
         * @param shareResourceType
         *        The resource type of the share invitation.
         * @see ShareResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShareResourceType
         */
        Builder shareResourceType(String shareResourceType);

        /**
         * <p>
         * The resource type of the share invitation.
         * </p>
         * 
         * @param shareResourceType
         *        The resource type of the share invitation.
         * @see ShareResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShareResourceType
         */
        Builder shareResourceType(ShareResourceType shareResourceType);

        /**
         * Sets the value of the WorkloadName property for this object.
         *
         * @param workloadName
         *        The new value for the WorkloadName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadName(String workloadName);

        /**
         * Sets the value of the WorkloadId property for this object.
         *
         * @param workloadId
         *        The new value for the WorkloadId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadId(String workloadId);

        /**
         * Sets the value of the LensName property for this object.
         *
         * @param lensName
         *        The new value for the LensName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lensName(String lensName);

        /**
         * <p>
         * The ARN for the lens.
         * </p>
         * 
         * @param lensArn
         *        The ARN for the lens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lensArn(String lensArn);

        /**
         * <p>
         * The profile name.
         * </p>
         * 
         * @param profileName
         *        The profile name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileName(String profileName);

        /**
         * <p>
         * The profile ARN.
         * </p>
         * 
         * @param profileArn
         *        The profile ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileArn(String profileArn);
    }

    static final class BuilderImpl implements Builder {
        private String shareInvitationId;

        private String sharedBy;

        private String sharedWith;

        private String permissionType;

        private String shareResourceType;

        private String workloadName;

        private String workloadId;

        private String lensName;

        private String lensArn;

        private String profileName;

        private String profileArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ShareInvitationSummary model) {
            shareInvitationId(model.shareInvitationId);
            sharedBy(model.sharedBy);
            sharedWith(model.sharedWith);
            permissionType(model.permissionType);
            shareResourceType(model.shareResourceType);
            workloadName(model.workloadName);
            workloadId(model.workloadId);
            lensName(model.lensName);
            lensArn(model.lensArn);
            profileName(model.profileName);
            profileArn(model.profileArn);
        }

        public final String getShareInvitationId() {
            return shareInvitationId;
        }

        public final void setShareInvitationId(String shareInvitationId) {
            this.shareInvitationId = shareInvitationId;
        }

        @Override
        public final Builder shareInvitationId(String shareInvitationId) {
            this.shareInvitationId = shareInvitationId;
            return this;
        }

        public final String getSharedBy() {
            return sharedBy;
        }

        public final void setSharedBy(String sharedBy) {
            this.sharedBy = sharedBy;
        }

        @Override
        public final Builder sharedBy(String sharedBy) {
            this.sharedBy = sharedBy;
            return this;
        }

        public final String getSharedWith() {
            return sharedWith;
        }

        public final void setSharedWith(String sharedWith) {
            this.sharedWith = sharedWith;
        }

        @Override
        public final Builder sharedWith(String sharedWith) {
            this.sharedWith = sharedWith;
            return this;
        }

        public final String getPermissionType() {
            return permissionType;
        }

        public final void setPermissionType(String permissionType) {
            this.permissionType = permissionType;
        }

        @Override
        public final Builder permissionType(String permissionType) {
            this.permissionType = permissionType;
            return this;
        }

        @Override
        public final Builder permissionType(PermissionType permissionType) {
            this.permissionType(permissionType == null ? null : permissionType.toString());
            return this;
        }

        public final String getShareResourceType() {
            return shareResourceType;
        }

        public final void setShareResourceType(String shareResourceType) {
            this.shareResourceType = shareResourceType;
        }

        @Override
        public final Builder shareResourceType(String shareResourceType) {
            this.shareResourceType = shareResourceType;
            return this;
        }

        @Override
        public final Builder shareResourceType(ShareResourceType shareResourceType) {
            this.shareResourceType(shareResourceType == null ? null : shareResourceType.toString());
            return this;
        }

        public final String getWorkloadName() {
            return workloadName;
        }

        public final void setWorkloadName(String workloadName) {
            this.workloadName = workloadName;
        }

        @Override
        public final Builder workloadName(String workloadName) {
            this.workloadName = workloadName;
            return this;
        }

        public final String getWorkloadId() {
            return workloadId;
        }

        public final void setWorkloadId(String workloadId) {
            this.workloadId = workloadId;
        }

        @Override
        public final Builder workloadId(String workloadId) {
            this.workloadId = workloadId;
            return this;
        }

        public final String getLensName() {
            return lensName;
        }

        public final void setLensName(String lensName) {
            this.lensName = lensName;
        }

        @Override
        public final Builder lensName(String lensName) {
            this.lensName = lensName;
            return this;
        }

        public final String getLensArn() {
            return lensArn;
        }

        public final void setLensArn(String lensArn) {
            this.lensArn = lensArn;
        }

        @Override
        public final Builder lensArn(String lensArn) {
            this.lensArn = lensArn;
            return this;
        }

        public final String getProfileName() {
            return profileName;
        }

        public final void setProfileName(String profileName) {
            this.profileName = profileName;
        }

        @Override
        public final Builder profileName(String profileName) {
            this.profileName = profileName;
            return this;
        }

        public final String getProfileArn() {
            return profileArn;
        }

        public final void setProfileArn(String profileArn) {
            this.profileArn = profileArn;
        }

        @Override
        public final Builder profileArn(String profileArn) {
            this.profileArn = profileArn;
            return this;
        }

        @Override
        public ShareInvitationSummary build() {
            return new ShareInvitationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
