/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input for Update Share Invitation
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateShareInvitationRequest extends WellArchitectedRequest implements
        ToCopyableBuilder<UpdateShareInvitationRequest.Builder, UpdateShareInvitationRequest> {
    private static final SdkField<String> SHARE_INVITATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ShareInvitationId").getter(getter(UpdateShareInvitationRequest::shareInvitationId))
            .setter(setter(Builder::shareInvitationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ShareInvitationId").build()).build();

    private static final SdkField<String> SHARE_INVITATION_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ShareInvitationAction").getter(getter(UpdateShareInvitationRequest::shareInvitationActionAsString))
            .setter(setter(Builder::shareInvitationAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareInvitationAction").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHARE_INVITATION_ID_FIELD,
            SHARE_INVITATION_ACTION_FIELD));

    private final String shareInvitationId;

    private final String shareInvitationAction;

    private UpdateShareInvitationRequest(BuilderImpl builder) {
        super(builder);
        this.shareInvitationId = builder.shareInvitationId;
        this.shareInvitationAction = builder.shareInvitationAction;
    }

    /**
     * <p>
     * The ID assigned to the share invitation.
     * </p>
     * 
     * @return The ID assigned to the share invitation.
     */
    public final String shareInvitationId() {
        return shareInvitationId;
    }

    /**
     * Returns the value of the ShareInvitationAction property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #shareInvitationAction} will return {@link ShareInvitationAction#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #shareInvitationActionAsString}.
     * </p>
     * 
     * @return The value of the ShareInvitationAction property for this object.
     * @see ShareInvitationAction
     */
    public final ShareInvitationAction shareInvitationAction() {
        return ShareInvitationAction.fromValue(shareInvitationAction);
    }

    /**
     * Returns the value of the ShareInvitationAction property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #shareInvitationAction} will return {@link ShareInvitationAction#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #shareInvitationActionAsString}.
     * </p>
     * 
     * @return The value of the ShareInvitationAction property for this object.
     * @see ShareInvitationAction
     */
    public final String shareInvitationActionAsString() {
        return shareInvitationAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(shareInvitationId());
        hashCode = 31 * hashCode + Objects.hashCode(shareInvitationActionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateShareInvitationRequest)) {
            return false;
        }
        UpdateShareInvitationRequest other = (UpdateShareInvitationRequest) obj;
        return Objects.equals(shareInvitationId(), other.shareInvitationId())
                && Objects.equals(shareInvitationActionAsString(), other.shareInvitationActionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateShareInvitationRequest").add("ShareInvitationId", shareInvitationId())
                .add("ShareInvitationAction", shareInvitationActionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ShareInvitationId":
            return Optional.ofNullable(clazz.cast(shareInvitationId()));
        case "ShareInvitationAction":
            return Optional.ofNullable(clazz.cast(shareInvitationActionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateShareInvitationRequest, T> g) {
        return obj -> g.apply((UpdateShareInvitationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WellArchitectedRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateShareInvitationRequest> {
        /**
         * <p>
         * The ID assigned to the share invitation.
         * </p>
         * 
         * @param shareInvitationId
         *        The ID assigned to the share invitation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shareInvitationId(String shareInvitationId);

        /**
         * Sets the value of the ShareInvitationAction property for this object.
         *
         * @param shareInvitationAction
         *        The new value for the ShareInvitationAction property for this object.
         * @see ShareInvitationAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShareInvitationAction
         */
        Builder shareInvitationAction(String shareInvitationAction);

        /**
         * Sets the value of the ShareInvitationAction property for this object.
         *
         * @param shareInvitationAction
         *        The new value for the ShareInvitationAction property for this object.
         * @see ShareInvitationAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShareInvitationAction
         */
        Builder shareInvitationAction(ShareInvitationAction shareInvitationAction);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WellArchitectedRequest.BuilderImpl implements Builder {
        private String shareInvitationId;

        private String shareInvitationAction;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateShareInvitationRequest model) {
            super(model);
            shareInvitationId(model.shareInvitationId);
            shareInvitationAction(model.shareInvitationAction);
        }

        public final String getShareInvitationId() {
            return shareInvitationId;
        }

        public final void setShareInvitationId(String shareInvitationId) {
            this.shareInvitationId = shareInvitationId;
        }

        @Override
        public final Builder shareInvitationId(String shareInvitationId) {
            this.shareInvitationId = shareInvitationId;
            return this;
        }

        public final String getShareInvitationAction() {
            return shareInvitationAction;
        }

        public final void setShareInvitationAction(String shareInvitationAction) {
            this.shareInvitationAction = shareInvitationAction;
        }

        @Override
        public final Builder shareInvitationAction(String shareInvitationAction) {
            this.shareInvitationAction = shareInvitationAction;
            return this;
        }

        @Override
        public final Builder shareInvitationAction(ShareInvitationAction shareInvitationAction) {
            this.shareInvitationAction(shareInvitationAction == null ? null : shareInvitationAction.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateShareInvitationRequest build() {
            return new UpdateShareInvitationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
