/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A pillar review summary of a lens review.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PillarReviewSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<PillarReviewSummary.Builder, PillarReviewSummary> {
    private static final SdkField<String> PILLAR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PillarId").getter(getter(PillarReviewSummary::pillarId)).setter(setter(Builder::pillarId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PillarId").build()).build();

    private static final SdkField<String> PILLAR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PillarName").getter(getter(PillarReviewSummary::pillarName)).setter(setter(Builder::pillarName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PillarName").build()).build();

    private static final SdkField<String> NOTES_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Notes")
            .getter(getter(PillarReviewSummary::notes)).setter(setter(Builder::notes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notes").build()).build();

    private static final SdkField<Map<String, Integer>> RISK_COUNTS_FIELD = SdkField
            .<Map<String, Integer>> builder(MarshallingType.MAP)
            .memberName("RiskCounts")
            .getter(getter(PillarReviewSummary::riskCountsAsStrings))
            .setter(setter(Builder::riskCountsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RiskCounts").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, Integer>> PRIORITIZED_RISK_COUNTS_FIELD = SdkField
            .<Map<String, Integer>> builder(MarshallingType.MAP)
            .memberName("PrioritizedRiskCounts")
            .getter(getter(PillarReviewSummary::prioritizedRiskCountsAsStrings))
            .setter(setter(Builder::prioritizedRiskCountsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrioritizedRiskCounts").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PILLAR_ID_FIELD,
            PILLAR_NAME_FIELD, NOTES_FIELD, RISK_COUNTS_FIELD, PRIORITIZED_RISK_COUNTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String pillarId;

    private final String pillarName;

    private final String notes;

    private final Map<String, Integer> riskCounts;

    private final Map<String, Integer> prioritizedRiskCounts;

    private PillarReviewSummary(BuilderImpl builder) {
        this.pillarId = builder.pillarId;
        this.pillarName = builder.pillarName;
        this.notes = builder.notes;
        this.riskCounts = builder.riskCounts;
        this.prioritizedRiskCounts = builder.prioritizedRiskCounts;
    }

    /**
     * Returns the value of the PillarId property for this object.
     * 
     * @return The value of the PillarId property for this object.
     */
    public final String pillarId() {
        return pillarId;
    }

    /**
     * Returns the value of the PillarName property for this object.
     * 
     * @return The value of the PillarName property for this object.
     */
    public final String pillarName() {
        return pillarName;
    }

    /**
     * Returns the value of the Notes property for this object.
     * 
     * @return The value of the Notes property for this object.
     */
    public final String notes() {
        return notes;
    }

    /**
     * Returns the value of the RiskCounts property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRiskCounts} method.
     * </p>
     * 
     * @return The value of the RiskCounts property for this object.
     */
    public final Map<Risk, Integer> riskCounts() {
        return RiskCountsCopier.copyStringToEnum(riskCounts);
    }

    /**
     * For responses, this returns true if the service returned a value for the RiskCounts property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRiskCounts() {
        return riskCounts != null && !(riskCounts instanceof SdkAutoConstructMap);
    }

    /**
     * Returns the value of the RiskCounts property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRiskCounts} method.
     * </p>
     * 
     * @return The value of the RiskCounts property for this object.
     */
    public final Map<String, Integer> riskCountsAsStrings() {
        return riskCounts;
    }

    /**
     * Returns the value of the PrioritizedRiskCounts property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrioritizedRiskCounts} method.
     * </p>
     * 
     * @return The value of the PrioritizedRiskCounts property for this object.
     */
    public final Map<Risk, Integer> prioritizedRiskCounts() {
        return RiskCountsCopier.copyStringToEnum(prioritizedRiskCounts);
    }

    /**
     * For responses, this returns true if the service returned a value for the PrioritizedRiskCounts property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPrioritizedRiskCounts() {
        return prioritizedRiskCounts != null && !(prioritizedRiskCounts instanceof SdkAutoConstructMap);
    }

    /**
     * Returns the value of the PrioritizedRiskCounts property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrioritizedRiskCounts} method.
     * </p>
     * 
     * @return The value of the PrioritizedRiskCounts property for this object.
     */
    public final Map<String, Integer> prioritizedRiskCountsAsStrings() {
        return prioritizedRiskCounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pillarId());
        hashCode = 31 * hashCode + Objects.hashCode(pillarName());
        hashCode = 31 * hashCode + Objects.hashCode(notes());
        hashCode = 31 * hashCode + Objects.hashCode(hasRiskCounts() ? riskCountsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPrioritizedRiskCounts() ? prioritizedRiskCountsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PillarReviewSummary)) {
            return false;
        }
        PillarReviewSummary other = (PillarReviewSummary) obj;
        return Objects.equals(pillarId(), other.pillarId()) && Objects.equals(pillarName(), other.pillarName())
                && Objects.equals(notes(), other.notes()) && hasRiskCounts() == other.hasRiskCounts()
                && Objects.equals(riskCountsAsStrings(), other.riskCountsAsStrings())
                && hasPrioritizedRiskCounts() == other.hasPrioritizedRiskCounts()
                && Objects.equals(prioritizedRiskCountsAsStrings(), other.prioritizedRiskCountsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PillarReviewSummary").add("PillarId", pillarId()).add("PillarName", pillarName())
                .add("Notes", notes()).add("RiskCounts", hasRiskCounts() ? riskCountsAsStrings() : null)
                .add("PrioritizedRiskCounts", hasPrioritizedRiskCounts() ? prioritizedRiskCountsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PillarId":
            return Optional.ofNullable(clazz.cast(pillarId()));
        case "PillarName":
            return Optional.ofNullable(clazz.cast(pillarName()));
        case "Notes":
            return Optional.ofNullable(clazz.cast(notes()));
        case "RiskCounts":
            return Optional.ofNullable(clazz.cast(riskCountsAsStrings()));
        case "PrioritizedRiskCounts":
            return Optional.ofNullable(clazz.cast(prioritizedRiskCountsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PillarReviewSummary, T> g) {
        return obj -> g.apply((PillarReviewSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PillarReviewSummary> {
        /**
         * Sets the value of the PillarId property for this object.
         *
         * @param pillarId
         *        The new value for the PillarId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pillarId(String pillarId);

        /**
         * Sets the value of the PillarName property for this object.
         *
         * @param pillarName
         *        The new value for the PillarName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pillarName(String pillarName);

        /**
         * Sets the value of the Notes property for this object.
         *
         * @param notes
         *        The new value for the Notes property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notes(String notes);

        /**
         * Sets the value of the RiskCounts property for this object.
         *
         * @param riskCounts
         *        The new value for the RiskCounts property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder riskCountsWithStrings(Map<String, Integer> riskCounts);

        /**
         * Sets the value of the RiskCounts property for this object.
         *
         * @param riskCounts
         *        The new value for the RiskCounts property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder riskCounts(Map<Risk, Integer> riskCounts);

        /**
         * Sets the value of the PrioritizedRiskCounts property for this object.
         *
         * @param prioritizedRiskCounts
         *        The new value for the PrioritizedRiskCounts property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prioritizedRiskCountsWithStrings(Map<String, Integer> prioritizedRiskCounts);

        /**
         * Sets the value of the PrioritizedRiskCounts property for this object.
         *
         * @param prioritizedRiskCounts
         *        The new value for the PrioritizedRiskCounts property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prioritizedRiskCounts(Map<Risk, Integer> prioritizedRiskCounts);
    }

    static final class BuilderImpl implements Builder {
        private String pillarId;

        private String pillarName;

        private String notes;

        private Map<String, Integer> riskCounts = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, Integer> prioritizedRiskCounts = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PillarReviewSummary model) {
            pillarId(model.pillarId);
            pillarName(model.pillarName);
            notes(model.notes);
            riskCountsWithStrings(model.riskCounts);
            prioritizedRiskCountsWithStrings(model.prioritizedRiskCounts);
        }

        public final String getPillarId() {
            return pillarId;
        }

        public final void setPillarId(String pillarId) {
            this.pillarId = pillarId;
        }

        @Override
        public final Builder pillarId(String pillarId) {
            this.pillarId = pillarId;
            return this;
        }

        public final String getPillarName() {
            return pillarName;
        }

        public final void setPillarName(String pillarName) {
            this.pillarName = pillarName;
        }

        @Override
        public final Builder pillarName(String pillarName) {
            this.pillarName = pillarName;
            return this;
        }

        public final String getNotes() {
            return notes;
        }

        public final void setNotes(String notes) {
            this.notes = notes;
        }

        @Override
        public final Builder notes(String notes) {
            this.notes = notes;
            return this;
        }

        public final Map<String, Integer> getRiskCounts() {
            if (riskCounts instanceof SdkAutoConstructMap) {
                return null;
            }
            return riskCounts;
        }

        public final void setRiskCounts(Map<String, Integer> riskCounts) {
            this.riskCounts = RiskCountsCopier.copy(riskCounts);
        }

        @Override
        public final Builder riskCountsWithStrings(Map<String, Integer> riskCounts) {
            this.riskCounts = RiskCountsCopier.copy(riskCounts);
            return this;
        }

        @Override
        public final Builder riskCounts(Map<Risk, Integer> riskCounts) {
            this.riskCounts = RiskCountsCopier.copyEnumToString(riskCounts);
            return this;
        }

        public final Map<String, Integer> getPrioritizedRiskCounts() {
            if (prioritizedRiskCounts instanceof SdkAutoConstructMap) {
                return null;
            }
            return prioritizedRiskCounts;
        }

        public final void setPrioritizedRiskCounts(Map<String, Integer> prioritizedRiskCounts) {
            this.prioritizedRiskCounts = RiskCountsCopier.copy(prioritizedRiskCounts);
        }

        @Override
        public final Builder prioritizedRiskCountsWithStrings(Map<String, Integer> prioritizedRiskCounts) {
            this.prioritizedRiskCounts = RiskCountsCopier.copy(prioritizedRiskCounts);
            return this;
        }

        @Override
        public final Builder prioritizedRiskCounts(Map<Risk, Integer> prioritizedRiskCounts) {
            this.prioritizedRiskCounts = RiskCountsCopier.copyEnumToString(prioritizedRiskCounts);
            return this;
        }

        @Override
        public PillarReviewSummary build() {
            return new PillarReviewSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
