/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.wafv2.model.ManagedRuleSetVersion;
import software.amazon.awssdk.services.wafv2.model.PublishedVersionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ManagedRuleSet
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ManagedRuleSet> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ManagedRuleSet.getter(ManagedRuleSet::name)).setter(ManagedRuleSet.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(ManagedRuleSet.getter(ManagedRuleSet::id)).setter(ManagedRuleSet.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ARN").getter(ManagedRuleSet.getter(ManagedRuleSet::arn)).setter(ManagedRuleSet.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ManagedRuleSet.getter(ManagedRuleSet::description)).setter(ManagedRuleSet.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Map<String, ManagedRuleSetVersion>> PUBLISHED_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("PublishedVersions").getter(ManagedRuleSet.getter(ManagedRuleSet::publishedVersions)).setter(ManagedRuleSet.setter(Builder::publishedVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublishedVersions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ManagedRuleSetVersion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> RECOMMENDED_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecommendedVersion").getter(ManagedRuleSet.getter(ManagedRuleSet::recommendedVersion)).setter(ManagedRuleSet.setter(Builder::recommendedVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendedVersion").build()}).build();
    private static final SdkField<String> LABEL_NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LabelNamespace").getter(ManagedRuleSet.getter(ManagedRuleSet::labelNamespace)).setter(ManagedRuleSet.setter(Builder::labelNamespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelNamespace").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ID_FIELD, ARN_FIELD, DESCRIPTION_FIELD, PUBLISHED_VERSIONS_FIELD, RECOMMENDED_VERSION_FIELD, LABEL_NAMESPACE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String id;
    private final String arn;
    private final String description;
    private final Map<String, ManagedRuleSetVersion> publishedVersions;
    private final String recommendedVersion;
    private final String labelNamespace;

    private ManagedRuleSet(BuilderImpl builder) {
        this.name = builder.name;
        this.id = builder.id;
        this.arn = builder.arn;
        this.description = builder.description;
        this.publishedVersions = builder.publishedVersions;
        this.recommendedVersion = builder.recommendedVersion;
        this.labelNamespace = builder.labelNamespace;
    }

    public final String name() {
        return this.name;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasPublishedVersions() {
        return this.publishedVersions != null && !(this.publishedVersions instanceof SdkAutoConstructMap);
    }

    public final Map<String, ManagedRuleSetVersion> publishedVersions() {
        return this.publishedVersions;
    }

    public final String recommendedVersion() {
        return this.recommendedVersion;
    }

    public final String labelNamespace() {
        return this.labelNamespace;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPublishedVersions() ? this.publishedVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendedVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.labelNamespace());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedRuleSet)) {
            return false;
        }
        ManagedRuleSet other = (ManagedRuleSet)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.description(), other.description()) && this.hasPublishedVersions() == other.hasPublishedVersions() && Objects.equals(this.publishedVersions(), other.publishedVersions()) && Objects.equals(this.recommendedVersion(), other.recommendedVersion()) && Objects.equals(this.labelNamespace(), other.labelNamespace());
    }

    public final String toString() {
        return ToString.builder((String)"ManagedRuleSet").add("Name", (Object)this.name()).add("Id", (Object)this.id()).add("ARN", (Object)this.arn()).add("Description", (Object)this.description()).add("PublishedVersions", this.hasPublishedVersions() ? this.publishedVersions() : null).add("RecommendedVersion", (Object)this.recommendedVersion()).add("LabelNamespace", (Object)this.labelNamespace()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "ARN": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "PublishedVersions": {
                return Optional.ofNullable(clazz.cast(this.publishedVersions()));
            }
            case "RecommendedVersion": {
                return Optional.ofNullable(clazz.cast(this.recommendedVersion()));
            }
            case "LabelNamespace": {
                return Optional.ofNullable(clazz.cast(this.labelNamespace()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ManagedRuleSet, T> g) {
        return obj -> g.apply((ManagedRuleSet)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String id;
        private String arn;
        private String description;
        private Map<String, ManagedRuleSetVersion> publishedVersions = DefaultSdkAutoConstructMap.getInstance();
        private String recommendedVersion;
        private String labelNamespace;

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedRuleSet model) {
            this.name(model.name);
            this.id(model.id);
            this.arn(model.arn);
            this.description(model.description);
            this.publishedVersions(model.publishedVersions);
            this.recommendedVersion(model.recommendedVersion);
            this.labelNamespace(model.labelNamespace);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, ManagedRuleSetVersion.Builder> getPublishedVersions() {
            Map<String, ManagedRuleSetVersion.Builder> result = PublishedVersionsCopier.copyToBuilder(this.publishedVersions);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setPublishedVersions(Map<String, ManagedRuleSetVersion.BuilderImpl> publishedVersions) {
            this.publishedVersions = PublishedVersionsCopier.copyFromBuilder(publishedVersions);
        }

        @Override
        public final Builder publishedVersions(Map<String, ManagedRuleSetVersion> publishedVersions) {
            this.publishedVersions = PublishedVersionsCopier.copy(publishedVersions);
            return this;
        }

        public final String getRecommendedVersion() {
            return this.recommendedVersion;
        }

        public final void setRecommendedVersion(String recommendedVersion) {
            this.recommendedVersion = recommendedVersion;
        }

        @Override
        public final Builder recommendedVersion(String recommendedVersion) {
            this.recommendedVersion = recommendedVersion;
            return this;
        }

        public final String getLabelNamespace() {
            return this.labelNamespace;
        }

        public final void setLabelNamespace(String labelNamespace) {
            this.labelNamespace = labelNamespace;
        }

        @Override
        public final Builder labelNamespace(String labelNamespace) {
            this.labelNamespace = labelNamespace;
            return this;
        }

        public ManagedRuleSet build() {
            return new ManagedRuleSet(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ManagedRuleSet> {
        public Builder name(String var1);

        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder description(String var1);

        public Builder publishedVersions(Map<String, ManagedRuleSetVersion> var1);

        public Builder recommendedVersion(String var1);

        public Builder labelNamespace(String var1);
    }
}

