/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wafv2.model.InspectionLevel;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AWSManagedRulesBotControlRuleSet
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AWSManagedRulesBotControlRuleSet> {
    private static final SdkField<String> INSPECTION_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InspectionLevel").getter(AWSManagedRulesBotControlRuleSet.getter(AWSManagedRulesBotControlRuleSet::inspectionLevelAsString)).setter(AWSManagedRulesBotControlRuleSet.setter(Builder::inspectionLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InspectionLevel").build()}).build();
    private static final SdkField<Boolean> ENABLE_MACHINE_LEARNING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableMachineLearning").getter(AWSManagedRulesBotControlRuleSet.getter(AWSManagedRulesBotControlRuleSet::enableMachineLearning)).setter(AWSManagedRulesBotControlRuleSet.setter(Builder::enableMachineLearning)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableMachineLearning").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSPECTION_LEVEL_FIELD, ENABLE_MACHINE_LEARNING_FIELD));
    private static final long serialVersionUID = 1L;
    private final String inspectionLevel;
    private final Boolean enableMachineLearning;

    private AWSManagedRulesBotControlRuleSet(BuilderImpl builder) {
        this.inspectionLevel = builder.inspectionLevel;
        this.enableMachineLearning = builder.enableMachineLearning;
    }

    public final InspectionLevel inspectionLevel() {
        return InspectionLevel.fromValue(this.inspectionLevel);
    }

    public final String inspectionLevelAsString() {
        return this.inspectionLevel;
    }

    public final Boolean enableMachineLearning() {
        return this.enableMachineLearning;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.inspectionLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableMachineLearning());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AWSManagedRulesBotControlRuleSet)) {
            return false;
        }
        AWSManagedRulesBotControlRuleSet other = (AWSManagedRulesBotControlRuleSet)obj;
        return Objects.equals(this.inspectionLevelAsString(), other.inspectionLevelAsString()) && Objects.equals(this.enableMachineLearning(), other.enableMachineLearning());
    }

    public final String toString() {
        return ToString.builder((String)"AWSManagedRulesBotControlRuleSet").add("InspectionLevel", (Object)this.inspectionLevelAsString()).add("EnableMachineLearning", (Object)this.enableMachineLearning()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InspectionLevel": {
                return Optional.ofNullable(clazz.cast(this.inspectionLevelAsString()));
            }
            case "EnableMachineLearning": {
                return Optional.ofNullable(clazz.cast(this.enableMachineLearning()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AWSManagedRulesBotControlRuleSet, T> g) {
        return obj -> g.apply((AWSManagedRulesBotControlRuleSet)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String inspectionLevel;
        private Boolean enableMachineLearning;

        private BuilderImpl() {
        }

        private BuilderImpl(AWSManagedRulesBotControlRuleSet model) {
            this.inspectionLevel(model.inspectionLevel);
            this.enableMachineLearning(model.enableMachineLearning);
        }

        public final String getInspectionLevel() {
            return this.inspectionLevel;
        }

        public final void setInspectionLevel(String inspectionLevel) {
            this.inspectionLevel = inspectionLevel;
        }

        @Override
        public final Builder inspectionLevel(String inspectionLevel) {
            this.inspectionLevel = inspectionLevel;
            return this;
        }

        @Override
        public final Builder inspectionLevel(InspectionLevel inspectionLevel) {
            this.inspectionLevel(inspectionLevel == null ? null : inspectionLevel.toString());
            return this;
        }

        public final Boolean getEnableMachineLearning() {
            return this.enableMachineLearning;
        }

        public final void setEnableMachineLearning(Boolean enableMachineLearning) {
            this.enableMachineLearning = enableMachineLearning;
        }

        @Override
        public final Builder enableMachineLearning(Boolean enableMachineLearning) {
            this.enableMachineLearning = enableMachineLearning;
            return this;
        }

        public AWSManagedRulesBotControlRuleSet build() {
            return new AWSManagedRulesBotControlRuleSet(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AWSManagedRulesBotControlRuleSet> {
        public Builder inspectionLevel(String var1);

        public Builder inspectionLevel(InspectionLevel var1);

        public Builder enableMachineLearning(Boolean var1);
    }
}

