/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains one or more regular expressions.
 * </p>
 * <p>
 * WAF assigns an ARN to each <code>RegexPatternSet</code> that you create. To use a set in a rule, you provide the ARN
 * to the <a>Rule</a> statement <a>RegexPatternSetReferenceStatement</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegexPatternSet implements SdkPojo, Serializable, ToCopyableBuilder<RegexPatternSet.Builder, RegexPatternSet> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(RegexPatternSet::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(RegexPatternSet::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ARN")
            .getter(getter(RegexPatternSet::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(RegexPatternSet::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<Regex>> REGULAR_EXPRESSION_LIST_FIELD = SdkField
            .<List<Regex>> builder(MarshallingType.LIST)
            .memberName("RegularExpressionList")
            .getter(getter(RegexPatternSet::regularExpressionList))
            .setter(setter(Builder::regularExpressionList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegularExpressionList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Regex> builder(MarshallingType.SDK_POJO)
                                            .constructor(Regex::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ID_FIELD,
            ARN_FIELD, DESCRIPTION_FIELD, REGULAR_EXPRESSION_LIST_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String id;

    private final String arn;

    private final String description;

    private final List<Regex> regularExpressionList;

    private RegexPatternSet(BuilderImpl builder) {
        this.name = builder.name;
        this.id = builder.id;
        this.arn = builder.arn;
        this.description = builder.description;
        this.regularExpressionList = builder.regularExpressionList;
    }

    /**
     * <p>
     * The name of the set. You cannot change the name after you create the set.
     * </p>
     * 
     * @return The name of the set. You cannot change the name after you create the set.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A unique identifier for the set. This ID is returned in the responses to create and list commands. You provide it
     * to operations like update and delete.
     * </p>
     * 
     * @return A unique identifier for the set. This ID is returned in the responses to create and list commands. You
     *         provide it to operations like update and delete.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the entity.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the entity.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * A description of the set that helps with identification.
     * </p>
     * 
     * @return A description of the set that helps with identification.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the RegularExpressionList property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRegularExpressionList() {
        return regularExpressionList != null && !(regularExpressionList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The regular expression patterns in the set.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRegularExpressionList} method.
     * </p>
     * 
     * @return The regular expression patterns in the set.
     */
    public final List<Regex> regularExpressionList() {
        return regularExpressionList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasRegularExpressionList() ? regularExpressionList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegexPatternSet)) {
            return false;
        }
        RegexPatternSet other = (RegexPatternSet) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn())
                && Objects.equals(description(), other.description())
                && hasRegularExpressionList() == other.hasRegularExpressionList()
                && Objects.equals(regularExpressionList(), other.regularExpressionList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegexPatternSet").add("Name", name()).add("Id", id()).add("ARN", arn())
                .add("Description", description())
                .add("RegularExpressionList", hasRegularExpressionList() ? regularExpressionList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "ARN":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "RegularExpressionList":
            return Optional.ofNullable(clazz.cast(regularExpressionList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegexPatternSet, T> g) {
        return obj -> g.apply((RegexPatternSet) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RegexPatternSet> {
        /**
         * <p>
         * The name of the set. You cannot change the name after you create the set.
         * </p>
         * 
         * @param name
         *        The name of the set. You cannot change the name after you create the set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A unique identifier for the set. This ID is returned in the responses to create and list commands. You
         * provide it to operations like update and delete.
         * </p>
         * 
         * @param id
         *        A unique identifier for the set. This ID is returned in the responses to create and list commands. You
         *        provide it to operations like update and delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the entity.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * A description of the set that helps with identification.
         * </p>
         * 
         * @param description
         *        A description of the set that helps with identification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The regular expression patterns in the set.
         * </p>
         * 
         * @param regularExpressionList
         *        The regular expression patterns in the set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regularExpressionList(Collection<Regex> regularExpressionList);

        /**
         * <p>
         * The regular expression patterns in the set.
         * </p>
         * 
         * @param regularExpressionList
         *        The regular expression patterns in the set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regularExpressionList(Regex... regularExpressionList);

        /**
         * <p>
         * The regular expression patterns in the set.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.wafv2.model.Regex.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.wafv2.model.Regex#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.wafv2.model.Regex.Builder#build()} is called immediately and its
         * result is passed to {@link #regularExpressionList(List<Regex>)}.
         * 
         * @param regularExpressionList
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.wafv2.model.Regex.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #regularExpressionList(java.util.Collection<Regex>)
         */
        Builder regularExpressionList(Consumer<Regex.Builder>... regularExpressionList);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String id;

        private String arn;

        private String description;

        private List<Regex> regularExpressionList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RegexPatternSet model) {
            name(model.name);
            id(model.id);
            arn(model.arn);
            description(model.description);
            regularExpressionList(model.regularExpressionList);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Regex.Builder> getRegularExpressionList() {
            List<Regex.Builder> result = RegularExpressionListCopier.copyToBuilder(this.regularExpressionList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRegularExpressionList(Collection<Regex.BuilderImpl> regularExpressionList) {
            this.regularExpressionList = RegularExpressionListCopier.copyFromBuilder(regularExpressionList);
        }

        @Override
        public final Builder regularExpressionList(Collection<Regex> regularExpressionList) {
            this.regularExpressionList = RegularExpressionListCopier.copy(regularExpressionList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regularExpressionList(Regex... regularExpressionList) {
            regularExpressionList(Arrays.asList(regularExpressionList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regularExpressionList(Consumer<Regex.Builder>... regularExpressionList) {
            regularExpressionList(Stream.of(regularExpressionList).map(c -> Regex.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public RegexPatternSet build() {
            return new RegexPatternSet(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
