/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details for your use of the account takeover prevention managed rule group, <code>AWSManagedRulesATPRuleSet</code>.
 * This configuration is used in <code>ManagedRuleGroupConfig</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AWSManagedRulesATPRuleSet implements SdkPojo, Serializable,
        ToCopyableBuilder<AWSManagedRulesATPRuleSet.Builder, AWSManagedRulesATPRuleSet> {
    private static final SdkField<String> LOGIN_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LoginPath").getter(getter(AWSManagedRulesATPRuleSet::loginPath)).setter(setter(Builder::loginPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoginPath").build()).build();

    private static final SdkField<RequestInspection> REQUEST_INSPECTION_FIELD = SdkField
            .<RequestInspection> builder(MarshallingType.SDK_POJO).memberName("RequestInspection")
            .getter(getter(AWSManagedRulesATPRuleSet::requestInspection)).setter(setter(Builder::requestInspection))
            .constructor(RequestInspection::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestInspection").build()).build();

    private static final SdkField<ResponseInspection> RESPONSE_INSPECTION_FIELD = SdkField
            .<ResponseInspection> builder(MarshallingType.SDK_POJO).memberName("ResponseInspection")
            .getter(getter(AWSManagedRulesATPRuleSet::responseInspection)).setter(setter(Builder::responseInspection))
            .constructor(ResponseInspection::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResponseInspection").build())
            .build();

    private static final SdkField<Boolean> ENABLE_REGEX_IN_PATH_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableRegexInPath").getter(getter(AWSManagedRulesATPRuleSet::enableRegexInPath))
            .setter(setter(Builder::enableRegexInPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableRegexInPath").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOGIN_PATH_FIELD,
            REQUEST_INSPECTION_FIELD, RESPONSE_INSPECTION_FIELD, ENABLE_REGEX_IN_PATH_FIELD));

    private static final long serialVersionUID = 1L;

    private final String loginPath;

    private final RequestInspection requestInspection;

    private final ResponseInspection responseInspection;

    private final Boolean enableRegexInPath;

    private AWSManagedRulesATPRuleSet(BuilderImpl builder) {
        this.loginPath = builder.loginPath;
        this.requestInspection = builder.requestInspection;
        this.responseInspection = builder.responseInspection;
        this.enableRegexInPath = builder.enableRegexInPath;
    }

    /**
     * <p>
     * The path of the login endpoint for your application. For example, for the URL
     * <code>https://example.com/web/login</code>, you would provide the path <code>/web/login</code>. Login paths that
     * start with the path that you provide are considered a match. For example <code>/web/login</code> matches the
     * login paths <code>/web/login</code>, <code>/web/login/</code>, <code>/web/loginPage</code>, and
     * <code>/web/login/thisPage</code>, but doesn't match the login path <code>/home/web/login</code> or
     * <code>/website/login</code>.
     * </p>
     * <p>
     * The rule group inspects only HTTP <code>POST</code> requests to your specified login endpoint.
     * </p>
     * 
     * @return The path of the login endpoint for your application. For example, for the URL
     *         <code>https://example.com/web/login</code>, you would provide the path <code>/web/login</code>. Login
     *         paths that start with the path that you provide are considered a match. For example
     *         <code>/web/login</code> matches the login paths <code>/web/login</code>, <code>/web/login/</code>,
     *         <code>/web/loginPage</code>, and <code>/web/login/thisPage</code>, but doesn't match the login path
     *         <code>/home/web/login</code> or <code>/website/login</code>.</p>
     *         <p>
     *         The rule group inspects only HTTP <code>POST</code> requests to your specified login endpoint.
     */
    public final String loginPath() {
        return loginPath;
    }

    /**
     * <p>
     * The criteria for inspecting login requests, used by the ATP rule group to validate credentials usage.
     * </p>
     * 
     * @return The criteria for inspecting login requests, used by the ATP rule group to validate credentials usage.
     */
    public final RequestInspection requestInspection() {
        return requestInspection;
    }

    /**
     * <p>
     * The criteria for inspecting responses to login requests, used by the ATP rule group to track login failure rates.
     * </p>
     * <note>
     * <p>
     * Response inspection is available only in web ACLs that protect Amazon CloudFront distributions.
     * </p>
     * </note>
     * <p>
     * The ATP rule group evaluates the responses that your protected resources send back to client login attempts,
     * keeping count of successful and failed attempts for each IP address and client session. Using this information,
     * the rule group labels and mitigates requests from client sessions and IP addresses that have had too many failed
     * login attempts in a short amount of time.
     * </p>
     * 
     * @return The criteria for inspecting responses to login requests, used by the ATP rule group to track login
     *         failure rates. </p> <note>
     *         <p>
     *         Response inspection is available only in web ACLs that protect Amazon CloudFront distributions.
     *         </p>
     *         </note>
     *         <p>
     *         The ATP rule group evaluates the responses that your protected resources send back to client login
     *         attempts, keeping count of successful and failed attempts for each IP address and client session. Using
     *         this information, the rule group labels and mitigates requests from client sessions and IP addresses that
     *         have had too many failed login attempts in a short amount of time.
     */
    public final ResponseInspection responseInspection() {
        return responseInspection;
    }

    /**
     * <p>
     * Allow the use of regular expressions in the login page path.
     * </p>
     * 
     * @return Allow the use of regular expressions in the login page path.
     */
    public final Boolean enableRegexInPath() {
        return enableRegexInPath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(loginPath());
        hashCode = 31 * hashCode + Objects.hashCode(requestInspection());
        hashCode = 31 * hashCode + Objects.hashCode(responseInspection());
        hashCode = 31 * hashCode + Objects.hashCode(enableRegexInPath());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AWSManagedRulesATPRuleSet)) {
            return false;
        }
        AWSManagedRulesATPRuleSet other = (AWSManagedRulesATPRuleSet) obj;
        return Objects.equals(loginPath(), other.loginPath()) && Objects.equals(requestInspection(), other.requestInspection())
                && Objects.equals(responseInspection(), other.responseInspection())
                && Objects.equals(enableRegexInPath(), other.enableRegexInPath());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AWSManagedRulesATPRuleSet").add("LoginPath", loginPath())
                .add("RequestInspection", requestInspection()).add("ResponseInspection", responseInspection())
                .add("EnableRegexInPath", enableRegexInPath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LoginPath":
            return Optional.ofNullable(clazz.cast(loginPath()));
        case "RequestInspection":
            return Optional.ofNullable(clazz.cast(requestInspection()));
        case "ResponseInspection":
            return Optional.ofNullable(clazz.cast(responseInspection()));
        case "EnableRegexInPath":
            return Optional.ofNullable(clazz.cast(enableRegexInPath()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AWSManagedRulesATPRuleSet, T> g) {
        return obj -> g.apply((AWSManagedRulesATPRuleSet) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AWSManagedRulesATPRuleSet> {
        /**
         * <p>
         * The path of the login endpoint for your application. For example, for the URL
         * <code>https://example.com/web/login</code>, you would provide the path <code>/web/login</code>. Login paths
         * that start with the path that you provide are considered a match. For example <code>/web/login</code> matches
         * the login paths <code>/web/login</code>, <code>/web/login/</code>, <code>/web/loginPage</code>, and
         * <code>/web/login/thisPage</code>, but doesn't match the login path <code>/home/web/login</code> or
         * <code>/website/login</code>.
         * </p>
         * <p>
         * The rule group inspects only HTTP <code>POST</code> requests to your specified login endpoint.
         * </p>
         * 
         * @param loginPath
         *        The path of the login endpoint for your application. For example, for the URL
         *        <code>https://example.com/web/login</code>, you would provide the path <code>/web/login</code>. Login
         *        paths that start with the path that you provide are considered a match. For example
         *        <code>/web/login</code> matches the login paths <code>/web/login</code>, <code>/web/login/</code>,
         *        <code>/web/loginPage</code>, and <code>/web/login/thisPage</code>, but doesn't match the login path
         *        <code>/home/web/login</code> or <code>/website/login</code>.</p>
         *        <p>
         *        The rule group inspects only HTTP <code>POST</code> requests to your specified login endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loginPath(String loginPath);

        /**
         * <p>
         * The criteria for inspecting login requests, used by the ATP rule group to validate credentials usage.
         * </p>
         * 
         * @param requestInspection
         *        The criteria for inspecting login requests, used by the ATP rule group to validate credentials usage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestInspection(RequestInspection requestInspection);

        /**
         * <p>
         * The criteria for inspecting login requests, used by the ATP rule group to validate credentials usage.
         * </p>
         * This is a convenience method that creates an instance of the {@link RequestInspection.Builder} avoiding the
         * need to create one manually via {@link RequestInspection#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RequestInspection.Builder#build()} is called immediately and its
         * result is passed to {@link #requestInspection(RequestInspection)}.
         * 
         * @param requestInspection
         *        a consumer that will call methods on {@link RequestInspection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #requestInspection(RequestInspection)
         */
        default Builder requestInspection(Consumer<RequestInspection.Builder> requestInspection) {
            return requestInspection(RequestInspection.builder().applyMutation(requestInspection).build());
        }

        /**
         * <p>
         * The criteria for inspecting responses to login requests, used by the ATP rule group to track login failure
         * rates.
         * </p>
         * <note>
         * <p>
         * Response inspection is available only in web ACLs that protect Amazon CloudFront distributions.
         * </p>
         * </note>
         * <p>
         * The ATP rule group evaluates the responses that your protected resources send back to client login attempts,
         * keeping count of successful and failed attempts for each IP address and client session. Using this
         * information, the rule group labels and mitigates requests from client sessions and IP addresses that have had
         * too many failed login attempts in a short amount of time.
         * </p>
         * 
         * @param responseInspection
         *        The criteria for inspecting responses to login requests, used by the ATP rule group to track login
         *        failure rates. </p> <note>
         *        <p>
         *        Response inspection is available only in web ACLs that protect Amazon CloudFront distributions.
         *        </p>
         *        </note>
         *        <p>
         *        The ATP rule group evaluates the responses that your protected resources send back to client login
         *        attempts, keeping count of successful and failed attempts for each IP address and client session.
         *        Using this information, the rule group labels and mitigates requests from client sessions and IP
         *        addresses that have had too many failed login attempts in a short amount of time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseInspection(ResponseInspection responseInspection);

        /**
         * <p>
         * The criteria for inspecting responses to login requests, used by the ATP rule group to track login failure
         * rates.
         * </p>
         * <note>
         * <p>
         * Response inspection is available only in web ACLs that protect Amazon CloudFront distributions.
         * </p>
         * </note>
         * <p>
         * The ATP rule group evaluates the responses that your protected resources send back to client login attempts,
         * keeping count of successful and failed attempts for each IP address and client session. Using this
         * information, the rule group labels and mitigates requests from client sessions and IP addresses that have had
         * too many failed login attempts in a short amount of time.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResponseInspection.Builder} avoiding the
         * need to create one manually via {@link ResponseInspection#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResponseInspection.Builder#build()} is called immediately and its
         * result is passed to {@link #responseInspection(ResponseInspection)}.
         * 
         * @param responseInspection
         *        a consumer that will call methods on {@link ResponseInspection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #responseInspection(ResponseInspection)
         */
        default Builder responseInspection(Consumer<ResponseInspection.Builder> responseInspection) {
            return responseInspection(ResponseInspection.builder().applyMutation(responseInspection).build());
        }

        /**
         * <p>
         * Allow the use of regular expressions in the login page path.
         * </p>
         * 
         * @param enableRegexInPath
         *        Allow the use of regular expressions in the login page path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableRegexInPath(Boolean enableRegexInPath);
    }

    static final class BuilderImpl implements Builder {
        private String loginPath;

        private RequestInspection requestInspection;

        private ResponseInspection responseInspection;

        private Boolean enableRegexInPath;

        private BuilderImpl() {
        }

        private BuilderImpl(AWSManagedRulesATPRuleSet model) {
            loginPath(model.loginPath);
            requestInspection(model.requestInspection);
            responseInspection(model.responseInspection);
            enableRegexInPath(model.enableRegexInPath);
        }

        public final String getLoginPath() {
            return loginPath;
        }

        public final void setLoginPath(String loginPath) {
            this.loginPath = loginPath;
        }

        @Override
        public final Builder loginPath(String loginPath) {
            this.loginPath = loginPath;
            return this;
        }

        public final RequestInspection.Builder getRequestInspection() {
            return requestInspection != null ? requestInspection.toBuilder() : null;
        }

        public final void setRequestInspection(RequestInspection.BuilderImpl requestInspection) {
            this.requestInspection = requestInspection != null ? requestInspection.build() : null;
        }

        @Override
        public final Builder requestInspection(RequestInspection requestInspection) {
            this.requestInspection = requestInspection;
            return this;
        }

        public final ResponseInspection.Builder getResponseInspection() {
            return responseInspection != null ? responseInspection.toBuilder() : null;
        }

        public final void setResponseInspection(ResponseInspection.BuilderImpl responseInspection) {
            this.responseInspection = responseInspection != null ? responseInspection.build() : null;
        }

        @Override
        public final Builder responseInspection(ResponseInspection responseInspection) {
            this.responseInspection = responseInspection;
            return this;
        }

        public final Boolean getEnableRegexInPath() {
            return enableRegexInPath;
        }

        public final void setEnableRegexInPath(Boolean enableRegexInPath) {
            this.enableRegexInPath = enableRegexInPath;
        }

        @Override
        public final Builder enableRegexInPath(Boolean enableRegexInPath) {
            this.enableRegexInPath = enableRegexInPath;
            return this;
        }

        @Override
        public AWSManagedRulesATPRuleSet build() {
            return new AWSManagedRulesATPRuleSet(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
