/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeManagedRuleGroupResponse extends Wafv2Response implements
        ToCopyableBuilder<DescribeManagedRuleGroupResponse.Builder, DescribeManagedRuleGroupResponse> {
    private static final SdkField<String> VERSION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VersionName").getter(getter(DescribeManagedRuleGroupResponse::versionName))
            .setter(setter(Builder::versionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionName").build()).build();

    private static final SdkField<String> SNS_TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnsTopicArn").getter(getter(DescribeManagedRuleGroupResponse::snsTopicArn))
            .setter(setter(Builder::snsTopicArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsTopicArn").build()).build();

    private static final SdkField<Long> CAPACITY_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Capacity")
            .getter(getter(DescribeManagedRuleGroupResponse::capacity)).setter(setter(Builder::capacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capacity").build()).build();

    private static final SdkField<List<RuleSummary>> RULES_FIELD = SdkField
            .<List<RuleSummary>> builder(MarshallingType.LIST)
            .memberName("Rules")
            .getter(getter(DescribeManagedRuleGroupResponse::rules))
            .setter(setter(Builder::rules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RuleSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(RuleSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LABEL_NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LabelNamespace").getter(getter(DescribeManagedRuleGroupResponse::labelNamespace))
            .setter(setter(Builder::labelNamespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelNamespace").build()).build();

    private static final SdkField<List<LabelSummary>> AVAILABLE_LABELS_FIELD = SdkField
            .<List<LabelSummary>> builder(MarshallingType.LIST)
            .memberName("AvailableLabels")
            .getter(getter(DescribeManagedRuleGroupResponse::availableLabels))
            .setter(setter(Builder::availableLabels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailableLabels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LabelSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(LabelSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<LabelSummary>> CONSUMED_LABELS_FIELD = SdkField
            .<List<LabelSummary>> builder(MarshallingType.LIST)
            .memberName("ConsumedLabels")
            .getter(getter(DescribeManagedRuleGroupResponse::consumedLabels))
            .setter(setter(Builder::consumedLabels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumedLabels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LabelSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(LabelSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERSION_NAME_FIELD,
            SNS_TOPIC_ARN_FIELD, CAPACITY_FIELD, RULES_FIELD, LABEL_NAMESPACE_FIELD, AVAILABLE_LABELS_FIELD,
            CONSUMED_LABELS_FIELD));

    private final String versionName;

    private final String snsTopicArn;

    private final Long capacity;

    private final List<RuleSummary> rules;

    private final String labelNamespace;

    private final List<LabelSummary> availableLabels;

    private final List<LabelSummary> consumedLabels;

    private DescribeManagedRuleGroupResponse(BuilderImpl builder) {
        super(builder);
        this.versionName = builder.versionName;
        this.snsTopicArn = builder.snsTopicArn;
        this.capacity = builder.capacity;
        this.rules = builder.rules;
        this.labelNamespace = builder.labelNamespace;
        this.availableLabels = builder.availableLabels;
        this.consumedLabels = builder.consumedLabels;
    }

    /**
     * <p>
     * The managed rule group's version.
     * </p>
     * 
     * @return The managed rule group's version.
     */
    public final String versionName() {
        return versionName;
    }

    /**
     * <p>
     * The Amazon resource name (ARN) of the Amazon Simple Notification Service SNS topic that's used to record changes
     * to the managed rule group. You can subscribe to the SNS topic to receive notifications when the managed rule
     * group is modified, such as for new versions and for version expiration. For more information, see the <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/welcome.html">Amazon Simple Notification Service Developer
     * Guide</a>.
     * </p>
     * 
     * @return The Amazon resource name (ARN) of the Amazon Simple Notification Service SNS topic that's used to record
     *         changes to the managed rule group. You can subscribe to the SNS topic to receive notifications when the
     *         managed rule group is modified, such as for new versions and for version expiration. For more
     *         information, see the <a href="https://docs.aws.amazon.com/sns/latest/dg/welcome.html">Amazon Simple
     *         Notification Service Developer Guide</a>.
     */
    public final String snsTopicArn() {
        return snsTopicArn;
    }

    /**
     * <p>
     * The web ACL capacity units (WCUs) required for this rule group.
     * </p>
     * <p>
     * WAF uses WCUs to calculate and control the operating resources that are used to run your rules, rule groups, and
     * web ACLs. WAF calculates capacity differently for each rule type, to reflect the relative cost of each rule.
     * Simple rules that cost little to run use fewer WCUs than more complex rules that use more processing power. Rule
     * group capacity is fixed at creation, which helps users plan their web ACL WCU usage when they use a rule group.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/aws-waf-capacity-units.html">WAF web ACL capacity
     * units (WCU)</a> in the <i>WAF Developer Guide</i>.
     * </p>
     * 
     * @return The web ACL capacity units (WCUs) required for this rule group.</p>
     *         <p>
     *         WAF uses WCUs to calculate and control the operating resources that are used to run your rules, rule
     *         groups, and web ACLs. WAF calculates capacity differently for each rule type, to reflect the relative
     *         cost of each rule. Simple rules that cost little to run use fewer WCUs than more complex rules that use
     *         more processing power. Rule group capacity is fixed at creation, which helps users plan their web ACL WCU
     *         usage when they use a rule group. For more information, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/aws-waf-capacity-units.html">WAF web ACL
     *         capacity units (WCU)</a> in the <i>WAF Developer Guide</i>.
     */
    public final Long capacity() {
        return capacity;
    }

    /**
     * For responses, this returns true if the service returned a value for the Rules property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasRules() {
        return rules != null && !(rules instanceof SdkAutoConstructList);
    }

    /**
     * <p/>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRules} method.
     * </p>
     * 
     * @return
     */
    public final List<RuleSummary> rules() {
        return rules;
    }

    /**
     * <p>
     * The label namespace prefix for this rule group. All labels added by rules in this rule group have this prefix.
     * </p>
     * <ul>
     * <li>
     * <p>
     * The syntax for the label namespace prefix for a managed rule group is the following:
     * </p>
     * <p>
     * <code>awswaf:managed:&lt;vendor&gt;:&lt;rule group name&gt;</code>:
     * </p>
     * </li>
     * <li>
     * <p>
     * When a rule with a label matches a web request, WAF adds the fully qualified label to the request. A fully
     * qualified label is made up of the label namespace from the rule group or web ACL where the rule is defined and
     * the label from the rule, separated by a colon:
     * </p>
     * <p>
     * <code>&lt;label namespace&gt;:&lt;label from rule&gt;</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The label namespace prefix for this rule group. All labels added by rules in this rule group have this
     *         prefix. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The syntax for the label namespace prefix for a managed rule group is the following:
     *         </p>
     *         <p>
     *         <code>awswaf:managed:&lt;vendor&gt;:&lt;rule group name&gt;</code>:
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         When a rule with a label matches a web request, WAF adds the fully qualified label to the request. A
     *         fully qualified label is made up of the label namespace from the rule group or web ACL where the rule is
     *         defined and the label from the rule, separated by a colon:
     *         </p>
     *         <p>
     *         <code>&lt;label namespace&gt;:&lt;label from rule&gt;</code>
     *         </p>
     *         </li>
     */
    public final String labelNamespace() {
        return labelNamespace;
    }

    /**
     * For responses, this returns true if the service returned a value for the AvailableLabels property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAvailableLabels() {
        return availableLabels != null && !(availableLabels instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The labels that one or more rules in this rule group add to matching web requests. These labels are defined in
     * the <code>RuleLabels</code> for a <a>Rule</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAvailableLabels} method.
     * </p>
     * 
     * @return The labels that one or more rules in this rule group add to matching web requests. These labels are
     *         defined in the <code>RuleLabels</code> for a <a>Rule</a>.
     */
    public final List<LabelSummary> availableLabels() {
        return availableLabels;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConsumedLabels property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasConsumedLabels() {
        return consumedLabels != null && !(consumedLabels instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The labels that one or more rules in this rule group match against in label match statements. These labels are
     * defined in a <code>LabelMatchStatement</code> specification, in the <a>Statement</a> definition of a rule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConsumedLabels} method.
     * </p>
     * 
     * @return The labels that one or more rules in this rule group match against in label match statements. These
     *         labels are defined in a <code>LabelMatchStatement</code> specification, in the <a>Statement</a>
     *         definition of a rule.
     */
    public final List<LabelSummary> consumedLabels() {
        return consumedLabels;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(versionName());
        hashCode = 31 * hashCode + Objects.hashCode(snsTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(capacity());
        hashCode = 31 * hashCode + Objects.hashCode(hasRules() ? rules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(labelNamespace());
        hashCode = 31 * hashCode + Objects.hashCode(hasAvailableLabels() ? availableLabels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasConsumedLabels() ? consumedLabels() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeManagedRuleGroupResponse)) {
            return false;
        }
        DescribeManagedRuleGroupResponse other = (DescribeManagedRuleGroupResponse) obj;
        return Objects.equals(versionName(), other.versionName()) && Objects.equals(snsTopicArn(), other.snsTopicArn())
                && Objects.equals(capacity(), other.capacity()) && hasRules() == other.hasRules()
                && Objects.equals(rules(), other.rules()) && Objects.equals(labelNamespace(), other.labelNamespace())
                && hasAvailableLabels() == other.hasAvailableLabels()
                && Objects.equals(availableLabels(), other.availableLabels()) && hasConsumedLabels() == other.hasConsumedLabels()
                && Objects.equals(consumedLabels(), other.consumedLabels());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeManagedRuleGroupResponse").add("VersionName", versionName())
                .add("SnsTopicArn", snsTopicArn()).add("Capacity", capacity()).add("Rules", hasRules() ? rules() : null)
                .add("LabelNamespace", labelNamespace()).add("AvailableLabels", hasAvailableLabels() ? availableLabels() : null)
                .add("ConsumedLabels", hasConsumedLabels() ? consumedLabels() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VersionName":
            return Optional.ofNullable(clazz.cast(versionName()));
        case "SnsTopicArn":
            return Optional.ofNullable(clazz.cast(snsTopicArn()));
        case "Capacity":
            return Optional.ofNullable(clazz.cast(capacity()));
        case "Rules":
            return Optional.ofNullable(clazz.cast(rules()));
        case "LabelNamespace":
            return Optional.ofNullable(clazz.cast(labelNamespace()));
        case "AvailableLabels":
            return Optional.ofNullable(clazz.cast(availableLabels()));
        case "ConsumedLabels":
            return Optional.ofNullable(clazz.cast(consumedLabels()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeManagedRuleGroupResponse, T> g) {
        return obj -> g.apply((DescribeManagedRuleGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Wafv2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeManagedRuleGroupResponse> {
        /**
         * <p>
         * The managed rule group's version.
         * </p>
         * 
         * @param versionName
         *        The managed rule group's version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionName(String versionName);

        /**
         * <p>
         * The Amazon resource name (ARN) of the Amazon Simple Notification Service SNS topic that's used to record
         * changes to the managed rule group. You can subscribe to the SNS topic to receive notifications when the
         * managed rule group is modified, such as for new versions and for version expiration. For more information,
         * see the <a href="https://docs.aws.amazon.com/sns/latest/dg/welcome.html">Amazon Simple Notification Service
         * Developer Guide</a>.
         * </p>
         * 
         * @param snsTopicArn
         *        The Amazon resource name (ARN) of the Amazon Simple Notification Service SNS topic that's used to
         *        record changes to the managed rule group. You can subscribe to the SNS topic to receive notifications
         *        when the managed rule group is modified, such as for new versions and for version expiration. For more
         *        information, see the <a href="https://docs.aws.amazon.com/sns/latest/dg/welcome.html">Amazon Simple
         *        Notification Service Developer Guide</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsTopicArn(String snsTopicArn);

        /**
         * <p>
         * The web ACL capacity units (WCUs) required for this rule group.
         * </p>
         * <p>
         * WAF uses WCUs to calculate and control the operating resources that are used to run your rules, rule groups,
         * and web ACLs. WAF calculates capacity differently for each rule type, to reflect the relative cost of each
         * rule. Simple rules that cost little to run use fewer WCUs than more complex rules that use more processing
         * power. Rule group capacity is fixed at creation, which helps users plan their web ACL WCU usage when they use
         * a rule group. For more information, see <a
         * href="https://docs.aws.amazon.com/waf/latest/developerguide/aws-waf-capacity-units.html">WAF web ACL capacity
         * units (WCU)</a> in the <i>WAF Developer Guide</i>.
         * </p>
         * 
         * @param capacity
         *        The web ACL capacity units (WCUs) required for this rule group.</p>
         *        <p>
         *        WAF uses WCUs to calculate and control the operating resources that are used to run your rules, rule
         *        groups, and web ACLs. WAF calculates capacity differently for each rule type, to reflect the relative
         *        cost of each rule. Simple rules that cost little to run use fewer WCUs than more complex rules that
         *        use more processing power. Rule group capacity is fixed at creation, which helps users plan their web
         *        ACL WCU usage when they use a rule group. For more information, see <a
         *        href="https://docs.aws.amazon.com/waf/latest/developerguide/aws-waf-capacity-units.html">WAF web ACL
         *        capacity units (WCU)</a> in the <i>WAF Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacity(Long capacity);

        /**
         * <p/>
         * 
         * @param rules
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Collection<RuleSummary> rules);

        /**
         * <p/>
         * 
         * @param rules
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(RuleSummary... rules);

        /**
         * <p/>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.wafv2.model.RuleSummary.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.wafv2.model.RuleSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.wafv2.model.RuleSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #rules(List<RuleSummary>)}.
         * 
         * @param rules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.wafv2.model.RuleSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rules(java.util.Collection<RuleSummary>)
         */
        Builder rules(Consumer<RuleSummary.Builder>... rules);

        /**
         * <p>
         * The label namespace prefix for this rule group. All labels added by rules in this rule group have this
         * prefix.
         * </p>
         * <ul>
         * <li>
         * <p>
         * The syntax for the label namespace prefix for a managed rule group is the following:
         * </p>
         * <p>
         * <code>awswaf:managed:&lt;vendor&gt;:&lt;rule group name&gt;</code>:
         * </p>
         * </li>
         * <li>
         * <p>
         * When a rule with a label matches a web request, WAF adds the fully qualified label to the request. A fully
         * qualified label is made up of the label namespace from the rule group or web ACL where the rule is defined
         * and the label from the rule, separated by a colon:
         * </p>
         * <p>
         * <code>&lt;label namespace&gt;:&lt;label from rule&gt;</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param labelNamespace
         *        The label namespace prefix for this rule group. All labels added by rules in this rule group have this
         *        prefix. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The syntax for the label namespace prefix for a managed rule group is the following:
         *        </p>
         *        <p>
         *        <code>awswaf:managed:&lt;vendor&gt;:&lt;rule group name&gt;</code>:
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        When a rule with a label matches a web request, WAF adds the fully qualified label to the request. A
         *        fully qualified label is made up of the label namespace from the rule group or web ACL where the rule
         *        is defined and the label from the rule, separated by a colon:
         *        </p>
         *        <p>
         *        <code>&lt;label namespace&gt;:&lt;label from rule&gt;</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelNamespace(String labelNamespace);

        /**
         * <p>
         * The labels that one or more rules in this rule group add to matching web requests. These labels are defined
         * in the <code>RuleLabels</code> for a <a>Rule</a>.
         * </p>
         * 
         * @param availableLabels
         *        The labels that one or more rules in this rule group add to matching web requests. These labels are
         *        defined in the <code>RuleLabels</code> for a <a>Rule</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availableLabels(Collection<LabelSummary> availableLabels);

        /**
         * <p>
         * The labels that one or more rules in this rule group add to matching web requests. These labels are defined
         * in the <code>RuleLabels</code> for a <a>Rule</a>.
         * </p>
         * 
         * @param availableLabels
         *        The labels that one or more rules in this rule group add to matching web requests. These labels are
         *        defined in the <code>RuleLabels</code> for a <a>Rule</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availableLabels(LabelSummary... availableLabels);

        /**
         * <p>
         * The labels that one or more rules in this rule group add to matching web requests. These labels are defined
         * in the <code>RuleLabels</code> for a <a>Rule</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.wafv2.model.LabelSummary.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.wafv2.model.LabelSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.wafv2.model.LabelSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #availableLabels(List<LabelSummary>)}.
         * 
         * @param availableLabels
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.wafv2.model.LabelSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #availableLabels(java.util.Collection<LabelSummary>)
         */
        Builder availableLabels(Consumer<LabelSummary.Builder>... availableLabels);

        /**
         * <p>
         * The labels that one or more rules in this rule group match against in label match statements. These labels
         * are defined in a <code>LabelMatchStatement</code> specification, in the <a>Statement</a> definition of a
         * rule.
         * </p>
         * 
         * @param consumedLabels
         *        The labels that one or more rules in this rule group match against in label match statements. These
         *        labels are defined in a <code>LabelMatchStatement</code> specification, in the <a>Statement</a>
         *        definition of a rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumedLabels(Collection<LabelSummary> consumedLabels);

        /**
         * <p>
         * The labels that one or more rules in this rule group match against in label match statements. These labels
         * are defined in a <code>LabelMatchStatement</code> specification, in the <a>Statement</a> definition of a
         * rule.
         * </p>
         * 
         * @param consumedLabels
         *        The labels that one or more rules in this rule group match against in label match statements. These
         *        labels are defined in a <code>LabelMatchStatement</code> specification, in the <a>Statement</a>
         *        definition of a rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumedLabels(LabelSummary... consumedLabels);

        /**
         * <p>
         * The labels that one or more rules in this rule group match against in label match statements. These labels
         * are defined in a <code>LabelMatchStatement</code> specification, in the <a>Statement</a> definition of a
         * rule.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.wafv2.model.LabelSummary.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.wafv2.model.LabelSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.wafv2.model.LabelSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #consumedLabels(List<LabelSummary>)}.
         * 
         * @param consumedLabels
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.wafv2.model.LabelSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #consumedLabels(java.util.Collection<LabelSummary>)
         */
        Builder consumedLabels(Consumer<LabelSummary.Builder>... consumedLabels);
    }

    static final class BuilderImpl extends Wafv2Response.BuilderImpl implements Builder {
        private String versionName;

        private String snsTopicArn;

        private Long capacity;

        private List<RuleSummary> rules = DefaultSdkAutoConstructList.getInstance();

        private String labelNamespace;

        private List<LabelSummary> availableLabels = DefaultSdkAutoConstructList.getInstance();

        private List<LabelSummary> consumedLabels = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeManagedRuleGroupResponse model) {
            super(model);
            versionName(model.versionName);
            snsTopicArn(model.snsTopicArn);
            capacity(model.capacity);
            rules(model.rules);
            labelNamespace(model.labelNamespace);
            availableLabels(model.availableLabels);
            consumedLabels(model.consumedLabels);
        }

        public final String getVersionName() {
            return versionName;
        }

        public final void setVersionName(String versionName) {
            this.versionName = versionName;
        }

        @Override
        public final Builder versionName(String versionName) {
            this.versionName = versionName;
            return this;
        }

        public final String getSnsTopicArn() {
            return snsTopicArn;
        }

        public final void setSnsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
        }

        @Override
        public final Builder snsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
            return this;
        }

        public final Long getCapacity() {
            return capacity;
        }

        public final void setCapacity(Long capacity) {
            this.capacity = capacity;
        }

        @Override
        public final Builder capacity(Long capacity) {
            this.capacity = capacity;
            return this;
        }

        public final List<RuleSummary.Builder> getRules() {
            List<RuleSummary.Builder> result = RuleSummariesCopier.copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRules(Collection<RuleSummary.BuilderImpl> rules) {
            this.rules = RuleSummariesCopier.copyFromBuilder(rules);
        }

        @Override
        public final Builder rules(Collection<RuleSummary> rules) {
            this.rules = RuleSummariesCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(RuleSummary... rules) {
            rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<RuleSummary.Builder>... rules) {
            rules(Stream.of(rules).map(c -> RuleSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getLabelNamespace() {
            return labelNamespace;
        }

        public final void setLabelNamespace(String labelNamespace) {
            this.labelNamespace = labelNamespace;
        }

        @Override
        public final Builder labelNamespace(String labelNamespace) {
            this.labelNamespace = labelNamespace;
            return this;
        }

        public final List<LabelSummary.Builder> getAvailableLabels() {
            List<LabelSummary.Builder> result = LabelSummariesCopier.copyToBuilder(this.availableLabels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAvailableLabels(Collection<LabelSummary.BuilderImpl> availableLabels) {
            this.availableLabels = LabelSummariesCopier.copyFromBuilder(availableLabels);
        }

        @Override
        public final Builder availableLabels(Collection<LabelSummary> availableLabels) {
            this.availableLabels = LabelSummariesCopier.copy(availableLabels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availableLabels(LabelSummary... availableLabels) {
            availableLabels(Arrays.asList(availableLabels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availableLabels(Consumer<LabelSummary.Builder>... availableLabels) {
            availableLabels(Stream.of(availableLabels).map(c -> LabelSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<LabelSummary.Builder> getConsumedLabels() {
            List<LabelSummary.Builder> result = LabelSummariesCopier.copyToBuilder(this.consumedLabels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConsumedLabels(Collection<LabelSummary.BuilderImpl> consumedLabels) {
            this.consumedLabels = LabelSummariesCopier.copyFromBuilder(consumedLabels);
        }

        @Override
        public final Builder consumedLabels(Collection<LabelSummary> consumedLabels) {
            this.consumedLabels = LabelSummariesCopier.copy(consumedLabels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder consumedLabels(LabelSummary... consumedLabels) {
            consumedLabels(Arrays.asList(consumedLabels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder consumedLabels(Consumer<LabelSummary.Builder>... consumedLabels) {
            consumedLabels(Stream.of(consumedLabels).map(c -> LabelSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeManagedRuleGroupResponse build() {
            return new DescribeManagedRuleGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
