/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wafv2.model.ManagedProductDescriptor;
import software.amazon.awssdk.services.wafv2.model.ManagedProductDescriptorsCopier;
import software.amazon.awssdk.services.wafv2.model.Wafv2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAllManagedProductsResponse
extends Wafv2Response
implements ToCopyableBuilder<Builder, DescribeAllManagedProductsResponse> {
    private static final SdkField<List<ManagedProductDescriptor>> MANAGED_PRODUCTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ManagedProducts").getter(DescribeAllManagedProductsResponse.getter(DescribeAllManagedProductsResponse::managedProducts)).setter(DescribeAllManagedProductsResponse.setter(Builder::managedProducts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedProducts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ManagedProductDescriptor::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANAGED_PRODUCTS_FIELD));
    private final List<ManagedProductDescriptor> managedProducts;

    private DescribeAllManagedProductsResponse(BuilderImpl builder) {
        super(builder);
        this.managedProducts = builder.managedProducts;
    }

    public final boolean hasManagedProducts() {
        return this.managedProducts != null && !(this.managedProducts instanceof SdkAutoConstructList);
    }

    public final List<ManagedProductDescriptor> managedProducts() {
        return this.managedProducts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasManagedProducts() ? this.managedProducts() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAllManagedProductsResponse)) {
            return false;
        }
        DescribeAllManagedProductsResponse other = (DescribeAllManagedProductsResponse)((Object)obj);
        return this.hasManagedProducts() == other.hasManagedProducts() && Objects.equals(this.managedProducts(), other.managedProducts());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAllManagedProductsResponse").add("ManagedProducts", this.hasManagedProducts() ? this.managedProducts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ManagedProducts": {
                return Optional.ofNullable(clazz.cast(this.managedProducts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAllManagedProductsResponse, T> g) {
        return obj -> g.apply((DescribeAllManagedProductsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Wafv2Response.BuilderImpl
    implements Builder {
        private List<ManagedProductDescriptor> managedProducts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAllManagedProductsResponse model) {
            super(model);
            this.managedProducts(model.managedProducts);
        }

        public final List<ManagedProductDescriptor.Builder> getManagedProducts() {
            List<ManagedProductDescriptor.Builder> result = ManagedProductDescriptorsCopier.copyToBuilder(this.managedProducts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setManagedProducts(Collection<ManagedProductDescriptor.BuilderImpl> managedProducts) {
            this.managedProducts = ManagedProductDescriptorsCopier.copyFromBuilder(managedProducts);
        }

        @Override
        public final Builder managedProducts(Collection<ManagedProductDescriptor> managedProducts) {
            this.managedProducts = ManagedProductDescriptorsCopier.copy(managedProducts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedProducts(ManagedProductDescriptor ... managedProducts) {
            this.managedProducts(Arrays.asList(managedProducts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedProducts(Consumer<ManagedProductDescriptor.Builder> ... managedProducts) {
            this.managedProducts(Stream.of(managedProducts).map(c -> (ManagedProductDescriptor)((ManagedProductDescriptor.Builder)ManagedProductDescriptor.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeAllManagedProductsResponse build() {
            return new DescribeAllManagedProductsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Wafv2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAllManagedProductsResponse> {
        public Builder managedProducts(Collection<ManagedProductDescriptor> var1);

        public Builder managedProducts(ManagedProductDescriptor ... var1);

        public Builder managedProducts(Consumer<ManagedProductDescriptor.Builder> ... var1);
    }
}

