/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wafv2.model.TokenDomainsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class APIKeySummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, APIKeySummary> {
    private static final SdkField<List<String>> TOKEN_DOMAINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TokenDomains").getter(APIKeySummary.getter(APIKeySummary::tokenDomains)).setter(APIKeySummary.setter(Builder::tokenDomains)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TokenDomains").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> API_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("APIKey").getter(APIKeySummary.getter(APIKeySummary::apiKey)).setter(APIKeySummary.setter(Builder::apiKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("APIKey").build()}).build();
    private static final SdkField<Instant> CREATION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTimestamp").getter(APIKeySummary.getter(APIKeySummary::creationTimestamp)).setter(APIKeySummary.setter(Builder::creationTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimestamp").build()}).build();
    private static final SdkField<Integer> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Version").getter(APIKeySummary.getter(APIKeySummary::version)).setter(APIKeySummary.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOKEN_DOMAINS_FIELD, API_KEY_FIELD, CREATION_TIMESTAMP_FIELD, VERSION_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> tokenDomains;
    private final String apiKey;
    private final Instant creationTimestamp;
    private final Integer version;

    private APIKeySummary(BuilderImpl builder) {
        this.tokenDomains = builder.tokenDomains;
        this.apiKey = builder.apiKey;
        this.creationTimestamp = builder.creationTimestamp;
        this.version = builder.version;
    }

    public final boolean hasTokenDomains() {
        return this.tokenDomains != null && !(this.tokenDomains instanceof SdkAutoConstructList);
    }

    public final List<String> tokenDomains() {
        return this.tokenDomains;
    }

    public final String apiKey() {
        return this.apiKey;
    }

    public final Instant creationTimestamp() {
        return this.creationTimestamp;
    }

    public final Integer version() {
        return this.version;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTokenDomains() ? this.tokenDomains() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.apiKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof APIKeySummary)) {
            return false;
        }
        APIKeySummary other = (APIKeySummary)obj;
        return this.hasTokenDomains() == other.hasTokenDomains() && Objects.equals(this.tokenDomains(), other.tokenDomains()) && Objects.equals(this.apiKey(), other.apiKey()) && Objects.equals(this.creationTimestamp(), other.creationTimestamp()) && Objects.equals(this.version(), other.version());
    }

    public final String toString() {
        return ToString.builder((String)"APIKeySummary").add("TokenDomains", this.hasTokenDomains() ? this.tokenDomains() : null).add("APIKey", (Object)this.apiKey()).add("CreationTimestamp", (Object)this.creationTimestamp()).add("Version", (Object)this.version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TokenDomains": {
                return Optional.ofNullable(clazz.cast(this.tokenDomains()));
            }
            case "APIKey": {
                return Optional.ofNullable(clazz.cast(this.apiKey()));
            }
            case "CreationTimestamp": {
                return Optional.ofNullable(clazz.cast(this.creationTimestamp()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<APIKeySummary, T> g) {
        return obj -> g.apply((APIKeySummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> tokenDomains = DefaultSdkAutoConstructList.getInstance();
        private String apiKey;
        private Instant creationTimestamp;
        private Integer version;

        private BuilderImpl() {
        }

        private BuilderImpl(APIKeySummary model) {
            this.tokenDomains(model.tokenDomains);
            this.apiKey(model.apiKey);
            this.creationTimestamp(model.creationTimestamp);
            this.version(model.version);
        }

        public final Collection<String> getTokenDomains() {
            if (this.tokenDomains instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tokenDomains;
        }

        public final void setTokenDomains(Collection<String> tokenDomains) {
            this.tokenDomains = TokenDomainsCopier.copy(tokenDomains);
        }

        @Override
        public final Builder tokenDomains(Collection<String> tokenDomains) {
            this.tokenDomains = TokenDomainsCopier.copy(tokenDomains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tokenDomains(String ... tokenDomains) {
            this.tokenDomains(Arrays.asList(tokenDomains));
            return this;
        }

        public final String getApiKey() {
            return this.apiKey;
        }

        public final void setApiKey(String apiKey) {
            this.apiKey = apiKey;
        }

        @Override
        public final Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public final Instant getCreationTimestamp() {
            return this.creationTimestamp;
        }

        public final void setCreationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public final Integer getVersion() {
            return this.version;
        }

        public final void setVersion(Integer version) {
            this.version = version;
        }

        @Override
        public final Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public APIKeySummary build() {
            return new APIKeySummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, APIKeySummary> {
        public Builder tokenDomains(Collection<String> var1);

        public Builder tokenDomains(String ... var1);

        public Builder apiKey(String var1);

        public Builder creationTimestamp(Instant var1);

        public Builder version(Integer var1);
    }
}

