/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ResponseContentType {
    TEXT_PLAIN("TEXT_PLAIN"),
    TEXT_HTML("TEXT_HTML"),
    APPLICATION_JSON("APPLICATION_JSON"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResponseContentType> VALUE_MAP;
    private final String value;

    private ResponseContentType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResponseContentType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResponseContentType> knownValues() {
        EnumSet<ResponseContentType> knownValues = EnumSet.allOf(ResponseContentType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ResponseContentType.class, ResponseContentType::toString);
    }
}

