/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum MatchFieldType {
    URI("URI"),

    QUERY_STRING("QUERY_STRING"),

    HEADER("HEADER"),

    METHOD("METHOD"),

    BODY("BODY"),

    SINGLE_QUERY_ARG("SINGLE_QUERY_ARG"),

    ALL_QUERY_ARGS("ALL_QUERY_ARGS"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MatchFieldType> VALUE_MAP = EnumUtils.uniqueIndex(MatchFieldType.class,
            MatchFieldType::toString);

    private final String value;

    private MatchFieldType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return MatchFieldType corresponding to the value
     */
    public static MatchFieldType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link MatchFieldType}s
     */
    public static Set<MatchFieldType> knownValues() {
        Set<MatchFieldType> knownValues = EnumSet.allOf(MatchFieldType.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
