/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.vpclattice.VpcLatticeAsyncClient;
import software.amazon.awssdk.services.vpclattice.internal.UserAgentUtils;
import software.amazon.awssdk.services.vpclattice.model.ListTargetGroupsRequest;
import software.amazon.awssdk.services.vpclattice.model.ListTargetGroupsResponse;
import software.amazon.awssdk.services.vpclattice.model.TargetGroupSummary;

public class ListTargetGroupsPublisher
implements SdkPublisher<ListTargetGroupsResponse> {
    private final VpcLatticeAsyncClient client;
    private final ListTargetGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTargetGroupsPublisher(VpcLatticeAsyncClient client, ListTargetGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTargetGroupsPublisher(VpcLatticeAsyncClient client, ListTargetGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTargetGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTargetGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TargetGroupSummary> items() {
        Function<ListTargetGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListTargetGroupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListTargetGroupsResponseFetcher
    implements AsyncPageFetcher<ListTargetGroupsResponse> {
        private ListTargetGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListTargetGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTargetGroupsResponse> nextPage(ListTargetGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListTargetGroupsPublisher.this.client.listTargetGroups(ListTargetGroupsPublisher.this.firstRequest);
            }
            return ListTargetGroupsPublisher.this.client.listTargetGroups((ListTargetGroupsRequest)((Object)ListTargetGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

