/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.verifiedpermissions.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ActionIdentifier
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ActionIdentifier> {
    private static final SdkField<String> ACTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionType").getter(ActionIdentifier.getter(ActionIdentifier::actionType)).setter(ActionIdentifier.setter(Builder::actionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionType").build()}).build();
    private static final SdkField<String> ACTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionId").getter(ActionIdentifier.getter(ActionIdentifier::actionId)).setter(ActionIdentifier.setter(Builder::actionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_TYPE_FIELD, ACTION_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String actionType;
    private final String actionId;

    private ActionIdentifier(BuilderImpl builder) {
        this.actionType = builder.actionType;
        this.actionId = builder.actionId;
    }

    public final String actionType() {
        return this.actionType;
    }

    public final String actionId() {
        return this.actionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionType());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionIdentifier)) {
            return false;
        }
        ActionIdentifier other = (ActionIdentifier)obj;
        return Objects.equals(this.actionType(), other.actionType()) && Objects.equals(this.actionId(), other.actionId());
    }

    public final String toString() {
        return ToString.builder((String)"ActionIdentifier").add("ActionType", (Object)this.actionType()).add("ActionId", (Object)this.actionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actionType": {
                return Optional.ofNullable(clazz.cast(this.actionType()));
            }
            case "actionId": {
                return Optional.ofNullable(clazz.cast(this.actionId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActionIdentifier, T> g) {
        return obj -> g.apply((ActionIdentifier)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String actionType;
        private String actionId;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionIdentifier model) {
            this.actionType(model.actionType);
            this.actionId(model.actionId);
        }

        public final String getActionType() {
            return this.actionType;
        }

        public final void setActionType(String actionType) {
            this.actionType = actionType;
        }

        @Override
        public final Builder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        public final String getActionId() {
            return this.actionId;
        }

        public final void setActionId(String actionId) {
            this.actionId = actionId;
        }

        @Override
        public final Builder actionId(String actionId) {
            this.actionId = actionId;
            return this;
        }

        public ActionIdentifier build() {
            return new ActionIdentifier(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ActionIdentifier> {
        public Builder actionType(String var1);

        public Builder actionId(String var1);
    }
}

