/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.verifiedpermissions.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains a list of principal types, resource types, and actions that can be specified in policies stored in the same
 * policy store. If the validation mode for the policy store is set to <code>STRICT</code>, then policies that can't be
 * validated by this schema are rejected by Verified Permissions and can't be stored in the policy store.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SchemaDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<SchemaDefinition.Builder, SchemaDefinition> {
    private static final SdkField<String> CEDAR_JSON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("cedarJson").getter(getter(SchemaDefinition::cedarJson)).setter(setter(Builder::cedarJson))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cedarJson").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CEDAR_JSON_FIELD));

    private static final long serialVersionUID = 1L;

    private final String cedarJson;

    private final Type type;

    private SchemaDefinition(BuilderImpl builder) {
        this.cedarJson = builder.cedarJson;
        this.type = builder.type;
    }

    /**
     * <p>
     * A JSON string representation of the schema supported by applications that use this policy store. For more
     * information, see <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/userguide/schema.html">Policy
     * store schema</a> in the <i>Amazon Verified Permissions User Guide</i>.
     * </p>
     * 
     * @return A JSON string representation of the schema supported by applications that use this policy store. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/verifiedpermissions/latest/userguide/schema.html">Policy store
     *         schema</a> in the <i>Amazon Verified Permissions User Guide</i>.
     */
    public final String cedarJson() {
        return cedarJson;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cedarJson());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SchemaDefinition)) {
            return false;
        }
        SchemaDefinition other = (SchemaDefinition) obj;
        return Objects.equals(cedarJson(), other.cedarJson());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SchemaDefinition").add("CedarJson", cedarJson()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cedarJson":
            return Optional.ofNullable(clazz.cast(cedarJson()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #cedarJson()} initialized to the given value.
     *
     * <p>
     * A JSON string representation of the schema supported by applications that use this policy store. For more
     * information, see <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/userguide/schema.html">Policy
     * store schema</a> in the <i>Amazon Verified Permissions User Guide</i>.
     * </p>
     * 
     * @param cedarJson
     *        A JSON string representation of the schema supported by applications that use this policy store. For more
     *        information, see <a
     *        href="https://docs.aws.amazon.com/verifiedpermissions/latest/userguide/schema.html">Policy store
     *        schema</a> in the <i>Amazon Verified Permissions User Guide</i>.
     */
    public static SchemaDefinition fromCedarJson(String cedarJson) {
        return builder().cedarJson(cedarJson).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SchemaDefinition, T> g) {
        return obj -> g.apply((SchemaDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SchemaDefinition> {
        /**
         * <p>
         * A JSON string representation of the schema supported by applications that use this policy store. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/verifiedpermissions/latest/userguide/schema.html">Policy store schema</a>
         * in the <i>Amazon Verified Permissions User Guide</i>.
         * </p>
         * 
         * @param cedarJson
         *        A JSON string representation of the schema supported by applications that use this policy store. For
         *        more information, see <a
         *        href="https://docs.aws.amazon.com/verifiedpermissions/latest/userguide/schema.html">Policy store
         *        schema</a> in the <i>Amazon Verified Permissions User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cedarJson(String cedarJson);
    }

    static final class BuilderImpl implements Builder {
        private String cedarJson;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(SchemaDefinition model) {
            cedarJson(model.cedarJson);
        }

        public final String getCedarJson() {
            return cedarJson;
        }

        public final void setCedarJson(String cedarJson) {
            Object oldValue = this.cedarJson;
            this.cedarJson = cedarJson;
            handleUnionValueChange(Type.CEDAR_JSON, oldValue, this.cedarJson);
        }

        @Override
        public final Builder cedarJson(String cedarJson) {
            Object oldValue = this.cedarJson;
            this.cedarJson = cedarJson;
            handleUnionValueChange(Type.CEDAR_JSON, oldValue, this.cedarJson);
            return this;
        }

        @Override
        public SchemaDefinition build() {
            return new SchemaDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see SchemaDefinition#type()
     */
    public enum Type {
        CEDAR_JSON,

        UNKNOWN_TO_SDK_VERSION
    }
}
