/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.transfer.TransferClient;
import software.amazon.awssdk.services.transfer.internal.UserAgentUtils;
import software.amazon.awssdk.services.transfer.model.ListSecurityPoliciesRequest;
import software.amazon.awssdk.services.transfer.model.ListSecurityPoliciesResponse;

public class ListSecurityPoliciesIterable
implements SdkIterable<ListSecurityPoliciesResponse> {
    private final TransferClient client;
    private final ListSecurityPoliciesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSecurityPoliciesIterable(TransferClient client, ListSecurityPoliciesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSecurityPoliciesResponseFetcher();
    }

    public Iterator<ListSecurityPoliciesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> securityPolicyNames() {
        Function<ListSecurityPoliciesResponse, Iterator> getIterator = response -> {
            if (response != null && response.securityPolicyNames() != null) {
                return response.securityPolicyNames().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSecurityPoliciesResponseFetcher
    implements SyncPageFetcher<ListSecurityPoliciesResponse> {
        private ListSecurityPoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListSecurityPoliciesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSecurityPoliciesResponse nextPage(ListSecurityPoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListSecurityPoliciesIterable.this.client.listSecurityPolicies(ListSecurityPoliciesIterable.this.firstRequest);
            }
            return ListSecurityPoliciesIterable.this.client.listSecurityPolicies((ListSecurityPoliciesRequest)((Object)ListSecurityPoliciesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

