/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.transfer.model.DescribedUser;
import software.amazon.awssdk.services.transfer.model.TransferResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeUserResponse
extends TransferResponse
implements ToCopyableBuilder<Builder, DescribeUserResponse> {
    private static final SdkField<String> SERVER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerId").getter(DescribeUserResponse.getter(DescribeUserResponse::serverId)).setter(DescribeUserResponse.setter(Builder::serverId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerId").build()}).build();
    private static final SdkField<DescribedUser> USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("User").getter(DescribeUserResponse.getter(DescribeUserResponse::user)).setter(DescribeUserResponse.setter(Builder::user)).constructor(DescribedUser::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("User").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_ID_FIELD, USER_FIELD));
    private final String serverId;
    private final DescribedUser user;

    private DescribeUserResponse(BuilderImpl builder) {
        super(builder);
        this.serverId = builder.serverId;
        this.user = builder.user;
    }

    public final String serverId() {
        return this.serverId;
    }

    public final DescribedUser user() {
        return this.user;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.serverId());
        hashCode = 31 * hashCode + Objects.hashCode(this.user());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeUserResponse)) {
            return false;
        }
        DescribeUserResponse other = (DescribeUserResponse)((Object)obj);
        return Objects.equals(this.serverId(), other.serverId()) && Objects.equals(this.user(), other.user());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeUserResponse").add("ServerId", (Object)this.serverId()).add("User", (Object)this.user()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServerId": {
                return Optional.ofNullable(clazz.cast(this.serverId()));
            }
            case "User": {
                return Optional.ofNullable(clazz.cast(this.user()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeUserResponse, T> g) {
        return obj -> g.apply((DescribeUserResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TransferResponse.BuilderImpl
    implements Builder {
        private String serverId;
        private DescribedUser user;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeUserResponse model) {
            super(model);
            this.serverId(model.serverId);
            this.user(model.user);
        }

        public final String getServerId() {
            return this.serverId;
        }

        public final void setServerId(String serverId) {
            this.serverId = serverId;
        }

        @Override
        public final Builder serverId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        public final DescribedUser.Builder getUser() {
            return this.user != null ? this.user.toBuilder() : null;
        }

        public final void setUser(DescribedUser.BuilderImpl user) {
            this.user = user != null ? user.build() : null;
        }

        @Override
        public final Builder user(DescribedUser user) {
            this.user = user;
            return this;
        }

        @Override
        public DescribeUserResponse build() {
            return new DescribeUserResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TransferResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeUserResponse> {
        public Builder serverId(String var1);

        public Builder user(DescribedUser var1);

        default public Builder user(Consumer<DescribedUser.Builder> user) {
            return this.user((DescribedUser)((DescribedUser.Builder)DescribedUser.builder().applyMutation(user)).build());
        }
    }
}

